/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates;

import java.util.List;
import org.eclipse.edt.gen.javascript.CommonUtilities;
import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.Template;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.AsExpression;
import org.eclipse.edt.mof.egl.Assignment;
import org.eclipse.edt.mof.egl.BoxingExpression;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.MemberAccess;
import org.eclipse.edt.mof.egl.MemberName;
import org.eclipse.edt.mof.egl.NewExpression;
import org.eclipse.edt.mof.egl.NumericLiteral;
import org.eclipse.edt.mof.egl.Type;

public class ArrayTypeTemplate
extends JavaScriptTemplate {
    public Boolean isAssignmentBreakupWanted(ArrayType type, Context ctx, Assignment expr) {
        if (expr.getLHS() instanceof MemberAccess && CommonUtilities.isRUIWidget((Object)expr.getLHS().getQualifier().getType())) {
            return false;
        }
        return true;
    }

    public Boolean isListReorganizationWanted(Type type, Context ctx, Expression expr) {
        if (expr instanceof Assignment && ((Assignment)expr).getLHS() instanceof MemberAccess && CommonUtilities.isRUIWidget((Object)((Assignment)expr).getLHS().getQualifier().getType())) {
            return false;
        }
        return true;
    }

    public void genDefaultValue(ArrayType generic, Context ctx, TabbedWriter out, Field arg) {
        if (arg.isNullable()) {
            out.print("null");
        } else {
            this.processDefaultValue(generic, ctx, out);
        }
    }

    public void genDefaultValue(ArrayType generic, Context ctx, TabbedWriter out) {
        this.processDefaultValue(generic, ctx, out);
    }

    public void processDefaultValue(ArrayType generic, Context ctx, TabbedWriter out) {
        out.print(" []");
    }

    public void genContainerBasedNewExpression(ArrayType type, Context ctx, TabbedWriter out, NewExpression expr) {
        List arguments = expr.getArguments();
        this.genContainerBasedNewExpressionArguments(type, ctx, out, arguments, 0);
    }

    private void genContainerBasedNewExpressionArguments(ArrayType type, Context ctx, TabbedWriter out, List<Expression> arguments, int next) {
        Expression arraySize = null;
        String sizeVar = "";
        if (!(arguments.size() <= 0 || (arraySize = arguments.get(next)) instanceof NumericLiteral || arraySize instanceof MemberName && ((MemberName)arraySize).getMember() instanceof FunctionParameter)) {
            sizeVar = ctx.nextTempName();
        }
        ArrayType generic = type;
        String temporary = ctx.nextTempName();
        out.print("(function(" + sizeVar + ") { var ");
        out.print(temporary);
        out.print(" = []; ");
        out.print(temporary);
        out.print(".setType(");
        out.print("\"");
        this.genSignature(generic, ctx, out);
        out.print("\"");
        out.println(");");
        out.print("for (var i = 0; i < ");
        if (sizeVar.length() > 0) {
            out.print(sizeVar);
        } else if (arraySize != null) {
            ctx.invoke("genExpression", (EObject)arraySize, new Object[]{ctx, out});
        } else {
            out.print('0');
        }
        out.println("; i++) {");
        out.print(temporary);
        out.print("[i] = ");
        if (generic.elementsNullable()) {
            out.print("null");
        } else if (next < arguments.size() - 1) {
            this.genContainerBasedNewExpressionArguments(type, ctx, out, arguments, next + 1);
        } else {
            ctx.invoke("genDefaultValue", this.getArrayElementType(generic), new Object[]{ctx, out});
        }
        out.println(";}");
        out.print("return ");
        out.print(temporary);
        out.print(";})(");
        if (sizeVar.length() > 0) {
            ctx.invoke("genExpression", (EObject)arraySize, new Object[]{ctx, out});
        }
        out.print(')');
    }

    private Type getArrayElementType(ArrayType generic) {
        Type type = generic.getElementType();
        while (type instanceof ArrayType) {
            type = ((ArrayType)type).getElementType();
        }
        return type;
    }

    public void genSignature(ArrayType generic, Context ctx, TabbedWriter out) {
        if (!generic.getTypeArguments().isEmpty()) {
            int i = 0;
            while (i < generic.getTypeArguments().size()) {
                out.print("[");
                ++i;
            }
        }
        if (generic.elementsNullable()) {
            out.print("?");
        }
        ctx.invoke("genSignature", generic.getElementType(), new Object[]{ctx, out});
    }

    public void genTypeBasedAssignment(Type type, Context ctx, TabbedWriter out, Assignment arg) {
        String operator = "=";
        if (arg.getOperator() != null && arg.getOperator().length() > 0) {
            operator = arg.getOperator();
        }
        if ("::=".equals(operator)) {
            ctx.putAttribute((Object)arg.getLHS(), "EXPR_LHS", (Object)Boolean.FALSE);
            if (arg.getLHS() instanceof MemberAccess) {
                ctx.putAttribute((Object)((MemberAccess)arg.getLHS()).getNamedElement(), "EXPR_LHS", (Object)Boolean.FALSE);
            }
            ctx.invoke("genExpression", (EObject)arg.getLHS(), new Object[]{ctx, out});
            Expression rhs = arg.getRHS();
            if (rhs instanceof AsExpression) {
                rhs = ((AsExpression)rhs).getObjectExpr();
            }
            if (rhs.getType() instanceof ArrayType) {
                out.print(".appendAll(");
            } else {
                out.print(".appendElement(");
            }
            if (rhs instanceof BoxingExpression) {
                ctx.invoke("genExpression", (EObject)((BoxingExpression)rhs).getExpr(), new Object[]{ctx, out});
            } else {
                ctx.invoke("genExpression", (EObject)rhs, new Object[]{ctx, out});
            }
            out.print(")");
        } else {
            ctx.invokeSuper((Template)this, "genTypeBasedAssignment", type, new Object[]{ctx, out, arg});
        }
    }

    public void genRuntimeTypeName(ArrayType generic, Context ctx, TabbedWriter out, JavaScriptTemplate.TypeNameKind arg) {
        out.print("Array");
    }

    public void genFieldInfoTypeName(ArrayType generic, Context ctx, TabbedWriter out, JavaScriptTemplate.TypeNameKind arg) {
        ctx.invoke("genFieldInfoTypeName", generic.getElementType(), new Object[]{ctx, out, JavaScriptTemplate.TypeNameKind.JavascriptImplementation});
    }

    public void genConversionOperation(ArrayType type, Context ctx, TabbedWriter out, AsExpression arg) {
        Type etType = arg.getEType();
        out.print("egl.convertAnyToArrayType(");
        ctx.put((Object)("etType_for_array_conversion_" + arg.getObjectExpr()), (Object)etType);
        ctx.invoke("genExpression", (EObject)arg.getObjectExpr(), new Object[]{ctx, out});
        ctx.remove((Object)("etType_for_array_conversion_" + arg.getObjectExpr()));
        out.print(",\"");
        ctx.put((Object)"isaSignature", (Object)"true");
        ctx.invoke("genSignature", etType, new Object[]{ctx, out, arg});
        ctx.remove((Object)"isaSignature");
        out.print("\")");
    }

    public void genServiceCallbackArgType(ArrayType type, Context ctx, TabbedWriter out) {
        ctx.invoke("genRuntimeTypeName", type.getElementType(), new Object[]{ctx, out, JavaScriptTemplate.TypeNameKind.EGLImplementation});
    }
}

