/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class MultiPageEditorContentOutlinePage
extends ContentOutlinePage {
    private final MultiPageEditorPart editorPart;
    private final ISelectionChangedListener globalSelectionListener = this::fireSelectionChangedEvent;
    private final CopyOnWriteArrayList<ISelectionChangedListener> selectionListeners = new CopyOnWriteArrayList();
    private PageBook book;
    private MessagePage emptyPage;
    private IPage currentPage;
    private IPageChangedListener pageListener;
    private final Map<IEditorPart, IPage> pages = new HashMap<IEditorPart, IPage>();
    private final Map<IPage, SubActionBars> bars = new HashMap<IPage, SubActionBars>();

    public MultiPageEditorContentOutlinePage(MultiPageEditorPart editorPart) {
        this.editorPart = editorPart;
    }

    public void createControl(Composite parent) {
        this.book = new PageBook(parent, 0);
        this.emptyPage = new MessagePage();
        this.emptyPage.createControl((Composite)this.book);
        this.emptyPage.setMessage(UIText.MultiPageEditorContentOutlinePage_NoOutline);
        Object activePage = this.editorPart.getSelectedPage();
        if (activePage instanceof IEditorPart) {
            this.showPage(this.createOutlinePage((IEditorPart)activePage));
        } else {
            this.currentPage = this.emptyPage;
            this.book.showPage(this.emptyPage.getControl());
        }
        this.pageListener = event -> {
            Object newPage = event.getSelectedPage();
            if (!(newPage instanceof IEditorPart)) {
                this.showPage((IPage)this.emptyPage);
                return;
            }
            IPage newOutlinePage = this.pages.get(newPage);
            if (newOutlinePage == null) {
                newOutlinePage = this.createOutlinePage((IEditorPart)newPage);
            }
            this.showPage(newOutlinePage);
        };
        this.editorPart.addPageChangedListener(this.pageListener);
    }

    public void dispose() {
        if (this.pageListener != null) {
            this.editorPart.removePageChangedListener(this.pageListener);
            this.pageListener = null;
        }
        this.pages.clear();
        this.selectionListeners.clear();
        for (SubActionBars bar : this.bars.values()) {
            bar.dispose();
        }
        this.bars.clear();
        if (this.currentPage instanceof ISelectionProvider) {
            ((ISelectionProvider)this.currentPage).removeSelectionChangedListener(this.globalSelectionListener);
        }
        this.currentPage = null;
        if (this.book != null) {
            this.book.dispose();
            this.book = null;
        }
        if (this.emptyPage != null) {
            this.emptyPage.dispose();
            this.emptyPage = null;
        }
    }

    public Control getControl() {
        return this.book;
    }

    public void setFocus() {
        this.book.setFocus();
        this.currentPage.setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.addIfAbsent(listener);
    }

    public ISelection getSelection() {
        if (this.currentPage instanceof ISelectionProvider) {
            return ((ISelectionProvider)this.currentPage).getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        if (this.currentPage instanceof ISelectionProvider) {
            ((ISelectionProvider)this.currentPage).setSelection(selection);
        }
    }

    private void showPage(IPage page) {
        SubActionBars localBars;
        if (page == null) {
            page = this.emptyPage;
        }
        if (this.currentPage == page) {
            return;
        }
        if (this.currentPage instanceof ISelectionProvider) {
            ((ISelectionProvider)this.currentPage).removeSelectionChangedListener(this.globalSelectionListener);
        }
        if ((localBars = this.bars.get(this.currentPage)) != null) {
            localBars.deactivate();
        }
        this.currentPage = page;
        if (this.currentPage instanceof ISelectionProvider) {
            ((ISelectionProvider)this.currentPage).addSelectionChangedListener(this.globalSelectionListener);
        }
        localBars = this.bars.get(this.currentPage);
        Control control = page.getControl();
        if (control == null || control.isDisposed()) {
            page.createControl((Composite)this.book);
            page.setActionBars((IActionBars)localBars);
            control = page.getControl();
        }
        if (localBars != null) {
            localBars.activate();
        }
        this.getSite().getActionBars().updateActionBars();
        this.book.showPage(control);
        if (this.currentPage instanceof ISelectionProvider) {
            ISelection selection = ((ISelectionProvider)this.currentPage).getSelection();
            this.fireSelectionChangedEvent(new SelectionChangedEvent((ISelectionProvider)this.currentPage, selection));
        } else {
            this.fireSelectionChangedEvent(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)StructuredSelection.EMPTY));
        }
    }

    private IPage createOutlinePage(IEditorPart editor) {
        IContentOutlinePage outlinePage = (IContentOutlinePage)Adapters.adapt((Object)editor, IContentOutlinePage.class);
        if (!(outlinePage instanceof Page)) {
            this.pages.put(editor, (IPage)this.emptyPage);
            return this.emptyPage;
        }
        this.pages.put(editor, (IPage)outlinePage);
        IPageSite pageSite = this.getSite();
        ISelectionProvider provider = pageSite.getSelectionProvider();
        ((Page)outlinePage).init(this.getSite());
        pageSite.setSelectionProvider(provider);
        SubActionBars pageBars = new SubActionBars(this.getSite().getActionBars());
        this.bars.put((IPage)outlinePage, pageBars);
        return outlinePage;
    }

    private void fireSelectionChangedEvent(final SelectionChangedEvent event) {
        for (final ISelectionChangedListener listener : this.selectionListeners) {
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    listener.selectionChanged(event);
                }
            });
        }
    }
}

