/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.ui.internal.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.op.FeatureStartOperation;
import org.eclipse.egit.gitflow.op.GitFlowOperation;
import org.eclipse.egit.gitflow.ui.internal.JobFamilies;
import org.eclipse.egit.gitflow.ui.internal.UIText;
import org.eclipse.egit.gitflow.ui.internal.actions.GitFlowHandlerUtil;
import org.eclipse.egit.gitflow.ui.internal.actions.PostBranchCheckoutUiTask;
import org.eclipse.egit.gitflow.ui.internal.actions.StartDialog;
import org.eclipse.egit.gitflow.ui.internal.validation.FeatureNameValidator;
import org.eclipse.egit.ui.Activator;
import org.eclipse.ui.handlers.HandlerUtil;

public class FeatureStartHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        GitFlowRepository gfRepo = GitFlowHandlerUtil.getRepository(event);
        if (gfRepo == null) {
            return null;
        }
        StartDialog inputDialog = new StartDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), UIText.FeatureStartHandler_provideFeatureName, UIText.FeatureStartHandler_pleaseProvideANameForTheNewFeature, "", new FeatureNameValidator(gfRepo));
        if (inputDialog.open() != 0) {
            return null;
        }
        String featureName = inputDialog.getValue();
        int timeout = Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout");
        FeatureStartOperation operation = new FeatureStartOperation(gfRepo, featureName, timeout);
        String fullBranchName = gfRepo.getConfig().getFullFeatureBranchName(featureName);
        JobUtil.scheduleUserWorkspaceJob((IEGitOperation)operation, (String)UIText.FeatureStartHandler_startingNewFeature, (Object)JobFamilies.GITFLOW_FAMILY, (IJobChangeListener)new PostBranchCheckoutUiTask(gfRepo, fullBranchName, (GitFlowOperation)operation));
        return null;
    }
}

