/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.subsystem.SubsystemClient;
import org.apache.sshd.client.subsystem.sftp.SftpInputStreamWithChannel;
import org.apache.sshd.client.subsystem.sftp.SftpIterableDirEntry;
import org.apache.sshd.client.subsystem.sftp.SftpOutputStreamWithChannel;
import org.apache.sshd.client.subsystem.sftp.SftpRemotePathChannel;
import org.apache.sshd.client.subsystem.sftp.StfpIterableDirHandle;
import org.apache.sshd.client.subsystem.sftp.extensions.SftpClientExtension;
import org.apache.sshd.common.subsystem.sftp.SftpHelper;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;

public interface SftpClient
extends SubsystemClient {
    public static final String NAME_DECODING_CHARSET = "sftp-name-decoding-charset";
    public static final Charset DEFAULT_NAME_DECODING_CHARSET = StandardCharsets.UTF_8;
    public static final DirEntry[] EMPTY_DIR_ENTRIES = new DirEntry[0];
    public static final int MIN_BUFFER_SIZE = 127;
    public static final int MIN_READ_BUFFER_SIZE = 127;
    public static final int MIN_WRITE_BUFFER_SIZE = 127;
    public static final int IO_BUFFER_SIZE = 32768;
    public static final int DEFAULT_READ_BUFFER_SIZE = 32768;
    public static final int DEFAULT_WRITE_BUFFER_SIZE = 32768;
    public static final long DEFAULT_WAIT_TIMEOUT;
    public static final String SFTP_CHANNEL_OPEN_TIMEOUT = "sftp-channel-open-timeout";
    public static final long DEFAULT_CHANNEL_OPEN_TIMEOUT;
    public static final Set<OpenMode> DEFAULT_CHANNEL_MODES;

    public int getVersion();

    default public String getName() {
        return "sftp";
    }

    public Charset getNameDecodingCharset();

    public void setNameDecodingCharset(Charset var1);

    public NavigableMap<String, byte[]> getServerExtensions();

    public boolean isClosing();

    default public CloseableHandle open(String path) throws IOException {
        return this.open(path, Collections.emptySet());
    }

    default public CloseableHandle open(String path, OpenMode ... options) throws IOException {
        return this.open(path, GenericUtils.of((Enum[])options));
    }

    public CloseableHandle open(String var1, Collection<OpenMode> var2) throws IOException;

    public void close(Handle var1) throws IOException;

    public void remove(String var1) throws IOException;

    default public void rename(String oldPath, String newPath) throws IOException {
        this.rename(oldPath, newPath, Collections.emptySet());
    }

    default public void rename(String oldPath, String newPath, CopyMode ... options) throws IOException {
        this.rename(oldPath, newPath, GenericUtils.of((Enum[])options));
    }

    public void rename(String var1, String var2, Collection<CopyMode> var3) throws IOException;

    default public int read(Handle handle, long fileOffset, byte[] dst) throws IOException {
        return this.read(handle, fileOffset, dst, null);
    }

    default public int read(Handle handle, long fileOffset, byte[] dst, AtomicReference<Boolean> eofSignalled) throws IOException {
        return this.read(handle, fileOffset, dst, 0, dst.length, eofSignalled);
    }

    default public int read(Handle handle, long fileOffset, byte[] dst, int dstOffset, int len) throws IOException {
        return this.read(handle, fileOffset, dst, dstOffset, len, null);
    }

    public int read(Handle var1, long var2, byte[] var4, int var5, int var6, AtomicReference<Boolean> var7) throws IOException;

    default public void write(Handle handle, long fileOffset, byte[] src) throws IOException {
        this.write(handle, fileOffset, src, 0, src.length);
    }

    public void write(Handle var1, long var2, byte[] var4, int var5, int var6) throws IOException;

    public void mkdir(String var1) throws IOException;

    public void rmdir(String var1) throws IOException;

    public CloseableHandle openDir(String var1) throws IOException;

    default public List<DirEntry> readDir(Handle handle) throws IOException {
        return this.readDir(handle, null);
    }

    public List<DirEntry> readDir(Handle var1, AtomicReference<Boolean> var2) throws IOException;

    default public Iterable<DirEntry> listDir(Handle handle) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("listDir(" + handle + ") client is closed");
        }
        return new StfpIterableDirHandle(this, handle);
    }

    public String canonicalPath(String var1) throws IOException;

    public Attributes stat(String var1) throws IOException;

    public Attributes lstat(String var1) throws IOException;

    public Attributes stat(Handle var1) throws IOException;

    public void setStat(String var1, Attributes var2) throws IOException;

    public void setStat(Handle var1, Attributes var2) throws IOException;

    public String readLink(String var1) throws IOException;

    default public void symLink(String linkPath, String targetPath) throws IOException {
        this.link(linkPath, targetPath, true);
    }

    public void link(String var1, String var2, boolean var3) throws IOException;

    public void lock(Handle var1, long var2, long var4, int var6) throws IOException;

    public void unlock(Handle var1, long var2, long var4) throws IOException;

    default public SftpRemotePathChannel openRemotePathChannel(String path, OpenOption ... options) throws IOException {
        return this.openRemotePathChannel(path, GenericUtils.isEmpty((Object[])options) ? Collections.emptyList() : Arrays.asList(options));
    }

    default public SftpRemotePathChannel openRemotePathChannel(String path, Collection<? extends OpenOption> options) throws IOException {
        return this.openRemoteFileChannel(path, OpenMode.fromOpenOptions(options));
    }

    default public SftpRemotePathChannel openRemoteFileChannel(String path, OpenMode ... modes) throws IOException {
        return this.openRemoteFileChannel(path, GenericUtils.isEmpty((Object[])modes) ? Collections.emptyList() : Arrays.asList(modes));
    }

    default public SftpRemotePathChannel openRemoteFileChannel(String path, Collection<OpenMode> modes) throws IOException {
        return new SftpRemotePathChannel(path, this, false, GenericUtils.isEmpty(modes) ? DEFAULT_CHANNEL_MODES : modes);
    }

    default public Iterable<DirEntry> readDir(String path) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("readDir(" + path + ") client is closed");
        }
        return new SftpIterableDirEntry(this, path);
    }

    default public InputStream read(String path) throws IOException {
        return this.read(path, 32768);
    }

    default public InputStream read(String path, int bufferSize) throws IOException {
        return this.read(path, bufferSize, EnumSet.of(OpenMode.Read));
    }

    default public InputStream read(String path, OpenMode ... mode) throws IOException {
        return this.read(path, 32768, mode);
    }

    default public InputStream read(String path, int bufferSize, OpenMode ... mode) throws IOException {
        return this.read(path, bufferSize, GenericUtils.of((Enum[])mode));
    }

    default public InputStream read(String path, Collection<OpenMode> mode) throws IOException {
        return this.read(path, 32768, mode);
    }

    default public InputStream read(String path, int bufferSize, Collection<OpenMode> mode) throws IOException {
        if (bufferSize < 127) {
            throw new IllegalArgumentException("Insufficient read buffer size: " + bufferSize + ", min.=" + 127);
        }
        if (!this.isOpen()) {
            throw new IOException("read(" + path + ")[" + mode + "] size=" + bufferSize + ": client is closed");
        }
        return new SftpInputStreamWithChannel(this, bufferSize, path, mode);
    }

    default public OutputStream write(String path) throws IOException {
        return this.write(path, 32768);
    }

    default public OutputStream write(String path, int bufferSize) throws IOException {
        return this.write(path, bufferSize, EnumSet.of(OpenMode.Write, OpenMode.Create, OpenMode.Truncate));
    }

    default public OutputStream write(String path, OpenMode ... mode) throws IOException {
        return this.write(path, 32768, mode);
    }

    default public OutputStream write(String path, int bufferSize, OpenMode ... mode) throws IOException {
        return this.write(path, bufferSize, GenericUtils.of((Enum[])mode));
    }

    default public OutputStream write(String path, Collection<OpenMode> mode) throws IOException {
        return this.write(path, 32768, mode);
    }

    default public OutputStream write(String path, int bufferSize, Collection<OpenMode> mode) throws IOException {
        if (bufferSize < 127) {
            throw new IllegalArgumentException("Insufficient write buffer size: " + bufferSize + ", min.=" + 127);
        }
        if (!this.isOpen()) {
            throw new IOException("write(" + path + ")[" + mode + "] size=" + bufferSize + ": client is closed");
        }
        return new SftpOutputStreamWithChannel(this, bufferSize, path, mode);
    }

    public <E extends SftpClientExtension> E getExtension(Class<? extends E> var1);

    public SftpClientExtension getExtension(String var1);

    static {
        DEFAULT_CHANNEL_OPEN_TIMEOUT = DEFAULT_WAIT_TIMEOUT = TimeUnit.SECONDS.toMillis(15L);
        DEFAULT_CHANNEL_MODES = Collections.unmodifiableSet(EnumSet.of(OpenMode.Read, OpenMode.Write));
    }

    public static enum Attribute {
        Size,
        UidGid,
        Perms,
        OwnerGroup,
        AccessTime,
        ModifyTime,
        CreateTime,
        Acl,
        Extensions;

    }

    public static class Attributes {
        private Set<Attribute> flags = EnumSet.noneOf(Attribute.class);
        private int type = 5;
        private int perms;
        private int uid;
        private int gid;
        private String owner;
        private String group;
        private long size;
        private FileTime accessTime;
        private FileTime createTime;
        private FileTime modifyTime;
        private List<AclEntry> acl;
        private Map<String, byte[]> extensions = Collections.emptyMap();

        public Set<Attribute> getFlags() {
            return this.flags;
        }

        public Attributes addFlag(Attribute flag) {
            this.flags.add(flag);
            return this;
        }

        public Attributes removeFlag(Attribute flag) {
            this.flags.remove((Object)flag);
            return this;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public long getSize() {
            return this.size;
        }

        public Attributes size(long size) {
            this.setSize(size);
            return this;
        }

        public void setSize(long size) {
            this.size = size;
            this.addFlag(Attribute.Size);
        }

        public String getOwner() {
            return this.owner;
        }

        public Attributes owner(String owner) {
            this.setOwner(owner);
            return this;
        }

        public void setOwner(String owner) {
            this.owner = owner;
            if (GenericUtils.isEmpty((CharSequence)owner)) {
                this.removeFlag(Attribute.OwnerGroup);
            } else {
                this.addFlag(Attribute.OwnerGroup);
            }
        }

        public String getGroup() {
            return this.group;
        }

        public Attributes group(String group) {
            this.setGroup(group);
            return this;
        }

        public void setGroup(String group) {
            this.group = group;
            if (GenericUtils.isEmpty((CharSequence)group)) {
                this.removeFlag(Attribute.OwnerGroup);
            } else {
                this.addFlag(Attribute.OwnerGroup);
            }
        }

        public int getUserId() {
            return this.uid;
        }

        public int getGroupId() {
            return this.gid;
        }

        public Attributes owner(int uid, int gid) {
            this.uid = uid;
            this.gid = gid;
            this.addFlag(Attribute.UidGid);
            return this;
        }

        public int getPermissions() {
            return this.perms;
        }

        public Attributes perms(int perms) {
            this.setPermissions(perms);
            return this;
        }

        public void setPermissions(int perms) {
            this.perms = perms;
            this.addFlag(Attribute.Perms);
        }

        public FileTime getAccessTime() {
            return this.accessTime;
        }

        public Attributes accessTime(long atime) {
            return this.accessTime(atime, TimeUnit.SECONDS);
        }

        public Attributes accessTime(long atime, TimeUnit unit) {
            return this.accessTime(FileTime.from(atime, unit));
        }

        public Attributes accessTime(FileTime atime) {
            this.setAccessTime(atime);
            return this;
        }

        public void setAccessTime(FileTime atime) {
            this.accessTime = Objects.requireNonNull(atime, "No access time");
            this.addFlag(Attribute.AccessTime);
        }

        public FileTime getCreateTime() {
            return this.createTime;
        }

        public Attributes createTime(long ctime) {
            return this.createTime(ctime, TimeUnit.SECONDS);
        }

        public Attributes createTime(long ctime, TimeUnit unit) {
            return this.createTime(FileTime.from(ctime, unit));
        }

        public Attributes createTime(FileTime ctime) {
            this.setCreateTime(ctime);
            return this;
        }

        public void setCreateTime(FileTime ctime) {
            this.createTime = Objects.requireNonNull(ctime, "No create time");
            this.addFlag(Attribute.CreateTime);
        }

        public FileTime getModifyTime() {
            return this.modifyTime;
        }

        public Attributes modifyTime(long mtime) {
            return this.modifyTime(mtime, TimeUnit.SECONDS);
        }

        public Attributes modifyTime(long mtime, TimeUnit unit) {
            return this.modifyTime(FileTime.from(mtime, unit));
        }

        public Attributes modifyTime(FileTime mtime) {
            this.setModifyTime(mtime);
            return this;
        }

        public void setModifyTime(FileTime mtime) {
            this.modifyTime = Objects.requireNonNull(mtime, "No modify time");
            this.addFlag(Attribute.ModifyTime);
        }

        public List<AclEntry> getAcl() {
            return this.acl;
        }

        public Attributes acl(List<AclEntry> acl) {
            this.setAcl(acl);
            return this;
        }

        public void setAcl(List<AclEntry> acl) {
            this.acl = Objects.requireNonNull(acl, "No ACLs");
            this.addFlag(Attribute.Acl);
        }

        public Map<String, byte[]> getExtensions() {
            return this.extensions;
        }

        public Attributes extensions(Map<String, byte[]> extensions) {
            this.setExtensions(extensions);
            return this;
        }

        public void setStringExtensions(Map<String, String> extensions) {
            this.setExtensions(SftpHelper.toBinaryExtensions(extensions));
        }

        public void setExtensions(Map<String, byte[]> extensions) {
            this.extensions = Objects.requireNonNull(extensions, "No extensions");
            this.addFlag(Attribute.Extensions);
        }

        public boolean isRegularFile() {
            return (this.getPermissions() & 0xF000) == 32768;
        }

        public boolean isDirectory() {
            return (this.getPermissions() & 0xF000) == 16384;
        }

        public boolean isSymbolicLink() {
            return (this.getPermissions() & 0xF000) == 40960;
        }

        public boolean isOther() {
            return !this.isRegularFile() && !this.isDirectory() && !this.isSymbolicLink();
        }

        public String toString() {
            return "type=" + this.getType() + ";size=" + this.getSize() + ";uid=" + this.getUserId() + ";gid=" + this.getGroupId() + ";perms=0x" + Integer.toHexString(this.getPermissions()) + ";flags=" + this.getFlags() + ";owner=" + this.getOwner() + ";group=" + this.getGroup() + ";aTime=" + this.getAccessTime() + ";cTime=" + this.getCreateTime() + ";mTime=" + this.getModifyTime() + ";extensions=" + this.getExtensions().keySet();
        }
    }

    public static abstract class CloseableHandle
    extends Handle
    implements Channel,
    Closeable {
        protected CloseableHandle(String path, byte[] id) {
            super(path, id);
        }
    }

    public static enum CopyMode {
        Atomic,
        Overwrite;

    }

    public static class DirEntry {
        public static final Comparator<DirEntry> BY_CASE_SENSITIVE_FILENAME = new Comparator<DirEntry>(){

            @Override
            public int compare(DirEntry o1, DirEntry o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return GenericUtils.safeCompare((String)o1.getFilename(), (String)o2.getFilename(), (boolean)true);
            }
        };
        public static final Comparator<DirEntry> BY_CASE_INSENSITIVE_FILENAME = new Comparator<DirEntry>(){

            @Override
            public int compare(DirEntry o1, DirEntry o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return GenericUtils.safeCompare((String)o1.getFilename(), (String)o2.getFilename(), (boolean)false);
            }
        };
        private final String filename;
        private final String longFilename;
        private final Attributes attributes;

        public DirEntry(String filename, String longFilename, Attributes attributes) {
            this.filename = filename;
            this.longFilename = longFilename;
            this.attributes = attributes;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getLongFilename() {
            return this.longFilename;
        }

        public Attributes getAttributes() {
            return this.attributes;
        }

        public String toString() {
            return this.getFilename() + "[" + this.getLongFilename() + "]: " + this.getAttributes();
        }
    }

    public static class Handle {
        private final String path;
        private final byte[] id;

        Handle(String path, byte[] id) {
            this.path = ValidateUtils.checkNotNullAndNotEmpty((String)path, (String)"No remote path");
            this.id = (byte[])ValidateUtils.checkNotNullAndNotEmpty((byte[])id, (String)"No handle ID").clone();
        }

        public String getPath() {
            return this.path;
        }

        public int length() {
            return this.id.length;
        }

        public byte[] getIdentifier() {
            return (byte[])this.id.clone();
        }

        public int hashCode() {
            return Arrays.hashCode(this.id);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Handle)) {
                return false;
            }
            return Arrays.equals(this.id, ((Handle)obj).id);
        }

        public String toString() {
            return this.getPath() + ": " + BufferUtils.toHex((char)'\u0000', (byte[])this.id);
        }
    }

    public static enum OpenMode {
        Read,
        Write,
        Append,
        Create,
        Truncate,
        Exclusive;

        public static final Set<OpenOption> SUPPORTED_OPTIONS;

        public static Set<OpenMode> fromOpenOptions(Collection<? extends OpenOption> options) {
            if (GenericUtils.isEmpty(options)) {
                return Collections.emptySet();
            }
            EnumSet<OpenMode> modes = EnumSet.noneOf(OpenMode.class);
            for (OpenOption openOption : options) {
                if (openOption == StandardOpenOption.READ) {
                    modes.add(Read);
                    continue;
                }
                if (openOption == StandardOpenOption.APPEND) {
                    modes.add(Append);
                    continue;
                }
                if (openOption == StandardOpenOption.CREATE) {
                    modes.add(Create);
                    continue;
                }
                if (openOption == StandardOpenOption.TRUNCATE_EXISTING) {
                    modes.add(Truncate);
                    continue;
                }
                if (openOption == StandardOpenOption.WRITE) {
                    modes.add(Write);
                    continue;
                }
                if (openOption == StandardOpenOption.CREATE_NEW) {
                    modes.add(Create);
                    modes.add(Exclusive);
                    continue;
                }
                if (openOption == StandardOpenOption.SPARSE) continue;
                throw new IllegalArgumentException("Unsupported open option: " + openOption);
            }
            return modes;
        }

        static {
            SUPPORTED_OPTIONS = Collections.unmodifiableSet(EnumSet.of(StandardOpenOption.READ, new StandardOpenOption[]{StandardOpenOption.APPEND, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW, StandardOpenOption.SPARSE}));
        }
    }
}

