/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml.internal.markers;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.m2e.editor.xml.internal.Messages;
import org.eclipse.m2e.editor.xml.internal.XmlUtils;
import org.eclipse.m2e.editor.xml.internal.markers.AbstractPomProblemResolution;
import org.eclipse.m2e.editor.xml.internal.markers.MavenMarkerResolutionGenerator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ManagedVersionRemovalResolution
extends AbstractPomProblemResolution {
    final boolean isDependency;

    public ManagedVersionRemovalResolution(IMarker marker, boolean dependency) {
        super(marker);
        this.isDependency = dependency;
    }

    public int getOrder() {
        return 100;
    }

    @Override
    public boolean canFix(String editorHint) {
        return this.isDependency ? MavenMarkerResolutionGenerator.isDependencyVersionOverride(editorHint) : MavenMarkerResolutionGenerator.isPluginVersionOverride(editorHint);
    }

    public String getLabel() {
        return Messages.PomQuickAssistProcessor_title_version;
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
    }

    public String getDescription() {
        if (this.getQuickAssistContext() != null) {
            IDocument doc = this.getQuickAssistContext().getSourceViewer().getDocument();
            String[] toRet = new String[1];
            XmlUtils.performOnRootElement(doc, (node, structured) -> {
                Element artifact = this.findArtifactElement((Element)node, this.getMarker());
                if (artifact != null) {
                    Element value = XmlUtils.findChild(artifact, "version");
                    stringArray[0] = ManagedVersionRemovalResolution.previewForRemovedElement(doc, value);
                }
            });
            if (toRet[0] != null) {
                return toRet[0];
            }
        }
        return Messages.PomQuickAssistProcessor_remove_hint;
    }

    @Override
    protected void processFix(IStructuredDocument doc, Element root, List<IMarker> markers) {
        if ("project".equals(root.getNodeName())) {
            for (IMarker marker : markers) {
                IndexedRegion off;
                int offset;
                Element artifact = this.findArtifactElement(root, marker);
                if (artifact == null) {
                    this.LOG.error("Unable to find the marked element");
                    continue;
                }
                Element value = XmlUtils.findChild(artifact, "version");
                if (value == null || !(value instanceof IndexedRegion) || (offset = (off = (IndexedRegion)value).getStartOffset()) <= 0) continue;
                Node prev = value.getNextSibling();
                if (prev instanceof Text) {
                    off = (IndexedRegion)prev;
                }
                DeleteEdit edit = new DeleteEdit(offset, off.getEndOffset() - offset);
                try {
                    edit.apply((IDocument)doc);
                    marker.delete();
                }
                catch (Exception e) {
                    this.LOG.error("Unable to remove the element", (Throwable)e);
                }
            }
        }
    }

    Element findArtifactElement(Element root, IMarker marker) {
        Element profileRoot;
        if (root == null) {
            return null;
        }
        String groupId = marker.getAttribute("groupId", null);
        String artifactId = marker.getAttribute("artifactId", null);
        assert (groupId != null);
        assert (artifactId != null);
        String profile = marker.getAttribute("profile", null);
        Element artifactParent = root;
        if (profile != null && (profileRoot = XmlUtils.findChild(root, "profiles")) != null) {
            for (Element prf : XmlUtils.findChilds(profileRoot, "profile")) {
                if (!profile.equals(XmlUtils.getTextValue(XmlUtils.findChild(prf, "id")))) continue;
                artifactParent = prf;
                break;
            }
        }
        if (!this.isDependency) {
            artifactParent = XmlUtils.findChild(artifactParent, "build");
        }
        if (artifactParent == null) {
            return null;
        }
        Element list = XmlUtils.findChild(artifactParent, this.isDependency ? "dependencies" : "plugins");
        if (list == null) {
            return null;
        }
        Element artifact = null;
        for (Element art : XmlUtils.findChilds(list, this.isDependency ? "dependency" : "plugin")) {
            String grpString = XmlUtils.getTextValue(XmlUtils.findChild(art, "groupId"));
            String artString = XmlUtils.getTextValue(XmlUtils.findChild(art, "artifactId"));
            if (!groupId.equals(grpString) || !artifactId.equals(artString)) continue;
            artifact = art;
            break;
        }
        return artifact;
    }
}

