/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.preferences.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.preferences.EditorPreferenceNames;
import org.eclipse.wst.sse.ui.internal.preferences.OverlayPreferenceStore;
import org.eclipse.wst.sse.ui.internal.preferences.TabFolderLayout;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ColorEditor;
import org.eclipse.wst.sse.ui.internal.preferences.ui.IPreferenceTab;
import org.eclipse.wst.sse.ui.internal.preferences.ui.TextHoverPreferenceTab;
import org.eclipse.wst.sse.ui.internal.provisional.preferences.CommonEditorPreferenceNames;

public class StructuredTextEditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private List<Image> colorPreviewImages;
    private ColorEditor fAppearanceColorEditor;
    private final ColorEntry[] fAppearanceColorListModel = new ColorEntry[]{new ColorEntry(SSEUIMessages.StructuredTextEditorPreferencePage_2, EditorPreferenceNames.MATCHING_BRACKETS_COLOR, null, null), new ColorEntry(SSEUIMessages.StructuredTextEditorPreferencePage_41, "content_assist_proposals_background", null, null), new ColorEntry(SSEUIMessages.StructuredTextEditorPreferencePage_42, "content_assist_proposals_foreground", null, null), new ColorEntry(SSEUIMessages.StructuredTextEditorPreferencePage_43, "content_assist_parameters_background", null, null), new ColorEntry(SSEUIMessages.StructuredTextEditorPreferencePage_44, "content_assist_parameters_foreground", null, null)};
    private TableViewer fAppearanceColorTableViewer;
    private Map<Button, String> fCheckBoxes = new HashMap<Button, String>();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            StructuredTextEditorPreferencePage.this.fOverlayStore.setValue((String)StructuredTextEditorPreferencePage.this.fCheckBoxes.get(button), button.getSelection());
        }
    };
    private Map<ColorEditor, String> fColorButtons = new HashMap<ColorEditor, String>();
    private OverlayPreferenceStore fOverlayStore;
    private IPreferenceTab[] fTabs = null;

    public StructuredTextEditorPreferencePage() {
        this.setDescription(SSEUIMessages.StructuredTextEditorPreferencePage_6);
        this.setPreferenceStore(SSEUIPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = new OverlayPreferenceStore(this.getPreferenceStore(), this.createOverlayStoreKeys());
    }

    private Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    public void applyToStatusLine(DialogPage page, IStatus status) {
        String message = status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                page.setMessage(message, 0);
                page.setErrorMessage(null);
                break;
            }
            case 2: {
                page.setMessage(message, 2);
                page.setErrorMessage(null);
                break;
            }
            case 1: {
                page.setMessage(message, 1);
                page.setErrorMessage(null);
                break;
            }
            default: {
                if (message.length() == 0) {
                    message = null;
                }
                page.setMessage(null);
                page.setErrorMessage(message);
            }
        }
    }

    private Control createAppearancePage(Composite parent) {
        Composite appearanceComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        appearanceComposite.setLayout((Layout)layout);
        String label = SSEUIMessages.StructuredTextEditorPreferencePage_20;
        this.addCheckBox(appearanceComposite, label, EditorPreferenceNames.MATCHING_BRACKETS, 0);
        label = SSEUIMessages.StructuredTextEditorPreferencePage_30;
        this.addCheckBox(appearanceComposite, label, CommonEditorPreferenceNames.EVALUATE_TEMPORARY_PROBLEMS, 0);
        PreferenceLinkArea contentTypeArea = new PreferenceLinkArea(appearanceComposite, 0, "ValidationPreferencePage", SSEUIMessages.StructuredTextEditorPreferencePage_40, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        GridData data = new GridData(768);
        data.horizontalIndent = 20;
        contentTypeArea.getControl().setLayoutData((Object)data);
        label = SSEUIMessages.StructuredTextEditorPreferencePage_39;
        this.addCheckBox(appearanceComposite, label, "showUnknownContentTypeMsg", 0);
        label = SSEUIMessages.StructuredTextEditorPreferencePage_3;
        this.addCheckBox(appearanceComposite, label, "foldingEnabled", 0);
        label = SSEUIMessages.StructuredTextEditorPreferencePage_1;
        this.addCheckBox(appearanceComposite, label, "semanticHighlighting", 0);
        Label l = new Label(appearanceComposite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        l.setLayoutData((Object)gd);
        l = new Label(appearanceComposite, 16384);
        l.setText(SSEUIMessages.StructuredTextEditorPreferencePage_23);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(appearanceComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        Composite tableComposite = new Composite(editorComposite, 0);
        GridData tableGD = new GridData(1040);
        tableComposite.setLayoutData((Object)tableGD);
        this.fAppearanceColorTableViewer = new TableViewer(tableComposite, 2564);
        this.initializeAppearanceColorTable(tableComposite);
        Arrays.sort(this.fAppearanceColorListModel);
        this.fAppearanceColorTableViewer.setInput((Object)this.fAppearanceColorListModel);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        l = new Label(stylesComposite, 16384);
        final String buttonLabel = SSEUIMessages.StructuredTextEditorPreferencePage_24;
        l.setText(buttonLabel);
        gd = new GridData();
        gd.horizontalAlignment = 1;
        l.setLayoutData((Object)gd);
        this.fAppearanceColorEditor = new ColorEditor(stylesComposite);
        Button foregroundColorButton = this.fAppearanceColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!StructuredTextEditorPreferencePage.this.fAppearanceColorTableViewer.getSelection().isEmpty()) {
                    Object element = StructuredTextEditorPreferencePage.this.fAppearanceColorTableViewer.getStructuredSelection().getFirstElement();
                    int i = Arrays.binarySearch(StructuredTextEditorPreferencePage.this.fAppearanceColorListModel, element);
                    String key = ((StructuredTextEditorPreferencePage)StructuredTextEditorPreferencePage.this).fAppearanceColorListModel[i].colorKey;
                    PreferenceConverter.setValue((IPreferenceStore)StructuredTextEditorPreferencePage.this.fOverlayStore, (String)key, (RGB)StructuredTextEditorPreferencePage.this.fAppearanceColorEditor.getColorValue());
                    StructuredTextEditorPreferencePage.this.fAppearanceColorTableViewer.refresh(element, true);
                }
            }
        });
        foregroundColorButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = buttonLabel;
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)appearanceComposite, "org.eclipse.wst.sse.ui.sted0001");
        return appearanceComposite;
    }

    protected Control createContents(Composite parent) {
        TextHoverPreferenceTab hoversTab = new TextHoverPreferenceTab(this, this.fOverlayStore);
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        TabItem item = new TabItem(folder, 0);
        item.setText(SSEUIMessages.StructuredTextEditorPreferencePage_0);
        item.setControl(this.createAppearancePage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(hoversTab.getTitle());
        item.setControl(hoversTab.createContents((Composite)folder));
        this.fTabs = new IPreferenceTab[]{hoversTab};
        this.initialize();
        Dialog.applyDialogFont((Control)folder);
        return folder;
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, CommonEditorPreferenceNames.EVALUATE_TEMPORARY_PROBLEMS));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showUnknownContentTypeMsg"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "foldingEnabled"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "semanticHighlighting"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, EditorPreferenceNames.MATCHING_BRACKETS));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, EditorPreferenceNames.MATCHING_BRACKETS_COLOR));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_proposals_background"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_proposals_foreground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_parameters_background"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_parameters_foreground"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public void dispose() {
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        super.dispose();
    }

    private void handleAppearanceColorViewerSelection() {
        if (!this.fAppearanceColorTableViewer.getSelection().isEmpty()) {
            Object firstElement = this.fAppearanceColorTableViewer.getStructuredSelection().getFirstElement();
            int i = Arrays.binarySearch(this.fAppearanceColorListModel, firstElement);
            String key = this.fAppearanceColorListModel[i].colorKey;
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
            this.fAppearanceColorEditor.setColorValue(rgb);
        } else {
            this.fAppearanceColorTableViewer.refresh(true);
        }
    }

    public void init(IWorkbench workbench) {
    }

    private void initialize() {
        this.initializeFields();
    }

    private void initializeAppearanceColorTable(final Composite tableComposite) {
        this.fAppearanceColorTableViewer.addSelectionChangedListener(event -> this.handleAppearanceColorViewerSelection());
        this.colorPreviewImages = new ArrayList<Image>();
        this.fAppearanceColorTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fAppearanceColorTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                ColorEntry colorEntry = (ColorEntry)element;
                if (colorEntry.isSystemDefault() && colorEntry.systemColorRGB == null) {
                    return null;
                }
                RGB rgb = colorEntry.isSystemDefault() ? colorEntry.systemColorRGB : colorEntry.getRGB();
                Color color = new Color((Device)tableComposite.getParent().getDisplay(), rgb.red, rgb.green, rgb.blue);
                int dimensions = 10;
                Image image = new Image((Device)tableComposite.getParent().getDisplay(), dimensions, dimensions);
                GC gc = new GC((Drawable)image);
                gc.setBackground(color);
                gc.fillRectangle(0, 0, dimensions, dimensions);
                gc.setBackground(new Color((Device)tableComposite.getParent().getDisplay(), 0, 0, 0));
                gc.setLineWidth(2);
                gc.drawRectangle(0, 0, dimensions, dimensions);
                gc.dispose();
                color.dispose();
                StructuredTextEditorPreferencePage.this.colorPreviewImages.add(image);
                return image;
            }

            public String getText(Object element) {
                return ((ColorEntry)element).label;
            }
        });
        TableColumn tc = new TableColumn(this.fAppearanceColorTableViewer.getTable(), 0, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout(true);
        PixelConverter pixelConverter = new PixelConverter(tableComposite.getParent().getFont());
        tableColumnLayout.setColumnData((Widget)tc, (ColumnLayoutData)new ColumnWeightData(1, pixelConverter.convertWidthInCharsToPixels(30)));
        tableComposite.setLayout((Layout)tableColumnLayout);
        GridData gd = new GridData(1810);
        Table fAppearanceColorTable = this.fAppearanceColorTableViewer.getTable();
        gd.heightHint = fAppearanceColorTable.getItemHeight() * this.fAppearanceColorListModel.length + fAppearanceColorTable.getItemHeight() / 2;
        fAppearanceColorTable.setLayoutData((Object)gd);
    }

    private void initializeFields() {
        for (ColorEditor c : this.fColorButtons.keySet()) {
            String key = this.fColorButtons.get(c);
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
            c.setColorValue(rgb);
        }
        for (Button b : this.fCheckBoxes.keySet()) {
            String key = this.fCheckBoxes.get(b);
            b.setSelection(this.fOverlayStore.getBoolean(key));
        }
    }

    protected void performApply() {
        int i = 0;
        while (i < this.fTabs.length) {
            this.fTabs[i].performApply();
            ++i;
        }
        super.performApply();
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
        this.handleAppearanceColorViewerSelection();
        int i = 0;
        while (i < this.fTabs.length) {
            this.fTabs[i].performDefaults();
            ++i;
        }
        super.performDefaults();
    }

    public boolean performOk() {
        int i = 0;
        while (i < this.fTabs.length) {
            this.fTabs[i].performOk();
            ++i;
        }
        this.fOverlayStore.propagate();
        SSEUIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private class ColorEntry
    implements Comparable<ColorEntry> {
        public final String colorKey;
        public final String isSystemDefaultKey;
        public final String label;
        public final RGB systemColorRGB;

        public ColorEntry(String label, String colorKey, String isSystemDefaultKey, Color systemColor) {
            this.label = label;
            this.colorKey = colorKey;
            this.isSystemDefaultKey = isSystemDefaultKey;
            this.systemColorRGB = systemColor != null ? systemColor.getRGB() : null;
        }

        @Override
        public int compareTo(ColorEntry o) {
            return this.label.compareTo(o.label);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ColorEntry)) {
                return false;
            }
            return this.label.equals(((ColorEntry)obj).label) && this.colorKey.equals(((ColorEntry)obj).colorKey);
        }

        public RGB getRGB() {
            return PreferenceConverter.getColor((IPreferenceStore)StructuredTextEditorPreferencePage.this.fOverlayStore, (String)this.colorKey);
        }

        public boolean isSystemDefault() {
            return this.isSystemDefaultKey != null && StructuredTextEditorPreferencePage.this.fOverlayStore.getBoolean(this.isSystemDefaultKey);
        }
    }
}

