/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.releng.p2.to.maven;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.scada.releng.p2.to.maven.Activator;
import org.eclipse.scada.releng.p2.to.maven.MavenDependency;
import org.eclipse.scada.releng.p2.to.maven.Processor;
import org.osgi.framework.Version;

public class Application
implements IApplication {
    public Object start(IApplicationContext context) throws Exception {
        block23: {
            NullProgressMonitor pm = new NullProgressMonitor();
            Version version = context.getBrandingBundle().getVersion();
            System.out.format("P2 to Maven 2 converter - Version: %s%n", version);
            String[] args = (String[])context.getArguments().get("application.args");
            if (args.length < 2) {
                System.err.println("p2tom2 <config.properties> <sourceRepositoryUri> [<validationRepoUri1>] ...");
                return null;
            }
            URL propertiesLocation = new URL(args[0]);
            Properties lp = new Properties();
            Throwable throwable = null;
            Object var8_9 = null;
            try (InputStream input = propertiesLocation.openStream();){
                lp.load(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Properties p = new Properties(lp);
            p.putAll((Map<?, ?>)System.getProperties());
            File output = new File(p.getProperty("path.output"));
            output.mkdirs();
            File p2temp = new File(p.getProperty("path.p2temp", p.getProperty("path.output")));
            p2temp.mkdirs();
            System.out.format("Getting P2 agent: %s%n", p2temp);
            IProvisioningAgent agent = Activator.getAgent(p2temp.toURI());
            Throwable throwable3 = null;
            Object var12_15 = null;
            try (Processor processor = new Processor(agent, output, new URI(args[1]), p);){
                int i = 2;
                while (i < args.length) {
                    processor.addValidationRepository(new URI(args[i]));
                    ++i;
                }
                processor.process((IProgressMonitor)pm);
                System.out.println("=== START - MAVEN EXPORTS ===");
                processor.getMavenExports().stream().forEach(System.out::println);
                System.out.println("===  END  - MAVEN EXPORTS ===");
                System.out.println("=== START - MAVEN EXTERNAL DEPENDENCIES ===");
                LinkedHashSet<MavenDependency> deps = new LinkedHashSet<MavenDependency>(processor.getMavenDependencies());
                processor.getMavenExports().stream().filter(ref -> ref.getClassifier() == null).map(ref -> new MavenDependency(ref.getGroupId(), ref.getArtifactId(), ref.getVersion(), false)).forEach(deps::remove);
                deps.stream().forEach(System.out::println);
                System.out.println("===  END  - MAVEN EXTERNAL DEPENDENCIES ===");
                List<String> errors = processor.getErrors();
                if (!errors.isEmpty()) {
                    System.out.println("=== START - ERRORS ===");
                    errors.stream().forEach(System.out::println);
                    System.out.println("===  END  - ERRORS ===");
                }
                if (errors.isEmpty()) break block23;
                System.out.println("Exiting with validation errors!");
                return 1;
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
        }
        return null;
    }

    public void stop() {
    }
}

