/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.datashare;

import java.io.Serializable;
import java.util.Map;
import org.eclipse.ecf.core.events.IContainerConnectedEvent;
import org.eclipse.ecf.core.events.IContainerDisconnectedEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContext;
import org.eclipse.ecf.core.sharedobject.ISharedObjectTransactionConfig;
import org.eclipse.ecf.core.sharedobject.ReplicaSharedObjectDescription;
import org.eclipse.ecf.core.sharedobject.SharedObjectInitException;
import org.eclipse.ecf.core.sharedobject.TransactionSharedObject;
import org.eclipse.ecf.core.sharedobject.events.ISharedObjectMessageEvent;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.core.util.Event;
import org.eclipse.ecf.core.util.IEventProcessor;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.datashare.IChannel;
import org.eclipse.ecf.datashare.IChannelContainerAdapter;
import org.eclipse.ecf.datashare.IChannelListener;
import org.eclipse.ecf.datashare.events.IChannelConnectEvent;
import org.eclipse.ecf.datashare.events.IChannelDisconnectEvent;
import org.eclipse.ecf.datashare.events.IChannelEvent;
import org.eclipse.ecf.datashare.events.IChannelMessageEvent;
import org.eclipse.ecf.internal.provider.datashare.Messages;

public class BaseChannel
extends TransactionSharedObject
implements IChannel {
    public static final String RECEIVER_ID_PROPERTY;
    protected IChannelListener listener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.provider.datashare.BaseChannel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RECEIVER_ID_PROPERTY = clazz.getName();
    }

    public BaseChannel(ISharedObjectTransactionConfig config, IChannelListener listener) {
        super(config);
        this.setChannelListener(listener);
    }

    public BaseChannel() {
    }

    protected void setChannelListener(IChannelListener l) {
        this.listener = l;
    }

    protected void trace(String msg) {
        Trace.trace((String)"org.eclipse.ecf.provider.datashare", (String)msg);
    }

    protected void initialize() throws SharedObjectInitException {
        super.initialize();
        if (!this.isPrimary()) {
            this.initializeReplicaChannel();
        }
        this.addEventProcessor(new IEventProcessor(){

            public boolean processEvent(Event event) {
                BaseChannel.this.trace("processEvent(" + event + ")");
                IChannelListener l = BaseChannel.this.getListener();
                if (event instanceof IContainerConnectedEvent) {
                    if (l != null) {
                        l.handleChannelEvent((IChannelEvent)BaseChannel.this.createChannelGroupJoinEvent(true, ((IContainerConnectedEvent)event).getTargetID()));
                    }
                } else if (event instanceof IContainerDisconnectedEvent) {
                    if (l != null) {
                        l.handleChannelEvent((IChannelEvent)BaseChannel.this.createChannelGroupDepartEvent(true, ((IContainerDisconnectedEvent)event).getTargetID()));
                    }
                } else if (event instanceof ISharedObjectMessageEvent) {
                    BaseChannel.this.handleMessageEvent((ISharedObjectMessageEvent)event);
                }
                return false;
            }
        });
        this.trace("initialize()");
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ecf.datashare.IChannel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return this;
        }
        return super.getAdapter(clazz);
    }

    IChannelConnectEvent createChannelGroupJoinEvent(boolean hasJoined, final ID targetID) {
        return new IChannelConnectEvent(){
            private static final long serialVersionUID = -1085237280463725283L;

            public ID getTargetID() {
                return targetID;
            }

            public ID getChannelID() {
                return BaseChannel.this.getID();
            }

            public String toString() {
                StringBuffer buf = new StringBuffer("ChannelConnectEvent[");
                buf.append("channelid=").append(this.getChannelID()).append(";targetid=").append(this.getTargetID()).append("]");
                return buf.toString();
            }
        };
    }

    IChannelDisconnectEvent createChannelGroupDepartEvent(boolean hasJoined, final ID targetID) {
        return new IChannelDisconnectEvent(){
            private static final long serialVersionUID = -1085237280463725283L;

            public ID getTargetID() {
                return targetID;
            }

            public ID getChannelID() {
                return BaseChannel.this.getID();
            }

            public String toString() {
                StringBuffer buf = new StringBuffer("ChannelDisconnectEvent[");
                buf.append("channelid=").append(this.getChannelID()).append(";targetid=").append(this.getTargetID()).append("]");
                return buf.toString();
            }
        };
    }

    Event handleMessageEvent(final ISharedObjectMessageEvent event) {
        byte[] channelData;
        Object eventData = event.getData();
        ChannelMsg channelMsg = null;
        IChannelListener l = this.getListener();
        if (eventData instanceof ChannelMsg && (channelData = (channelMsg = (ChannelMsg)eventData).getData()) != null) {
            if (l == null) {
                return event;
            }
            this.listener.handleChannelEvent((IChannelEvent)new IChannelMessageEvent(){
                private static final long serialVersionUID = -2270885918818160970L;

                public ID getFromContainerID() {
                    return event.getRemoteContainerID();
                }

                public byte[] getData() {
                    return channelData;
                }

                public ID getChannelID() {
                    return BaseChannel.this.getID();
                }

                public String toString() {
                    StringBuffer buf = new StringBuffer("ChannelMessageEvent[");
                    buf.append("channelid=").append(this.getChannelID()).append(";fromid=").append(this.getFromContainerID()).append(";data=").append(this.getData()).append("]");
                    return buf.toString();
                }
            });
            return null;
        }
        return event;
    }

    public void sendMessage(byte[] message) throws ECFException {
        this.sendMessage(null, message);
    }

    public void sendMessage(ID receiver, byte[] message) throws ECFException {
        try {
            this.getContext().sendMessage(receiver, (Object)new ChannelMsg(message));
        }
        catch (Exception e) {
            throw new ECFException("send message exception", (Throwable)e);
        }
    }

    public synchronized IChannelListener getListener() {
        return this.listener;
    }

    public IChannelListener setListener(IChannelListener listener) {
        IChannelListener oldListener = this.getListener();
        this.setChannelListener(listener);
        return oldListener;
    }

    protected void receiveUndeliveredChannelEvent(IChannelEvent channelEvent) {
        if (this.isPrimary()) {
            this.trace("host.receiveUndeliveredChannelEvent(" + channelEvent + ";containerid=" + this.getContext().getLocalContainerID() + ")");
        } else {
            this.trace("replica.receiveUndeliveredChannelEvent(" + channelEvent + ";containerid=" + this.getContext().getLocalContainerID() + ")");
        }
    }

    protected ReplicaSharedObjectDescription getReplicaDescription(ID targetContainerID) {
        return new ReplicaSharedObjectDescription(((Object)((Object)this)).getClass(), this.getID(), this.getConfig().getHomeContainerID(), this.getConfig().getProperties());
    }

    protected void initializeReplicaChannel() throws SharedObjectInitException {
        Map properties = this.getConfig().getProperties();
        ID rcvr = null;
        try {
            rcvr = (ID)properties.get(RECEIVER_ID_PROPERTY);
        }
        catch (ClassCastException classCastException) {
            throw new SharedObjectInitException(Messages.BaseChannel_EXCEPTION_BAD_RECEIVER_ID);
        }
        if (rcvr != null) {
            IChannelContainerAdapter container;
            ISharedObjectContext iSharedObjectContext = this.getContext();
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.ecf.datashare.IChannelContainerAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((container = (IChannelContainerAdapter)iSharedObjectContext.getAdapter((Class)clazz)) == null) {
                throw new SharedObjectInitException(Messages.BaseChannel_EXCEPTION_CHANNEL_CONTAINER_NULL);
            }
            IChannel receiver = container.getChannel(rcvr);
            if (receiver == null) {
                throw new SharedObjectInitException(Messages.BaseChannel_EXCEPTION_RECEIVER_NULL);
            }
            this.setChannelListener(receiver.getListener());
        }
    }

    public void dispose() {
        this.destroySelfLocal();
    }

    static class ChannelMsg
    implements Serializable {
        private static final long serialVersionUID = 9065358269778864152L;
        byte[] channelData = null;

        ChannelMsg() {
        }

        ChannelMsg(byte[] data) {
            this.channelData = data;
        }

        byte[] getData() {
            return this.channelData;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("BaseChannel.ChannelMsg[");
            buf.append("data=").append(this.getData()).append("]");
            return buf.toString();
        }
    }
}

