/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.mail;

import java.lang.reflect.Constructor;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.eclipse.ebpm.connectors.mail.marshaler.AbstractMailMarshaler;
import org.eclipse.ebpm.connectors.mail.marshaler.DefaultMailMarshaler;
import org.eclipse.ebpm.connectors.mail.utils.MailConnectionConfiguration;
import org.eclipse.ebpm.connectors.mail.utils.MailUtils;
import org.eclipse.ebpm.core.AbstractSpagicConnector;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailSenderComponent
extends AbstractSpagicConnector {
    protected Logger log = LoggerFactory.getLogger(MailSenderComponent.class);
    public static final String PROPERTY_MARSHALER = "marshaler";
    public static final String PROPERTY_CUSTOMTRUSTMANAGER = "customTrustManagers";
    public static final String PROPERTY_SENDER = "sender";
    public static final String PROPERTY_SUBJECT = "subject";
    public static final String PROPERTY_RECEIVER = "receiver";
    public static final String PROPERTY_DEBUGMODE = "debugMode";
    public static final String PROPERTY_STARTTLS = "startTLS";
    private AbstractMailMarshaler marshaler = new DefaultMailMarshaler();
    private String customTrustManagers;
    private MailConnectionConfiguration config;
    private String connection;
    private String sender;
    private String subject;
    private String receiver;
    private boolean debugMode;
    private boolean startTLS = false;

    public void init() {
        AbstractMailMarshaler abstractMailMarshaler;
        if (this.propertyConfigurator.getString(PROPERTY_MARSHALER) != null && !this.propertyConfigurator.getString(PROPERTY_MARSHALER).equals("")) {
            try {
                Class<?> classe = Class.forName(this.propertyConfigurator.getString(PROPERTY_MARSHALER));
                Constructor<?> c = classe.getConstructor(new Class[0]);
                abstractMailMarshaler = (AbstractMailMarshaler)c.newInstance(new Object[0]);
            }
            catch (Exception e) {
                this.log.error("The selected mail Marshaler is invalid: " + this.propertyConfigurator.getString(PROPERTY_MARSHALER) + " the defaul one will be used ", (Throwable)e);
                abstractMailMarshaler = new DefaultMailMarshaler();
            }
        } else {
            abstractMailMarshaler = new DefaultMailMarshaler();
        }
        this.setMarshaler(abstractMailMarshaler);
        String host = this.propertyConfigurator.getString("host");
        String password = this.propertyConfigurator.getString("password", null);
        String protocol = this.propertyConfigurator.getString("protocol");
        String username = this.propertyConfigurator.getString("username", null);
        int port = this.propertyConfigurator.getInteger("port", Integer.valueOf(25));
        boolean startTLS = this.propertyConfigurator.getBoolean(PROPERTY_STARTTLS, Boolean.valueOf(false));
        String folderName = this.propertyConfigurator.getString("folderName", "INBOX");
        MailConnectionConfiguration config = new MailConnectionConfiguration(host, password, protocol, username, startTLS, folderName, port);
        this.setConfig(config);
        this.setCustomTrustManagers(this.propertyConfigurator.getString(PROPERTY_CUSTOMTRUSTMANAGER, null));
        this.setConnection(config);
        this.setSender(this.propertyConfigurator.getString(PROPERTY_SENDER, ""));
        this.setSubject(this.propertyConfigurator.getString(PROPERTY_SUBJECT, ""));
        this.setReceiver(this.propertyConfigurator.getString(PROPERTY_RECEIVER, ""));
        this.setDebugMode(this.propertyConfigurator.getBoolean(PROPERTY_DEBUGMODE, Boolean.valueOf(false)));
        this.setStartTLS(this.propertyConfigurator.getBoolean(PROPERTY_STARTTLS, Boolean.valueOf(false)));
    }

    public void start() throws Exception {
        super.start();
    }

    public void stop() throws Exception {
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) {
        MailSenderComponent mailSenderComponent = this;
        synchronized (mailSenderComponent) {
            block13: {
                this.log.debug("SPAGIC [" + Thread.currentThread().getId() + "] | Process In Only START");
                if (exchange.getStatus() == Status.Done) {
                    return;
                }
                if (exchange.getStatus() == Status.Error) {
                    return;
                }
                if (exchange.getFault(false) != null) {
                    exchange.setStatus(Status.Done);
                    this.send(exchange);
                } else {
                    Session session = null;
                    org.eclipse.ebpm.messaging.api.Message in = exchange.getIn(false);
                    try {
                        try {
                            this.config.setStartTLS(this.startTLS);
                            Properties props = MailUtils.getPropertiesForProtocol(this.config, this.customTrustManagers);
                            props.put("mail.debug", this.isDebugMode() ? "true" : "false");
                            session = this.config.getUsername() != null && this.config.getPassword() != null ? Session.getInstance((Properties)props, (Authenticator)this.config.getAuthenticator()) : Session.getInstance((Properties)props);
                            session.setDebug(this.debugMode);
                            Transport transport = session.getTransport(this.config.getProtocol());
                            transport.connect(this.config.getHost(), this.config.getPort(), this.config.getUsername(), this.config.getPassword());
                            MimeMessage msg = new MimeMessage(session);
                            String subjectInMessage = (String)in.getHeader("org.spagic3.mail.subject");
                            if (subjectInMessage == null && this.getSubject() != null) {
                                in.setHeader("org.spagic3.mail.subject", (Object)this.getSubject());
                            }
                            this.marshaler.convertNormalizedMessageToMail(msg, exchange, in, this.sender, this.receiver);
                            transport.sendMessage((Message)msg, msg.getAllRecipients());
                            transport.close();
                            this.log.debug("SPAGIC [" + Thread.currentThread().getId() + "] | Process In Only END CORRECT ");
                        }
                        catch (MessagingException mex) {
                            this.log.debug("SPAGIC [" + Thread.currentThread().getId() + "] | EXCEPTION ");
                            this.log.error("Error sending mail...", (Throwable)mex);
                            in.finalizeAttachments();
                            this.marshaler.cleanUpResources(exchange.getId());
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        in.finalizeAttachments();
                        this.marshaler.cleanUpResources(exchange.getId());
                        throw throwable;
                    }
                    in.finalizeAttachments();
                    this.marshaler.cleanUpResources(exchange.getId());
                }
            }
        }
    }

    public AbstractMailMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(AbstractMailMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public String getCustomTrustManagers() {
        return this.customTrustManagers;
    }

    public void setCustomTrustManagers(String customTrustManagers) {
        this.customTrustManagers = customTrustManagers;
    }

    public MailConnectionConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(MailConnectionConfiguration config) {
        this.config = config;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(MailConnectionConfiguration config) {
        String connStr = String.valueOf(config.getProtocol()) + "://" + config.getHost();
        connStr = String.valueOf(connStr) + (config.getPort() != -1 ? ":" + config.getPort() : "");
        if (config.getUsername() != null && config.getPassword() != null) {
            connStr = String.valueOf(connStr) + "?user=" + config.getUsername() + ";password=" + config.getPassword();
        }
        this.connection = connStr;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public boolean isStartTLS() {
        return this.startTLS;
    }

    public void setStartTLS(boolean startTLS) {
        this.startTLS = startTLS;
    }
}

