/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.ftp.marshaler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.DocumentSource;
import org.eclipse.ebpm.connectors.ftp.marshaler.FileMarshaler;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;

public class DefaultFileMarshaler
implements FileMarshaler {
    private String encoding;

    @Override
    public String getMarshalerId() {
        return "DEFAULT";
    }

    @Override
    public void readMessage(Exchange exchange, Message message, InputStream in, String path) throws IOException {
        if (this.encoding == null) {
            message.setBody((Source)new StreamSource(in, path));
        } else {
            message.setBody((Source)new StreamSource(new InputStreamReader(in, Charset.forName(this.encoding)), path));
        }
        message.setHeader("org.spagic3.file.name", (Object)new File(path).getName());
        message.setHeader("org.spagic3.file.path", (Object)path);
    }

    @Override
    public List<String> getOutputNames(Exchange exchange, Message message) {
        return Arrays.asList(this.asString(message.getHeader("org.spagic3.file.name")));
    }

    public String getTempOutputName(Exchange exchange, Message message) {
        Object retVal = message.getHeader("org.spagic3.file.name.temp");
        return retVal == null ? null : this.asString(retVal);
    }

    protected String asString(Object value) {
        return value != null ? value.toString() : null;
    }

    @Override
    public void writeMessage(Exchange exchange, Message message, String outputName, OutputStream out, String path) throws IOException {
        try {
            Source value = message.getBody();
            if (value != null) {
                this.writeValue(value, out);
            } else {
                this.writeMessageContent(exchange, message, out, path);
            }
        }
        catch (IOException e) {
            throw new IOException(e);
        }
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected void writeValue(Object value, OutputStream out) throws IOException {
        if (value instanceof String) {
            OutputStreamWriter writer = new OutputStreamWriter(out);
            writer.write((String)value);
            writer.flush();
        } else if (value instanceof byte[]) {
            out.write((byte[])value);
        } else {
            ObjectOutputStream objectOut = new ObjectOutputStream(out);
            objectOut.writeObject(value);
        }
    }

    protected void writeMessageContent(Exchange exchange, Message message, OutputStream out, String path) throws IOException {
        Source content = message.getBody();
        if (content == null) {
            throw new IOException("No message content in the inbound message for message exchange: " + exchange);
        }
        try {
            this.toResult(content, new StreamResult(out), this.encoding);
        }
        catch (TransformerException e) {
            throw new IOException(e);
        }
    }

    public void toResult(Object source, Result result, String charset) throws TransformerConfigurationException, TransformerException {
        TransformerFactory factory;
        Transformer transformer;
        String defaultCharset = System.getProperty("org.spagic3.default.charset", "UTF-8");
        if (source == null) {
            return;
        }
        if (charset == null) {
            charset = defaultCharset;
        }
        if ((transformer = (factory = TransformerFactory.newInstance()).newTransformer()) == null) {
            throw new TransformerException("Could not create a transformer - JAXP is misconfigured!");
        }
        transformer.setOutputProperty("encoding", charset);
        try {
            Document inDocument = DocumentHelper.parseText((String)((String)source));
            DocumentSource docSource = new DocumentSource(inDocument);
            transformer.transform((Source)docSource, result);
        }
        catch (Exception e) {
            throw new TransformerException(e);
        }
    }
}

