/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.accessor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.mappings.AttributeAccessor;

public class OrmAttributeAccessor
extends AttributeAccessor {
    private AttributeAccessor ormAccessor;
    private AttributeAccessor oxmAccessor;
    private boolean isValueHolderProperty;
    private boolean isChangeTracking;

    public OrmAttributeAccessor(AttributeAccessor ormAccessor, AttributeAccessor oxmAccessor) {
        this.ormAccessor = ormAccessor;
        this.oxmAccessor = oxmAccessor;
    }

    public void setValueHolderProperty(boolean isValueHolder) {
        this.isValueHolderProperty = isValueHolder;
    }

    public void setChangeTracking(boolean changeTracking) {
        this.isChangeTracking = changeTracking;
    }

    public boolean isValueHolderProperty() {
        return this.isValueHolderProperty;
    }

    public boolean isChangeTracking() {
        return this.isChangeTracking;
    }

    public Object getAttributeValueFromObject(Object object) {
        ValueHolderInterface vh;
        if (this.isValueHolderProperty && (vh = (ValueHolderInterface)this.ormAccessor.getAttributeValueFromObject(object)) != null && !vh.isInstantiated()) {
            Object value = vh.getValue();
            this.oxmAccessor.setAttributeValueInObject(object, value);
            if (vh instanceof WeavedAttributeValueHolderInterface) {
                ((WeavedAttributeValueHolderInterface)vh).setIsCoordinatedWithProperty(true);
            }
        }
        return this.oxmAccessor.getAttributeValueFromObject(object);
    }

    public void setAttributeValueInObject(Object object, Object value) {
        if (this.isChangeTracking) {
            Object oldValue = this.getAttributeValueFromObject(object);
            PropertyChangeListener listener = ((ChangeTracker)object)._persistence_getPropertyChangeListener();
            if (listener != null) {
                listener.propertyChange(new PropertyChangeEvent(object, this.oxmAccessor.getAttributeName(), value, oldValue));
            }
        }
        if (this.isValueHolderProperty) {
            ValueHolderInterface vh = (ValueHolderInterface)this.ormAccessor.getAttributeValueFromObject(object);
            if (vh == null) {
                vh = new ValueHolder();
                ((ValueHolder)vh).setIsNewlyWeavedValueHolder(true);
            }
            vh.setValue(value);
            this.ormAccessor.setAttributeValueInObject(object, vh);
        }
        this.oxmAccessor.setAttributeValueInObject(object, value);
    }

    public AttributeAccessor getOrmAccessor() {
        return this.ormAccessor;
    }

    public AttributeAccessor getOxmAccessor() {
        return this.oxmAccessor;
    }

    public void setOrmAccessor(AttributeAccessor accessor) {
        this.ormAccessor = accessor;
    }

    public void setOxmAccessor(AttributeAccessor accessor) {
        this.oxmAccessor = accessor;
    }

    public Class getAttributeClass() {
        return this.oxmAccessor.getAttributeClass();
    }

    public boolean isMethodAttributeAccessor() {
        return this.oxmAccessor.isMethodAttributeAccessor();
    }

    public String getAttributeName() {
        return this.oxmAccessor.getAttributeName();
    }
}

