/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.h2database;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.tools.Server;
import org.h2.util.JdbcUtils;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class H2DatabaseActivator
implements BundleActivator {
    private static final String DDL_NAME = "spagic-metadb-h2.ddl";
    private static final String SETUP_SQL_NAME = "setup-h2.sql";
    private static final String ATTACHMENT_SQL = "spagic-attachments-h2.ddl";

    public void start(BundleContext context) throws Exception {
        String mode = System.getProperty("spagic.mode");
        String attachmentStore = System.getProperty("spagic.attachment.store");
        if (mode != null && !mode.equalsIgnoreCase("demo")) {
            return;
        }
        try {
            System.out.println("Starting up embedded database");
            Thread h2 = new Thread(new Runnable(){
                String[] h2Parameters = new String[]{"-tcp", "-web"};

                @Override
                public void run() {
                    try {
                        Server.main((String[])this.h2Parameters);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            });
            h2.start();
            System.out.println("Countdown waiting for H2 to start");
            System.out.print("5...");
            Thread.sleep(1000L);
            System.out.print("4...");
            Thread.sleep(1000L);
            System.out.print("3...");
            Thread.sleep(1000L);
            System.out.print("2...");
            Thread.sleep(1000L);
            System.out.print("1...");
            Thread.sleep(1000L);
            System.out.println("Started");
            String spagicDbUrl = "jdbc:h2:tcp://localhost/~/spagic";
            String jbpmDbUrl = "jdbc:h2:tcp://localhost/~/jbpm";
            String attachmentDbUrl = "jdbc:h2:tcp://localhost/~/attachments";
            System.out.println(" Creating Spagic User ");
            H2DatabaseActivator.executeSQLSilently(spagicDbUrl, "sa", "", "CREATE USER IF NOT EXISTS  spagic PASSWORD 'spagic'");
            H2DatabaseActivator.executeSQLSilently(spagicDbUrl, "sa", "", "ALTER USER spagic ADMIN TRUE");
            System.out.println(" User Spagic Created ");
            H2DatabaseActivator.executeSQLSilently(jbpmDbUrl, "sa", "", "CREATE USER IF NOT EXISTS  jbpm PASSWORD 'jbpm'");
            H2DatabaseActivator.executeSQLSilently(jbpmDbUrl, "sa", "", "ALTER USER jbpm ADMIN TRUE");
            String tmpFolder = System.getProperty("java.io.tmpdir");
            File tmpDDLFile = new File(String.valueOf(tmpFolder) + File.separator + DDL_NAME);
            File tmpSetupSQLFile = new File(String.valueOf(tmpFolder) + File.separator + SETUP_SQL_NAME);
            this.prepareSpagicScripts(context, tmpFolder, tmpDDLFile, DDL_NAME, spagicDbUrl, "spagic");
            this.prepareSpagicScripts(context, tmpFolder, tmpSetupSQLFile, SETUP_SQL_NAME, spagicDbUrl, "spagic");
            if ("db".equals(attachmentStore)) {
                H2DatabaseActivator.executeSQLSilently(attachmentDbUrl, "sa", "", "CREATE USER IF NOT EXISTS attachments PASSWORD 'attachments'");
                H2DatabaseActivator.executeSQLSilently(attachmentDbUrl, "sa", "", "ALTER USER attachments ADMIN TRUE");
                File attachmentSQLFile = new File(String.valueOf(tmpFolder) + File.separator + ATTACHMENT_SQL);
                this.prepareSpagicScripts(context, tmpFolder, attachmentSQLFile, ATTACHMENT_SQL, attachmentDbUrl, "attachments");
            }
        }
        catch (Throwable e) {
            System.out.println(" Warning has Occured in H2database Activator" + e.getMessage());
        }
    }

    private void prepareSpagicScripts(BundleContext context, String tmpFolder, File DDLFile, String fileName, String url, String utenza) throws IOException {
        BufferedReader reader = null;
        PrintWriter writer = null;
        URL ddlEntry = context.getBundle().getEntry("/" + fileName);
        reader = new BufferedReader(new InputStreamReader(ddlEntry.openStream()));
        writer = new PrintWriter(new FileWriter(DDLFile));
        String line = null;
        while ((line = reader.readLine()) != null) {
            writer.println(line);
        }
        writer.flush();
        writer.close();
        String script = DDLFile.getCanonicalPath();
        try {
            H2DatabaseActivator.runScript(url, utenza, utenza, script);
        }
        catch (Throwable e) {
            System.out.println(" Warning has Occured in H2database Activator: " + e.getMessage());
        }
    }

    private static void runScript(String url, String user, String password, String fileName) throws SQLException {
        String sql = "RUNSCRIPT FROM '" + fileName + "' ";
        H2DatabaseActivator.executeSQL(url, user, password, sql);
    }

    private static void executeSQL(String url, String user, String password, String sql) throws SQLException {
        Connection conn = null;
        Statement stat = null;
        try {
            Connection connection = DriverManager.getConnection(url, user, password);
            stat = connection.createStatement();
            stat.execute(sql);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeSilently(stat);
            JdbcUtils.closeSilently(conn);
            throw throwable;
        }
        JdbcUtils.closeSilently((Statement)stat);
        JdbcUtils.closeSilently(conn);
    }

    private static void executeSQLSilently(String url, String user, String password, String sql) {
        try {
            H2DatabaseActivator.executeSQL(url, user, password, sql);
        }
        catch (Throwable throwable) {}
    }

    public void stop(BundleContext context) throws Exception {
    }
}

