/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.adapters.log;

import org.eclipse.hyades.logging.adapter.impl.SensorStatus;
import org.eclipse.hyades.logging.adapter.impl.Status;
import org.eclipse.hyades.logging.adapter.util.BufferedPeriodicReader;

public class Reader {
    private BufferedPeriodicReader input = null;
    boolean flushingMode = false;
    String rawLogFileName = null;
    protected Status status;
    int maximumBlocking = 200;
    String directory = "";
    String fileName = "";
    private static int confidenceBufferSize = 4096;
    private static int fileFooterSize = 0;
    private static String CharSet = "UTF-8";
    private static int initialBufferSize = 4096;
    private String[] lastLine = new String[this.maximumBlocking];

    public String getFullFileName() {
        return String.valueOf(this.directory) + "/" + this.fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Reader(String _directory, String _fileName) {
        this.directory = _directory;
        this.fileName = _fileName;
        this.lastLine = new String[this.maximumBlocking];
        this.status = new SensorStatus();
        String fn = String.valueOf(this.directory) + "/" + this.fileName;
        if (this.input == null) {
            this.input = new BufferedPeriodicReader(fn, null, null);
            this.input.setCharset(CharSet);
            this.input.setConfidenceBufferSize(confidenceBufferSize);
            this.input.setFileFooterSize(fileFooterSize);
            this.input.setMultiFile(false);
        }
    }

    public Object[] getNext() {
        if (this.rawLogFileName == null) {
            this.rawLogFileName = String.valueOf(this.directory) + "/" + this.fileName;
            try {
                this.input.prepare();
            }
            catch (Exception exception) {}
        }
        int linesReadCount = 0;
        try {
            ((SensorStatus)this.status).setTotalSize(this.input.getSize());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < this.lastLine.length) {
            this.lastLine[i] = null;
            ++i;
        }
        if (this.input != null) {
            i = 0;
            while (i < this.maximumBlocking) {
                try {
                    this.lastLine[i] = this.input.readLine();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this.lastLine[i] == null) {
                    i = this.maximumBlocking;
                    this.rawLogFileName = null;
                } else {
                    ++linesReadCount;
                    this.incrementItemsProcessedCount();
                    ((SensorStatus)this.status).incrementProcessedSize((long)this.lastLine[i].length());
                }
                ++i;
            }
        }
        this.rawLogFileName = null;
        if (this.lastLine[0] != null) {
            return this.lastLine;
        }
        return null;
    }

    public void incrementItemsProcessedCount() {
        this.status.setItemsProcessedCount(this.status.getItemsProcessedCount() + 1);
    }

    public String getRawLogFileName() {
        return this.rawLogFileName;
    }

    public void setRawLogFileName(String rawLogFileName) {
        this.rawLogFileName = rawLogFileName;
    }
}

