/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.weaving.jpa;

import java.io.IOException;
import java.io.Writer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipException;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import org.eclipse.persistence.exceptions.PersistenceUnitLoadingException;
import org.eclipse.persistence.exceptions.StaticWeaveException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.JPAConversionManager;
import org.eclipse.persistence.internal.jpa.deployment.ArchiveFactoryImpl;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProcessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.weaving.TransformerFactory;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.Archive;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;

public class StaticWeaveClassTransformer {
    private ArrayList<ClassTransformer> classTransformers;
    private Writer logWriter;
    private int logLevel = 8;
    private ClassLoader aClassLoader;

    public StaticWeaveClassTransformer(URL inputArchiveURL, ClassLoader aclassloader) throws Exception {
        this(inputArchiveURL, aclassloader, null, 8);
    }

    public StaticWeaveClassTransformer(URL inputArchiveURL, ClassLoader aclassloader, Writer logWriter, int loglevel) throws URISyntaxException, IOException {
        this.aClassLoader = aclassloader;
        this.logWriter = logWriter;
        this.logLevel = loglevel;
        this.buildClassTransformers(inputArchiveURL, aclassloader);
    }

    public byte[] transform(String originalClassName, Class originalClass, byte[] originalClassBytes) throws IllegalClassFormatException {
        ClassTransformer transformer;
        byte[] newClassBytes = null;
        Iterator<ClassTransformer> i$ = this.classTransformers.iterator();
        while (i$.hasNext() && (newClassBytes = (transformer = i$.next()).transform(this.aClassLoader, originalClassName, originalClass, null, originalClassBytes)) == null) {
        }
        return newClassBytes;
    }

    private void buildClassTransformers(URL inputArchiveURL, ClassLoader aclassloader) throws URISyntaxException, IOException {
        if (this.classTransformers != null) {
            return;
        }
        this.classTransformers = new ArrayList();
        Archive archive = null;
        try {
            archive = new ArchiveFactoryImpl().createArchive(inputArchiveURL);
            List<SEPersistenceUnitInfo> persistenceUnitsList = PersistenceUnitProcessor.processPersistenceArchive(archive, aclassloader);
            if (persistenceUnitsList == null) {
                throw PersistenceUnitLoadingException.couldNotGetUnitInfoFromUrl((URL)inputArchiveURL);
            }
            for (SEPersistenceUnitInfo unitInfo : persistenceUnitsList) {
                unitInfo.setNewTempClassLoader(aclassloader);
                ClassTransformer transformer = this.buildTransformer(unitInfo, this.logWriter, this.logLevel);
                this.classTransformers.add(transformer);
            }
        }
        catch (ZipException e) {
            throw StaticWeaveException.exceptionOpeningArchive((URL)inputArchiveURL, (Exception)e);
        }
        finally {
            if (archive != null) {
                archive.close();
            }
        }
    }

    private ClassTransformer buildTransformer(PersistenceUnitInfo unitInfo, Writer logWriter, int logLevel) {
        ClassLoader privateClassLoader = unitInfo.getNewTempClassLoader();
        ServerSession session = new ServerSession(new Project(new DatabaseLogin()));
        session.setLogLevel(logLevel);
        if (logWriter != null) {
            ((DefaultSessionLog)session.getSessionLog()).setWriter(logWriter);
        }
        session.getPlatform().setConversionManager((ConversionManager)new JPAConversionManager());
        boolean weaveEager = false;
        String weaveEagerString = (String)unitInfo.getProperties().get("eclipselink.weaving.eager");
        if (weaveEagerString != null && weaveEagerString.equalsIgnoreCase("true")) {
            weaveEager = true;
        }
        MetadataProcessor processor = new MetadataProcessor(unitInfo, (AbstractSession)session, privateClassLoader, true, weaveEager);
        PersistenceUnitProcessor.processORMetadata(processor, false);
        Collection<MetadataClass> entities = PersistenceUnitProcessor.buildEntityList(processor, privateClassLoader);
        boolean weaveLazy = true;
        String weaveL = (String)unitInfo.getProperties().get("eclipselink.weaving.lazy");
        if (weaveL != null && weaveL.equalsIgnoreCase("false")) {
            weaveLazy = false;
        }
        boolean weaveChangeTracking = true;
        String weaveCT = (String)unitInfo.getProperties().get("eclipselink.weaving.changetracking");
        if (weaveCT != null && weaveCT.equalsIgnoreCase("false")) {
            weaveChangeTracking = false;
        }
        boolean weaveFetchGroups = true;
        String weaveFetchGroupsProperty = (String)unitInfo.getProperties().get("eclipselink.weaving.fetchgroups");
        if (weaveFetchGroupsProperty != null && weaveFetchGroupsProperty.equalsIgnoreCase("false")) {
            weaveFetchGroups = false;
        }
        boolean weaveFetchInternal = true;
        String weaveInternalProperty = (String)unitInfo.getProperties().get("eclipselink.weaving.internal");
        if (weaveInternalProperty != null && weaveInternalProperty.equalsIgnoreCase("false")) {
            weaveFetchInternal = false;
        }
        return TransformerFactory.createTransformerAndModifyProject((Session)session, entities, privateClassLoader, weaveLazy, weaveChangeTracking, weaveFetchGroups, weaveFetchInternal);
    }
}

