(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "../data/webCustomData", "./dataManager", "./dataProvider", "./entry", "./colors", "./builtinData", "./dataProvider", "./dataManager"], factory);
    }
})(function (require, exports) {
    /*---------------------------------------------------------------------------------------------
     *  Copyright (c) Microsoft Corporation. All rights reserved.
     *  Licensed under the MIT License. See License.txt in the project root for license information.
     *--------------------------------------------------------------------------------------------*/
    'use strict';
    function __export(m) {
        for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
    }
    Object.defineProperty(exports, "__esModule", { value: true });
    var webCustomData = require("../data/webCustomData");
    var dataManager_1 = require("./dataManager");
    var dataProvider_1 = require("./dataProvider");
    __export(require("./entry"));
    __export(require("./colors"));
    __export(require("./builtinData"));
    __export(require("./dataProvider"));
    __export(require("./dataManager"));
    exports.cssDataManager = new dataManager_1.CSSDataManager([
        new dataProvider_1.CSSDataProvider(webCustomData.cssData)
    ]);
});
