/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public abstract class LifecycleBase
implements Lifecycle {
    private static final Log log = LogFactory.getLog(LifecycleBase.class);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.util");
    private final LifecycleSupport lifecycle = new LifecycleSupport(this);
    private volatile LifecycleState state = LifecycleState.NEW;

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    protected void fireLifecycleEvent(String type, Object data) {
        this.lifecycle.fireLifecycleEvent(type, data);
    }

    @Override
    public final synchronized void init() throws LifecycleException {
        if (!this.state.equals((Object)LifecycleState.NEW)) {
            this.invalidTransition("before_init");
        }
        this.setStateInternal(LifecycleState.INITIALIZING, null, false);
        try {
            this.initInternal();
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            this.setStateInternal(LifecycleState.FAILED, null, false);
            throw new LifecycleException(sm.getString("lifecycleBase.initFail", new Object[]{this.toString()}), t);
        }
        this.setStateInternal(LifecycleState.INITIALIZED, null, false);
    }

    protected abstract void initInternal() throws LifecycleException;

    @Override
    public final synchronized void start() throws LifecycleException {
        if (LifecycleState.STARTING_PREP.equals((Object)this.state) || LifecycleState.STARTING.equals((Object)this.state) || LifecycleState.STARTED.equals((Object)this.state)) {
            if (log.isDebugEnabled()) {
                LifecycleException e = new LifecycleException();
                log.debug((Object)sm.getString("lifecycleBase.alreadyStarted", new Object[]{this.toString()}), (Throwable)e);
            } else if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("lifecycleBase.alreadyStarted", new Object[]{this.toString()}));
            }
            return;
        }
        if (this.state.equals((Object)LifecycleState.NEW)) {
            this.init();
        } else if (this.state.equals((Object)LifecycleState.FAILED)) {
            this.stop();
        } else if (!this.state.equals((Object)LifecycleState.INITIALIZED) && !this.state.equals((Object)LifecycleState.STOPPED)) {
            this.invalidTransition("before_start");
        }
        this.setStateInternal(LifecycleState.STARTING_PREP, null, false);
        try {
            this.startInternal();
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            this.setStateInternal(LifecycleState.FAILED, null, false);
            throw new LifecycleException(sm.getString("lifecycleBase.startFail", new Object[]{this.toString()}), t);
        }
        if (this.state.equals((Object)LifecycleState.FAILED) || this.state.equals((Object)LifecycleState.MUST_STOP)) {
            this.stop();
        } else {
            if (!this.state.equals((Object)LifecycleState.STARTING)) {
                this.invalidTransition("after_start");
            }
            this.setStateInternal(LifecycleState.STARTED, null, false);
        }
    }

    protected abstract void startInternal() throws LifecycleException;

    @Override
    public final synchronized void stop() throws LifecycleException {
        if (LifecycleState.STOPPING_PREP.equals((Object)this.state) || LifecycleState.STOPPING.equals((Object)this.state) || LifecycleState.STOPPED.equals((Object)this.state)) {
            if (log.isDebugEnabled()) {
                LifecycleException e = new LifecycleException();
                log.debug((Object)sm.getString("lifecycleBase.alreadyStopped", new Object[]{this.toString()}), (Throwable)e);
            } else if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("lifecycleBase.alreadyStopped", new Object[]{this.toString()}));
            }
            return;
        }
        if (this.state.equals((Object)LifecycleState.NEW)) {
            this.state = LifecycleState.STOPPED;
            return;
        }
        if (!(this.state.equals((Object)LifecycleState.STARTED) || this.state.equals((Object)LifecycleState.FAILED) || this.state.equals((Object)LifecycleState.MUST_STOP))) {
            this.invalidTransition("before_stop");
        }
        if (this.state.equals((Object)LifecycleState.FAILED)) {
            this.fireLifecycleEvent("before_stop", null);
        } else {
            this.setStateInternal(LifecycleState.STOPPING_PREP, null, false);
        }
        try {
            this.stopInternal();
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            this.setStateInternal(LifecycleState.FAILED, null, false);
            throw new LifecycleException(sm.getString("lifecycleBase.stopFail", new Object[]{this.toString()}), t);
        }
        if (this.state.equals((Object)LifecycleState.MUST_DESTROY)) {
            this.setStateInternal(LifecycleState.STOPPED, null, false);
            this.destroy();
        } else if (!this.state.equals((Object)LifecycleState.FAILED)) {
            if (!this.state.equals((Object)LifecycleState.STOPPING)) {
                this.invalidTransition("after_stop");
            }
            this.setStateInternal(LifecycleState.STOPPED, null, false);
        }
    }

    protected abstract void stopInternal() throws LifecycleException;

    @Override
    public final synchronized void destroy() throws LifecycleException {
        if (LifecycleState.FAILED.equals((Object)this.state)) {
            try {
                this.stop();
            }
            catch (LifecycleException e) {
                log.warn((Object)sm.getString("lifecycleBase.destroyStopFail", new Object[]{this.toString()}), (Throwable)e);
            }
        }
        if (LifecycleState.DESTROYING.equals((Object)this.state) || LifecycleState.DESTROYED.equals((Object)this.state)) {
            if (log.isDebugEnabled()) {
                LifecycleException e = new LifecycleException();
                log.debug((Object)sm.getString("lifecycleBase.alreadyDestroyed", new Object[]{this.toString()}), (Throwable)e);
            } else if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("lifecycleBase.alreadyDestroyed", new Object[]{this.toString()}));
            }
            return;
        }
        if (!(this.state.equals((Object)LifecycleState.STOPPED) || this.state.equals((Object)LifecycleState.FAILED) || this.state.equals((Object)LifecycleState.NEW) || this.state.equals((Object)LifecycleState.INITIALIZED))) {
            this.invalidTransition("before_destroy");
        }
        this.setStateInternal(LifecycleState.DESTROYING, null, false);
        try {
            this.destroyInternal();
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            this.setStateInternal(LifecycleState.FAILED, null, false);
            throw new LifecycleException(sm.getString("lifecycleBase.destroyFail", new Object[]{this.toString()}), t);
        }
        this.setStateInternal(LifecycleState.DESTROYED, null, false);
    }

    protected abstract void destroyInternal() throws LifecycleException;

    @Override
    public LifecycleState getState() {
        return this.state;
    }

    @Override
    public String getStateName() {
        return this.getState().toString();
    }

    protected synchronized void setState(LifecycleState state) throws LifecycleException {
        this.setStateInternal(state, null, true);
    }

    protected synchronized void setState(LifecycleState state, Object data) throws LifecycleException {
        this.setStateInternal(state, data, true);
    }

    private synchronized void setStateInternal(LifecycleState state, Object data, boolean check) throws LifecycleException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("lifecycleBase.setState", new Object[]{this, state}));
        }
        if (check) {
            if (state == null) {
                this.invalidTransition("null");
                return;
            }
            if (!(state == LifecycleState.FAILED || this.state == LifecycleState.STARTING_PREP && state == LifecycleState.STARTING || this.state == LifecycleState.STOPPING_PREP && state == LifecycleState.STOPPING || this.state == LifecycleState.FAILED && state == LifecycleState.STOPPING)) {
                this.invalidTransition(state.name());
            }
        }
        this.state = state;
        String lifecycleEvent = state.getLifecycleEvent();
        if (lifecycleEvent != null) {
            this.fireLifecycleEvent(lifecycleEvent, data);
        }
    }

    private void invalidTransition(String type) throws LifecycleException {
        String msg = sm.getString("lifecycleBase.invalidTransition", new Object[]{type, this.toString(), this.state});
        throw new LifecycleException(msg);
    }
}

