/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2014-03-04 00:35:05 +0100 (Tue, 04 Mar 2014) $
//  number=$Revision: 9862 $
//  type=BJ

/**
 * Localized names for the "yo_BJ" locale.
 */
public class LocalizedNamesImpl_yo_BJ extends LocalizedNamesImpl_yo {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AQ",
        "AX",
        "BL",
        "BQ",
        "BV",
        "CC",
        "CP",
        "CW",
        "CX",
        "DG",
        "EA",
        "EH",
        "EU",
        "FO",
        "GG",
        "GS",
        "SS",
        "HK",
        "HM",
        "IC",
        "IM",
        "JE",
        "ME",
        "MF",
        "MO",
        "AD",
        "AO",
        "AI",
        "AG",
        "AF",
        "AR",
        "IE",
        "AL",
        "DZ",
        "AM",
        "CF",
        "ZA",
        "KR",
        "AW",
        "IS",
        "AT",
        "AU",
        "AZ",
        "BB",
        "BS",
        "BD",
        "BH",
        "BR",
        "BE",
        "BY",
        "BZ",
        "BM",
        "BN",
        "BT",
        "BG",
        "BF",
        "BI",
        "BO",
        "BA",
        "BW",
        "BJ",
        "DJ",
        "DM",
        "DO",
        "DK",
        "EG",
        "EC",
        "GQ",
        "ER",
        "EE",
        "VI",
        "VG",
        "FK",
        "MP",
        "IO",
        "MH",
        "NF",
        "SB",
        "KY",
        "CV",
        "CK",
        "ET",
        "VU",
        "FR",
        "VA",
        "FJ",
        "FI",
        "PH",
        "GF",
        "PF",
        "VC",
        "VE",
        "VN",
        "GA",
        "GP",
        "GM",
        "GH",
        "DE",
        "GD",
        "GN",
        "GW",
        "GL",
        "GR",
        "GI",
        "GU",
        "GT",
        "KP",
        "GY",
        "GE",
        "HT",
        "HN",
        "HU",
        "SH",
        "TL",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IL",
        "IT",
        "PS",
        "JM",
        "JP",
        "JO",
        "NC",
        "CM",
        "KH",
        "CA",
        "KZ",
        "KE",
        "KN",
        "KI",
        "CO",
        "KM",
        "CD",
        "CG",
        "HR",
        "QA",
        "CI",
        "CU",
        "KG",
        "CY",
        "CR",
        "KW",
        "LR",
        "LA",
        "LV",
        "LB",
        "LS",
        "LY",
        "LT",
        "LU",
        "LC",
        "LI",
        "MG",
        "FM",
        "MV",
        "MY",
        "MT",
        "MW",
        "ML",
        "MM",
        "MR",
        "MU",
        "MK",
        "MQ",
        "YT",
        "MX",
        "MD",
        "MN",
        "MC",
        "MA",
        "MZ",
        "MS",
        "NE",
        "NG",
        "NA",
        "NR",
        "NL",
        "AN",
        "NP",
        "NI",
        "NU",
        "UY",
        "UZ",
        "NO",
        "GB",
        "US",
        "PW",
        "PG",
        "PK",
        "PA",
        "PY",
        "PE",
        "PN",
        "PL",
        "PR",
        "PT",
        "PM",
        "RE",
        "RO",
        "RW",
        "RU",
        "WS",
        "SM",
        "ST",
        "SZ",
        "SA",
        "SC",
        "TD",
        "CN",
        "ZM",
        "NZ",
        "CL",
        "ZW",
        "CZ",
        "SK",
        "SI",
        "SG",
        "ES",
        "SY",
        "SL",
        "LK",
        "SO",
        "SD",
        "SR",
        "SE",
        "CH",
        "SN",
        "TH",
        "TW",
        "TJ",
        "TZ",
        "TT",
        "TG",
        "TK",
        "TO",
        "TV",
        "TN",
        "TR",
        "TC",
        "TM",
        "UG",
        "UA",
        "WF",
        "YE",
        "OM",
        "AE",
        "SV",
        "QO",
        "RS",
        "AS",
        "SJ",
        "SX",
        "TA",
        "TF",
        "UM",
        "XK",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "Orílɛ́ède Ààndórà");
    namesMap.put("AE", "Orílɛ́ède Ɛmirate ti Awɔn Arabu");
    namesMap.put("AF", "Orílɛ́ède Àfùgànístánì");
    namesMap.put("AG", "Orílɛ́ède Ààntígúà àti Báríbúdà");
    namesMap.put("AI", "Orílɛ́ède Ààngúlílà");
    namesMap.put("AL", "Orílɛ́ède Àlùbàníánì");
    namesMap.put("AM", "Orílɛ́ède Améníà");
    namesMap.put("AN", "Orílɛ́ède Nedalandi ti Antelisi");
    namesMap.put("AO", "Orílɛ́ède Ààngólà");
    namesMap.put("AR", "Orílɛ́ède Agentínà");
    namesMap.put("AS", "Sámóánì ti Orílɛ́ède Àméríkà");
    namesMap.put("AT", "Orílɛ́ède Asítíríà");
    namesMap.put("AU", "Orílɛ́ède Ástràlìá");
    namesMap.put("AW", "Orílɛ́ède Árúbà");
    namesMap.put("AZ", "Orílɛ́ède Asɛ́bájánì");
    namesMap.put("BA", "Orílɛ́ède Bɔ̀síníà àti Ɛtisɛgófínà");
    namesMap.put("BB", "Orílɛ́ède Bábádósì");
    namesMap.put("BD", "Orílɛ́ède Bángáládésì");
    namesMap.put("BE", "Orílɛ́ède Bégíɔ́mù");
    namesMap.put("BF", "Orílɛ́ède Bùùkíná Fasò");
    namesMap.put("BG", "Orílɛ́ède Bùùgáríà");
    namesMap.put("BH", "Orílɛ́ède Báránì");
    namesMap.put("BI", "Orílɛ́ède Bùùrúndì");
    namesMap.put("BJ", "Orílɛ́ède Bɛ̀nɛ̀");
    namesMap.put("BM", "Orílɛ́ède Bémúdà");
    namesMap.put("BN", "Orílɛ́ède Búrúnɛ́lì");
    namesMap.put("BO", "Orílɛ́ède Bɔ̀lífíyà");
    namesMap.put("BR", "Orílɛ́ède Bàràsílì");
    namesMap.put("BS", "Orílɛ́ède Bàhámásì");
    namesMap.put("BT", "Orílɛ́ède Bútánì");
    namesMap.put("BW", "Orílɛ́ède Bɔ̀tìsúwánà");
    namesMap.put("BY", "Orílɛ́ède Bélárúsì");
    namesMap.put("BZ", "Orílɛ́ède Bèlísɛ̀");
    namesMap.put("CA", "Orílɛ́ède Kánádà");
    namesMap.put("CD", "Orilɛ́ède Kóngò");
    namesMap.put("CF", "Orílɛ́ède Àrin gùngun Áfíríkà");
    namesMap.put("CG", "Orílɛ́ède Kóngò");
    namesMap.put("CH", "Orílɛ́ède switishilandi");
    namesMap.put("CI", "Orílɛ́ède Kóútè forà");
    namesMap.put("CK", "Orílɛ́ède Etíokun Kùúkù");
    namesMap.put("CL", "Orílɛ́ède shílè");
    namesMap.put("CM", "Orílɛ́ède Kamerúúnì");
    namesMap.put("CN", "Orílɛ́ède sháínà");
    namesMap.put("CO", "Orílɛ́ède Kòlómíbìa");
    namesMap.put("CR", "Orílɛ́ède Kuusita Ríkà");
    namesMap.put("CU", "Orílɛ́ède Kúbà");
    namesMap.put("CV", "Orílɛ́ède Etíokun Kápé féndè");
    namesMap.put("CY", "Orílɛ́ède Kúrúsì");
    namesMap.put("CZ", "Orílɛ́ède shɛ́ɛ́kì");
    namesMap.put("DE", "Orílɛ́ède Gemani");
    namesMap.put("DJ", "Orílɛ́ède Díbɔ́ótì");
    namesMap.put("DK", "Orílɛ́ède Dɛ́mákì");
    namesMap.put("DM", "Orílɛ́ède Dòmíníkà");
    namesMap.put("DO", "Orilɛ́ède Dòmíníkánì");
    namesMap.put("DZ", "Orílɛ́ède Àlùgèríánì");
    namesMap.put("EC", "Orílɛ́ède Ekuádò");
    namesMap.put("EE", "Orílɛ́ède Esitonia");
    namesMap.put("EG", "Orílɛ́ède Égípítì");
    namesMap.put("ER", "Orílɛ́ède Eritira");
    namesMap.put("ES", "Orílɛ́ède Sipani");
    namesMap.put("ET", "Orílɛ́ède Etopia");
    namesMap.put("FI", "Orílɛ́ède Filandi");
    namesMap.put("FJ", "Orílɛ́ède Fiji");
    namesMap.put("FK", "Orílɛ́ède Etikun Fakalandi");
    namesMap.put("FM", "Orílɛ́ède Makoronesia");
    namesMap.put("FR", "Orílɛ́ède Faranse");
    namesMap.put("GA", "Orílɛ́ède Gabon");
    namesMap.put("GB", "Orílɛ́ède Omobabirin");
    namesMap.put("GD", "Orílɛ́ède Genada");
    namesMap.put("GE", "Orílɛ́ède Gɔgia");
    namesMap.put("GF", "Orílɛ́ède Firenshi Guana");
    namesMap.put("GH", "Orílɛ́ède Gana");
    namesMap.put("GI", "Orílɛ́ède Gibaratara");
    namesMap.put("GL", "Orílɛ́ède Gerelandi");
    namesMap.put("GM", "Orílɛ́ède Gambia");
    namesMap.put("GN", "Orílɛ́ède Gene");
    namesMap.put("GP", "Orílɛ́ède Gadelope");
    namesMap.put("GQ", "Orílɛ́ède Ekutoria Gini");
    namesMap.put("GR", "Orílɛ́ède Geriisi");
    namesMap.put("GT", "Orílɛ́ède Guatemala");
    namesMap.put("GU", "Orílɛ́ède Guamu");
    namesMap.put("GW", "Orílɛ́ède Gene-Busau");
    namesMap.put("GY", "Orílɛ́ède Guyana");
    namesMap.put("HN", "Orílɛ́ède Hondurasi");
    namesMap.put("HR", "Orílɛ́ède Kòróátíà");
    namesMap.put("HT", "Orílɛ́ède Haati");
    namesMap.put("HU", "Orílɛ́ède Hungari");
    namesMap.put("ID", "Orílɛ́ède Indonesia");
    namesMap.put("IE", "Orílɛ́ède Ailandi");
    namesMap.put("IL", "Orílɛ́ède Iserɛli");
    namesMap.put("IN", "Orílɛ́ède India");
    namesMap.put("IO", "Orílɛ́ède Etíkun Índíánì ti Ìlú Bírítísì");
    namesMap.put("IQ", "Orílɛ́ède Iraki");
    namesMap.put("IR", "Orílɛ́ède Irani");
    namesMap.put("IS", "Orílɛ́ède Ashilandi");
    namesMap.put("IT", "Orílɛ́ède Italiyi");
    namesMap.put("JM", "Orílɛ́ède Jamaika");
    namesMap.put("JO", "Orílɛ́ède Jɔdani");
    namesMap.put("JP", "Orílɛ́ède Japani");
    namesMap.put("KE", "Orílɛ́ède Kenya");
    namesMap.put("KG", "Orílɛ́ède Kurishisitani");
    namesMap.put("KH", "Orílɛ́ède Kàmùbódíà");
    namesMap.put("KI", "Orílɛ́ède Kiribati");
    namesMap.put("KM", "Orílɛ́ède Kòmòrósì");
    namesMap.put("KN", "Orílɛ́ède Kiiti ati Neefi");
    namesMap.put("KP", "Orílɛ́ède Guusu Kɔria");
    namesMap.put("KR", "Orílɛ́ède Ariwa Kɔria");
    namesMap.put("KW", "Orílɛ́ède Kuweti");
    namesMap.put("KY", "Orílɛ́ède Etíokun Kámánì");
    namesMap.put("KZ", "Orílɛ́ède Kashashatani");
    namesMap.put("LA", "Orílɛ́ède Laosi");
    namesMap.put("LB", "Orílɛ́ède Lebanoni");
    namesMap.put("LC", "Orílɛ́ède Lushia");
    namesMap.put("LI", "Orílɛ́ède Lɛshitɛnisiteni");
    namesMap.put("LK", "Orílɛ́ède Siri Lanka");
    namesMap.put("LR", "Orílɛ́ède Laberia");
    namesMap.put("LS", "Orílɛ́ède Lesoto");
    namesMap.put("LT", "Orílɛ́ède Lituania");
    namesMap.put("LU", "Orílɛ́ède Lusemogi");
    namesMap.put("LV", "Orílɛ́ède Latifia");
    namesMap.put("LY", "Orílɛ́ède Libiya");
    namesMap.put("MA", "Orílɛ́ède Moroko");
    namesMap.put("MC", "Orílɛ́ède Monako");
    namesMap.put("MD", "Orílɛ́ède Modofia");
    namesMap.put("MG", "Orílɛ́ède Madasika");
    namesMap.put("MH", "Orílɛ́ède Etikun Máshali");
    namesMap.put("MK", "Orílɛ́ède Masidonia");
    namesMap.put("ML", "Orílɛ́ède Mali");
    namesMap.put("MM", "Orílɛ́ède Manamari");
    namesMap.put("MN", "Orílɛ́ède Mogolia");
    namesMap.put("MP", "Orílɛ́ède Etikun Guusu Mariana");
    namesMap.put("MQ", "Orílɛ́ède Matinikuwi");
    namesMap.put("MR", "Orílɛ́ède Maritania");
    namesMap.put("MS", "Orílɛ́ède Motserati");
    namesMap.put("MT", "Orílɛ́ède Malata");
    namesMap.put("MU", "Orílɛ́ède Maritiusi");
    namesMap.put("MV", "Orílɛ́ède Maladifi");
    namesMap.put("MW", "Orílɛ́ède Malawi");
    namesMap.put("MX", "Orílɛ́ède Mesiko");
    namesMap.put("MY", "Orílɛ́ède Malasia");
    namesMap.put("MZ", "Orílɛ́ède Moshamibiku");
    namesMap.put("NA", "Orílɛ́ède Namibia");
    namesMap.put("NC", "Orílɛ́ède Kaledonia Titun");
    namesMap.put("NE", "Orílɛ́ède Nàìjá");
    namesMap.put("NF", "Orílɛ́ède Etikun Nɔ́úfókì");
    namesMap.put("NG", "Orílɛ́ède Nàìjíríà");
    namesMap.put("NI", "Orílɛ́ède NIkaragua");
    namesMap.put("NL", "Orílɛ́ède Nedalandi");
    namesMap.put("NO", "Orílɛ́ède Nɔɔwii");
    namesMap.put("NP", "Orílɛ́ède Nepa");
    namesMap.put("NR", "Orílɛ́ède Nauru");
    namesMap.put("NU", "Orílɛ́ède Niue");
    namesMap.put("NZ", "Orílɛ́ède shilandi Titun");
    namesMap.put("OM", "Orílɛ́ède Ɔɔma");
    namesMap.put("PA", "Orílɛ́ède Panama");
    namesMap.put("PE", "Orílɛ́ède Peru");
    namesMap.put("PF", "Orílɛ́ède Firenshi Polinesia");
    namesMap.put("PG", "Orílɛ́ède Paapu ti Giini");
    namesMap.put("PH", "Orílɛ́ède filipini");
    namesMap.put("PK", "Orílɛ́ède Pakisitan");
    namesMap.put("PL", "Orílɛ́ède Polandi");
    namesMap.put("PM", "Orílɛ́ède Pɛɛri ati mikuloni");
    namesMap.put("PN", "Orílɛ́ède Pikarini");
    namesMap.put("PR", "Orílɛ́ède Pɔto Riko");
    namesMap.put("PS", "Orílɛ́ède Iwɔorun Pakisitian ati Gasha");
    namesMap.put("PT", "Orílɛ́ède Pɔtugi");
    namesMap.put("PW", "Orílɛ́ède Paalu");
    namesMap.put("PY", "Orílɛ́ède Paraguye");
    namesMap.put("QA", "Orílɛ́ède Kota");
    namesMap.put("RE", "Orílɛ́ède Riuniyan");
    namesMap.put("RO", "Orílɛ́ède Romaniya");
    namesMap.put("RU", "Orílɛ́ède Rɔshia");
    namesMap.put("RW", "Orílɛ́ède Ruwanda");
    namesMap.put("SA", "Orílɛ́ède Saudi Arabia");
    namesMap.put("SB", "Orílɛ́ède Etikun Solomoni");
    namesMap.put("SC", "Orílɛ́ède seshɛlɛsi");
    namesMap.put("SD", "Orílɛ́ède Sudani");
    namesMap.put("SE", "Orílɛ́ède Swidini");
    namesMap.put("SG", "Orílɛ́ède Singapo");
    namesMap.put("SH", "Orílɛ́ède Hɛlena");
    namesMap.put("SI", "Orílɛ́ède Silofania");
    namesMap.put("SK", "Orílɛ́ède Silofakia");
    namesMap.put("SL", "Orílɛ́ède Siria looni");
    namesMap.put("SM", "Orílɛ́ède Sani Marino");
    namesMap.put("SN", "Orílɛ́ède Sɛnɛga");
    namesMap.put("SO", "Orílɛ́ède Somalia");
    namesMap.put("SR", "Orílɛ́ède Surinami");
    namesMap.put("ST", "Orílɛ́ède Sao tomi ati piriishipi");
    namesMap.put("SV", "Orílɛ́ède Ɛɛsáfádò");
    namesMap.put("SY", "Orílɛ́ède Siria");
    namesMap.put("SZ", "Orílɛ́ède Sashiland");
    namesMap.put("TC", "Orílɛ́ède Tɔɔki ati Etikun Kakɔsi");
    namesMap.put("TD", "Orílɛ́ède shààdì");
    namesMap.put("TG", "Orílɛ́ède Togo");
    namesMap.put("TH", "Orílɛ́ède Tailandi");
    namesMap.put("TJ", "Orílɛ́ède Takisitani");
    namesMap.put("TK", "Orílɛ́ède Tokelau");
    namesMap.put("TL", "Orílɛ́ède ÌlàOòrùn Tímɔ̀");
    namesMap.put("TM", "Orílɛ́ède Tɔɔkimenisita");
    namesMap.put("TN", "Orílɛ́ède Tunishia");
    namesMap.put("TO", "Orílɛ́ède Tonga");
    namesMap.put("TR", "Orílɛ́ède Tɔɔki");
    namesMap.put("TT", "Orílɛ́ède Tirinida ati Tobaga");
    namesMap.put("TV", "Orílɛ́ède Tufalu");
    namesMap.put("TW", "Orílɛ́ède Taiwani");
    namesMap.put("TZ", "Orílɛ́ède Tanshania");
    namesMap.put("UA", "Orílɛ́ède Ukarini");
    namesMap.put("UG", "Orílɛ́ède Uganda");
    namesMap.put("US", "Orílɛ́ède Orilɛede Amerika");
    namesMap.put("UY", "Orílɛ́ède Nruguayi");
    namesMap.put("UZ", "Orílɛ́ède Nshibɛkisitani");
    namesMap.put("VA", "Orílɛ́ède Fatikani");
    namesMap.put("VC", "Orílɛ́ède Fisɛnnti ati Genadina");
    namesMap.put("VE", "Orílɛ́ède Fɛnɛshuɛla");
    namesMap.put("VG", "Orílɛ́ède Etíkun Fágínì ti ìlú Bírítísì");
    namesMap.put("VI", "Orílɛ́ède Etikun Fagini ti Amɛrika");
    namesMap.put("VN", "Orílɛ́ède Fɛtinami");
    namesMap.put("VU", "Orílɛ́ède Faniatu");
    namesMap.put("WF", "Orílɛ́ède Wali ati futuna");
    namesMap.put("WS", "Orílɛ́ède Samɔ");
    namesMap.put("YE", "Orílɛ́ède yemeni");
    namesMap.put("YT", "Orílɛ́ède Mayote");
    namesMap.put("ZA", "Orílɛ́ède Ariwa Afirika");
    namesMap.put("ZM", "Orílɛ́ède shamibia");
    namesMap.put("ZW", "Orílɛ́ède shimibabe");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "Orílɛ́ède Ààndórà",
        "AE": "Orílɛ́ède Ɛmirate ti Awɔn Arabu",
        "AF": "Orílɛ́ède Àfùgànístánì",
        "AG": "Orílɛ́ède Ààntígúà àti Báríbúdà",
        "AI": "Orílɛ́ède Ààngúlílà",
        "AL": "Orílɛ́ède Àlùbàníánì",
        "AM": "Orílɛ́ède Améníà",
        "AN": "Orílɛ́ède Nedalandi ti Antelisi",
        "AO": "Orílɛ́ède Ààngólà",
        "AR": "Orílɛ́ède Agentínà",
        "AS": "Sámóánì ti Orílɛ́ède Àméríkà",
        "AT": "Orílɛ́ède Asítíríà",
        "AU": "Orílɛ́ède Ástràlìá",
        "AW": "Orílɛ́ède Árúbà",
        "AZ": "Orílɛ́ède Asɛ́bájánì",
        "BA": "Orílɛ́ède Bɔ̀síníà àti Ɛtisɛgófínà",
        "BB": "Orílɛ́ède Bábádósì",
        "BD": "Orílɛ́ède Bángáládésì",
        "BE": "Orílɛ́ède Bégíɔ́mù",
        "BF": "Orílɛ́ède Bùùkíná Fasò",
        "BG": "Orílɛ́ède Bùùgáríà",
        "BH": "Orílɛ́ède Báránì",
        "BI": "Orílɛ́ède Bùùrúndì",
        "BJ": "Orílɛ́ède Bɛ̀nɛ̀",
        "BM": "Orílɛ́ède Bémúdà",
        "BN": "Orílɛ́ède Búrúnɛ́lì",
        "BO": "Orílɛ́ède Bɔ̀lífíyà",
        "BR": "Orílɛ́ède Bàràsílì",
        "BS": "Orílɛ́ède Bàhámásì",
        "BT": "Orílɛ́ède Bútánì",
        "BW": "Orílɛ́ède Bɔ̀tìsúwánà",
        "BY": "Orílɛ́ède Bélárúsì",
        "BZ": "Orílɛ́ède Bèlísɛ̀",
        "CA": "Orílɛ́ède Kánádà",
        "CD": "Orilɛ́ède Kóngò",
        "CF": "Orílɛ́ède Àrin gùngun Áfíríkà",
        "CG": "Orílɛ́ède Kóngò",
        "CH": "Orílɛ́ède switishilandi",
        "CI": "Orílɛ́ède Kóútè forà",
        "CK": "Orílɛ́ède Etíokun Kùúkù",
        "CL": "Orílɛ́ède shílè",
        "CM": "Orílɛ́ède Kamerúúnì",
        "CN": "Orílɛ́ède sháínà",
        "CO": "Orílɛ́ède Kòlómíbìa",
        "CR": "Orílɛ́ède Kuusita Ríkà",
        "CU": "Orílɛ́ède Kúbà",
        "CV": "Orílɛ́ède Etíokun Kápé féndè",
        "CY": "Orílɛ́ède Kúrúsì",
        "CZ": "Orílɛ́ède shɛ́ɛ́kì",
        "DE": "Orílɛ́ède Gemani",
        "DJ": "Orílɛ́ède Díbɔ́ótì",
        "DK": "Orílɛ́ède Dɛ́mákì",
        "DM": "Orílɛ́ède Dòmíníkà",
        "DO": "Orilɛ́ède Dòmíníkánì",
        "DZ": "Orílɛ́ède Àlùgèríánì",
        "EC": "Orílɛ́ède Ekuádò",
        "EE": "Orílɛ́ède Esitonia",
        "EG": "Orílɛ́ède Égípítì",
        "ER": "Orílɛ́ède Eritira",
        "ES": "Orílɛ́ède Sipani",
        "ET": "Orílɛ́ède Etopia",
        "FI": "Orílɛ́ède Filandi",
        "FJ": "Orílɛ́ède Fiji",
        "FK": "Orílɛ́ède Etikun Fakalandi",
        "FM": "Orílɛ́ède Makoronesia",
        "FR": "Orílɛ́ède Faranse",
        "GA": "Orílɛ́ède Gabon",
        "GB": "Orílɛ́ède Omobabirin",
        "GD": "Orílɛ́ède Genada",
        "GE": "Orílɛ́ède Gɔgia",
        "GF": "Orílɛ́ède Firenshi Guana",
        "GH": "Orílɛ́ède Gana",
        "GI": "Orílɛ́ède Gibaratara",
        "GL": "Orílɛ́ède Gerelandi",
        "GM": "Orílɛ́ède Gambia",
        "GN": "Orílɛ́ède Gene",
        "GP": "Orílɛ́ède Gadelope",
        "GQ": "Orílɛ́ède Ekutoria Gini",
        "GR": "Orílɛ́ède Geriisi",
        "GT": "Orílɛ́ède Guatemala",
        "GU": "Orílɛ́ède Guamu",
        "GW": "Orílɛ́ède Gene-Busau",
        "GY": "Orílɛ́ède Guyana",
        "HN": "Orílɛ́ède Hondurasi",
        "HR": "Orílɛ́ède Kòróátíà",
        "HT": "Orílɛ́ède Haati",
        "HU": "Orílɛ́ède Hungari",
        "ID": "Orílɛ́ède Indonesia",
        "IE": "Orílɛ́ède Ailandi",
        "IL": "Orílɛ́ède Iserɛli",
        "IN": "Orílɛ́ède India",
        "IO": "Orílɛ́ède Etíkun Índíánì ti Ìlú Bírítísì",
        "IQ": "Orílɛ́ède Iraki",
        "IR": "Orílɛ́ède Irani",
        "IS": "Orílɛ́ède Ashilandi",
        "IT": "Orílɛ́ède Italiyi",
        "JM": "Orílɛ́ède Jamaika",
        "JO": "Orílɛ́ède Jɔdani",
        "JP": "Orílɛ́ède Japani",
        "KE": "Orílɛ́ède Kenya",
        "KG": "Orílɛ́ède Kurishisitani",
        "KH": "Orílɛ́ède Kàmùbódíà",
        "KI": "Orílɛ́ède Kiribati",
        "KM": "Orílɛ́ède Kòmòrósì",
        "KN": "Orílɛ́ède Kiiti ati Neefi",
        "KP": "Orílɛ́ède Guusu Kɔria",
        "KR": "Orílɛ́ède Ariwa Kɔria",
        "KW": "Orílɛ́ède Kuweti",
        "KY": "Orílɛ́ède Etíokun Kámánì",
        "KZ": "Orílɛ́ède Kashashatani",
        "LA": "Orílɛ́ède Laosi",
        "LB": "Orílɛ́ède Lebanoni",
        "LC": "Orílɛ́ède Lushia",
        "LI": "Orílɛ́ède Lɛshitɛnisiteni",
        "LK": "Orílɛ́ède Siri Lanka",
        "LR": "Orílɛ́ède Laberia",
        "LS": "Orílɛ́ède Lesoto",
        "LT": "Orílɛ́ède Lituania",
        "LU": "Orílɛ́ède Lusemogi",
        "LV": "Orílɛ́ède Latifia",
        "LY": "Orílɛ́ède Libiya",
        "MA": "Orílɛ́ède Moroko",
        "MC": "Orílɛ́ède Monako",
        "MD": "Orílɛ́ède Modofia",
        "MG": "Orílɛ́ède Madasika",
        "MH": "Orílɛ́ède Etikun Máshali",
        "MK": "Orílɛ́ède Masidonia",
        "ML": "Orílɛ́ède Mali",
        "MM": "Orílɛ́ède Manamari",
        "MN": "Orílɛ́ède Mogolia",
        "MP": "Orílɛ́ède Etikun Guusu Mariana",
        "MQ": "Orílɛ́ède Matinikuwi",
        "MR": "Orílɛ́ède Maritania",
        "MS": "Orílɛ́ède Motserati",
        "MT": "Orílɛ́ède Malata",
        "MU": "Orílɛ́ède Maritiusi",
        "MV": "Orílɛ́ède Maladifi",
        "MW": "Orílɛ́ède Malawi",
        "MX": "Orílɛ́ède Mesiko",
        "MY": "Orílɛ́ède Malasia",
        "MZ": "Orílɛ́ède Moshamibiku",
        "NA": "Orílɛ́ède Namibia",
        "NC": "Orílɛ́ède Kaledonia Titun",
        "NE": "Orílɛ́ède Nàìjá",
        "NF": "Orílɛ́ède Etikun Nɔ́úfókì",
        "NG": "Orílɛ́ède Nàìjíríà",
        "NI": "Orílɛ́ède NIkaragua",
        "NL": "Orílɛ́ède Nedalandi",
        "NO": "Orílɛ́ède Nɔɔwii",
        "NP": "Orílɛ́ède Nepa",
        "NR": "Orílɛ́ède Nauru",
        "NU": "Orílɛ́ède Niue",
        "NZ": "Orílɛ́ède shilandi Titun",
        "OM": "Orílɛ́ède Ɔɔma",
        "PA": "Orílɛ́ède Panama",
        "PE": "Orílɛ́ède Peru",
        "PF": "Orílɛ́ède Firenshi Polinesia",
        "PG": "Orílɛ́ède Paapu ti Giini",
        "PH": "Orílɛ́ède filipini",
        "PK": "Orílɛ́ède Pakisitan",
        "PL": "Orílɛ́ède Polandi",
        "PM": "Orílɛ́ède Pɛɛri ati mikuloni",
        "PN": "Orílɛ́ède Pikarini",
        "PR": "Orílɛ́ède Pɔto Riko",
        "PS": "Orílɛ́ède Iwɔorun Pakisitian ati Gasha",
        "PT": "Orílɛ́ède Pɔtugi",
        "PW": "Orílɛ́ède Paalu",
        "PY": "Orílɛ́ède Paraguye",
        "QA": "Orílɛ́ède Kota",
        "RE": "Orílɛ́ède Riuniyan",
        "RO": "Orílɛ́ède Romaniya",
        "RU": "Orílɛ́ède Rɔshia",
        "RW": "Orílɛ́ède Ruwanda",
        "SA": "Orílɛ́ède Saudi Arabia",
        "SB": "Orílɛ́ède Etikun Solomoni",
        "SC": "Orílɛ́ède seshɛlɛsi",
        "SD": "Orílɛ́ède Sudani",
        "SE": "Orílɛ́ède Swidini",
        "SG": "Orílɛ́ède Singapo",
        "SH": "Orílɛ́ède Hɛlena",
        "SI": "Orílɛ́ède Silofania",
        "SK": "Orílɛ́ède Silofakia",
        "SL": "Orílɛ́ède Siria looni",
        "SM": "Orílɛ́ède Sani Marino",
        "SN": "Orílɛ́ède Sɛnɛga",
        "SO": "Orílɛ́ède Somalia",
        "SR": "Orílɛ́ède Surinami",
        "ST": "Orílɛ́ède Sao tomi ati piriishipi",
        "SV": "Orílɛ́ède Ɛɛsáfádò",
        "SY": "Orílɛ́ède Siria",
        "SZ": "Orílɛ́ède Sashiland",
        "TC": "Orílɛ́ède Tɔɔki ati Etikun Kakɔsi",
        "TD": "Orílɛ́ède shààdì",
        "TG": "Orílɛ́ède Togo",
        "TH": "Orílɛ́ède Tailandi",
        "TJ": "Orílɛ́ède Takisitani",
        "TK": "Orílɛ́ède Tokelau",
        "TL": "Orílɛ́ède ÌlàOòrùn Tímɔ̀",
        "TM": "Orílɛ́ède Tɔɔkimenisita",
        "TN": "Orílɛ́ède Tunishia",
        "TO": "Orílɛ́ède Tonga",
        "TR": "Orílɛ́ède Tɔɔki",
        "TT": "Orílɛ́ède Tirinida ati Tobaga",
        "TV": "Orílɛ́ède Tufalu",
        "TW": "Orílɛ́ède Taiwani",
        "TZ": "Orílɛ́ède Tanshania",
        "UA": "Orílɛ́ède Ukarini",
        "UG": "Orílɛ́ède Uganda",
        "US": "Orílɛ́ède Orilɛede Amerika",
        "UY": "Orílɛ́ède Nruguayi",
        "UZ": "Orílɛ́ède Nshibɛkisitani",
        "VA": "Orílɛ́ède Fatikani",
        "VC": "Orílɛ́ède Fisɛnnti ati Genadina",
        "VE": "Orílɛ́ède Fɛnɛshuɛla",
        "VG": "Orílɛ́ède Etíkun Fágínì ti ìlú Bírítísì",
        "VI": "Orílɛ́ède Etikun Fagini ti Amɛrika",
        "VN": "Orílɛ́ède Fɛtinami",
        "VU": "Orílɛ́ède Faniatu",
        "WF": "Orílɛ́ède Wali ati futuna",
        "WS": "Orílɛ́ède Samɔ",
        "YE": "Orílɛ́ède yemeni",
        "YT": "Orílɛ́ède Mayote",
        "ZA": "Orílɛ́ède Ariwa Afirika",
        "ZM": "Orílɛ́ède shamibia",
        "ZW": "Orílɛ́ède shimibabe"
    };
  }-*/;
}
