/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.CloudFoundryClient;
import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.cloudfoundry.client.lib.HttpProxyConfiguration;
import org.cloudfoundry.client.lib.domain.CloudSpace;
import org.cloudfoundry.client.lib.util.CloudUtil;
import org.cloudfoundry.client.lib.util.JsonUtil;
import org.cloudfoundry.client.lib.util.RestUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.HttpMessageConverterExtractor;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplate;

public class CloudFoundryClientFactory {
    private static CloudFoundryClientFactory sessionFactory = null;

    public static CloudFoundryClientFactory getDefault() {
        if (sessionFactory == null) {
            sessionFactory = new CloudFoundryClientFactory();
        }
        return sessionFactory;
    }

    public CloudFoundryOperations getCloudFoundryOperations(CloudCredentials credentials, URL url, boolean selfSigned) {
        return this.getCloudFoundryOperations(credentials, url, null, selfSigned);
    }

    public CloudFoundryOperations getCloudFoundryOperations(CloudCredentials credentials, URL url, CloudSpace session, boolean selfSigned) {
        HttpProxyConfiguration proxyConfiguration = CloudFoundryClientFactory.getProxy(url);
        return session != null ? new CloudFoundryClient(credentials, url, session, selfSigned) : new CloudFoundryClient(credentials, url, proxyConfiguration, selfSigned);
    }

    public CloudFoundryOperations getCloudFoundryOperations(CloudCredentials credentials, URL url, String orgName, String spaceName, boolean selfsigned) {
        HttpProxyConfiguration proxyConfiguration = CloudFoundryClientFactory.getProxy(url);
        return new CloudFoundryClient(credentials, url, orgName, spaceName, proxyConfiguration, selfsigned);
    }

    public CloudFoundryOperations getCloudFoundryOperations(String cloudControllerUrl) throws MalformedURLException {
        return this.getCloudFoundryOperations(cloudControllerUrl, false);
    }

    public CloudFoundryOperations getCloudFoundryOperations(String cloudControllerUrl, boolean selfSigned) throws MalformedURLException {
        URL url = new URL(cloudControllerUrl);
        HttpProxyConfiguration proxyConfiguration = CloudFoundryClientFactory.getProxy(url);
        return new CloudFoundryClient(url, proxyConfiguration, selfSigned);
    }

    protected static CloudCredentials getCredentials(String userName, String password) {
        return new CloudCredentials(userName, password);
    }

    public static HttpProxyConfiguration getProxy(URL url) {
        IProxyService proxyService;
        if (url == null) {
            return null;
        }
        CloudFoundryPlugin plugin = CloudFoundryPlugin.getDefault();
        if (plugin != null && (proxyService = plugin.getProxyService()) != null) {
            IProxyData[] selectedProxies;
            block5: {
                try {
                    selectedProxies = proxyService.select(url.toURI());
                    if (selectedProxies != null && selectedProxies.length != 0) break block5;
                    return null;
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            IProxyData data = selectedProxies[0];
            int proxyPort = data.getPort();
            String proxyHost = data.getHost();
            String user = data.getUserId();
            String password = data.getPassword();
            return proxyHost != null ? new HttpProxyConfiguration(proxyHost, proxyPort, data.isRequiresAuthentication(), user, password) : null;
        }
        return null;
    }

    private static String getUrl(String url, String path) {
        return String.valueOf(url) + (path.startsWith("/") ? path : "/" + path);
    }

    private static String getJson(RestTemplate restTemplate, String urlString) {
        HttpMethod method = null;
        try (ClientHttpResponse response = null;){
            method = HttpMethod.GET;
            URI url = new UriTemplate(urlString).expand(new Object[0]);
            ClientHttpRequest request = restTemplate.getRequestFactory().createRequest(url, method);
            ArrayList<MediaType> acceptableMediaTypes = new ArrayList<MediaType>();
            acceptableMediaTypes.add(MediaType.APPLICATION_JSON);
            request.getHeaders().setAccept(acceptableMediaTypes);
            response = request.execute();
            if (response.getBody() != null) {
                String data;
                HttpMessageConverterExtractor extractor = new HttpMessageConverterExtractor(String.class, restTemplate.getMessageConverters());
                String string = data = (String)extractor.extractData(response);
                return string;
            }
        }
        return null;
    }

    public static String getSsoUrl(String apiurl, boolean trustSelfSignedCerts) throws Exception {
        List list;
        Object text;
        String infoV2Json;
        Map infoV2Map;
        String authorizationEndpoint;
        RestUtil restUtil = new RestUtil();
        HttpProxyConfiguration httpProxyConfiguration = CloudFoundryClientFactory.getProxy(new URL(apiurl));
        RestTemplate restTemplate = restUtil.createRestTemplate(httpProxyConfiguration, trustSelfSignedCerts);
        String passcodeJson = CloudFoundryClientFactory.getJson(restTemplate, CloudFoundryClientFactory.getUrl(authorizationEndpoint = (String)CloudUtil.parse(String.class, (infoV2Map = JsonUtil.convertJsonToMap((String)(infoV2Json = (String)restTemplate.getForObject(CloudFoundryClientFactory.getUrl(apiurl, "/v2/info"), String.class, new Object[0])))).get("authorization_endpoint")), "/login"));
        Map passcodeMap = JsonUtil.convertJsonToMap((String)passcodeJson);
        Object prompts = passcodeMap.get("prompts");
        if (prompts instanceof Map && (text = ((Map)prompts).get("passcode")) instanceof List && (list = (List)text).size() >= 2 && list.get(1) != null) {
            String message = list.get(1).toString();
            String[] elements = message.split(" ");
            int i = 0;
            while (i < elements.length) {
                String element = elements[i];
                if (element != null && element.startsWith("http")) {
                    String url = element;
                    while (url.endsWith(")")) {
                        url = url.substring(0, url.length() - 1);
                    }
                    return url;
                }
                ++i;
            }
        }
        return null;
    }
}

