/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import java.util.StringTokenizer;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.rules.CActivityValidator;

public class ValidateValidator
extends CActivityValidator {
    String variables;

    @Override
    protected void start() {
        super.start();
        this.variables = this.mNode.getAttribute(AT_VARIABLES);
    }

    @ARule(sa=0, desc="Make sure that the variables defined in the validate activity are defined.", author="michal.chmielewski@oracle.com", date="02/15/2007", errors="BPELC_VALIDATE__NO_VARIABLES_SPECIFIED,BPELC_VALIDATE__NO_SUCH_VARIABLE")
    public void rule_CheckValidateVariables_15() {
        if (ValidateValidator.isEmptyOrWhitespace(this.variables)) {
            IProblem problem = this.createError();
            problem.setAttribute("context.name", AT_VARIABLES);
            problem.fill("BPELC_VALIDATE__NO_VARIABLES_SPECIFIED", this.toString(this.mNode.nodeName()));
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.variables, " ");
        while (tokenizer.hasMoreTokens()) {
            String nextVarName = tokenizer.nextToken();
            INode variableNode = this.mModelQuery.lookup(this.mNode, 1, nextVarName);
            if (!this.isUndefined(variableNode)) continue;
            IProblem problem = this.createError();
            problem.setAttribute("context.name", AT_VARIABLES);
            problem.fill("BPELC_VALIDATE__NO_SUCH_VARIABLE", nextVarName, this.toString(this.mNode.nodeName()));
        }
    }
}

