/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.Runner;
import org.eclipse.bpel.validator.rules.CValidator;

public class ImportValidator
extends CValidator {
    public static IFilter<INode> PARENTS = Filters.PROCESS;
    String fImportType;
    String fLocation;
    String fNamespace;
    INode fImportedNode;

    @Override
    protected void start() {
        super.start();
        this.fLocation = this.mNode.getAttribute(AT_LOCATION);
        this.fImportType = this.mNode.getAttribute(AT_IMPORT_TYPE);
        this.fNamespace = this.mNode.getAttribute(AT_NAMESPACE);
    }

    @ARule(desc="Check if importType is set on import", author="michal.chmielewski@oracle.com", date="03/15/2007", errors="BPELC__UNSET_ATTRIBUTE")
    public void rule_CheckIfImportTypesSet_1() {
        if (ImportValidator.isEmptyOrWhitespace(this.fImportType)) {
            IProblem problem = this.createError();
            problem.fill("BPELC__UNSET_ATTRIBUTE", this.toString(this.mNode.nodeName()), AT_IMPORT_TYPE, 0);
            this.fImportType = null;
        }
    }

    @ARule(desc="Check if location is set on import", author="michal.chmielewski@oracle.com", date="03/15/2007", errors="BPELC_IMPORT_LOCATION")
    public void rule_CheckLocation_3() {
        if (this.fLocation == null) {
            return;
        }
        if (this.fLocation.indexOf("../") >= 0) {
            IProblem problem = this.createError();
            problem.fill("BPELC_IMPORT_LOCATION", this.fLocation, AT_LOCATION, this.toString(this.mNode.nodeName()), 0);
        }
    }

    @ARule(date="10/3/2006", author="michal.chmielewski@oracle.com", desc="Check the import type. BPEL 2.0 currently supports WSDL and XSD import types.", sa=13, infos="BPELC_IMPORT__IMPORT_TYPE")
    public void rule_CheckImportType_4() {
        if (this.fImportType == null) {
            return;
        }
        if (!this.mModelQuery.hasSupport(2, this.fImportType)) {
            IProblem problem = this.createInfo();
            problem.fill("BPELC_IMPORT__IMPORT_TYPE", this.fImportType, AT_IMPORT_TYPE, this.toString(this.mNode.nodeName()), 0);
        }
    }

    @ARule(author="michal.chmielewski@oracle.com", date="01/15/2007", desc="Imported namespace, if set, must match", sa=11, errors="BPELC_IMPORT__NS1")
    public void rule_CheckNamespaceOfImport_8() {
        if (this.fImportType == null) {
            return;
        }
        this.fImportedNode = this.mModelQuery.lookup(this.mNode, 5, "document");
        if (this.isUndefined(this.fImportedNode)) {
            return;
        }
        String targetNS = this.fImportedNode.getAttribute(AT_TARGET_NAMESPACE);
        if (!ImportValidator.isEmpty(this.fNamespace) && !this.fNamespace.equals(targetNS)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_IMPORT__NS1", this.toString(this.mNode.nodeName()), this.fNamespace, targetNS);
        }
    }

    @ARule(sa=1234, desc="Imported node location problem", author="michal.chmielewski@oracle.com", date="03/29/2007", errors="BPELC_IMPORT__UNRESOVED")
    public void rule_CheckImportLocation_14() {
        if (this.isUndefined(this.fImportedNode) && ImportValidator.isNonEmpty(this.fLocation)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_IMPORT__UNRESOVED", this.toString(this.mNode.nodeName()), this.fImportType, this.fLocation);
        }
    }

    @ARule(author="michal.chmielewski@oracle.com", date="01/15/2007", desc="When import has no namespace, the targetNamespace must be empty.", sa=12, errors="BPELC_IMPORT__NS2")
    public void rule_CheckNamespaceOfImport_15() {
        if (this.isUndefined(this.fImportedNode)) {
            return;
        }
        String targetNS = this.fImportedNode.getAttribute(AT_TARGET_NAMESPACE);
        if (ImportValidator.isEmpty(this.fNamespace) && !ImportValidator.isEmpty(targetNS)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_IMPORT__NS2", this.toString(this.mNode.nodeName()), this.fNamespace, targetNS);
        }
    }

    @Override
    public void end() {
        super.end();
        if (!"http://schemas.xmlsoap.org/wsdl/".equals(this.fImportType) || this.isUndefined(this.fImportedNode)) {
            return;
        }
        Runner runner = new Runner(this.mModelQuery, this.fImportedNode);
        this.addProblems(runner.run());
    }
}

