/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.codegen;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import org.eclipse.apogy.common.ApogyCommonPackage;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenModelGeneratorAdapter;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyGenModelGeneratorAdapter
extends GenModelGeneratorAdapter {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyGenModelGeneratorAdapter.class);

    public ApogyGenModelGeneratorAdapter() {
        super(null);
    }

    public ApogyGenModelGeneratorAdapter(GeneratorAdapterFactory generatorAdapterFactory) {
        super(generatorAdapterFactory);
    }

    protected Diagnostic doPostGenerate(Object object, Object projectType) {
        if (projectType.equals("org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject") || projectType.equals("org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject")) {
            String type = ((String)projectType).substring(((String)projectType).lastIndexOf(".") + 1, ((String)projectType).length());
            GenModel genModel = (GenModel)this.generatingObject;
            Logger.debug("Updating(" + type + ") GenModel: " + genModel.getQualifiedModelModuleName() + " started");
            try {
                for (GenPackage genPackage : genModel.getGenPackages()) {
                    try {
                        Logger.debug("\tUpdating(" + type + ") GenPackage: " + genPackage.getQualifiedPackageName() + " started");
                        for (GenClass genClass : genPackage.getGenClasses()) {
                            EClass superEClass;
                            EClass eClass = genClass.getEcoreClass();
                            EClass eClass2 = superEClass = eClass.getESuperTypes().isEmpty() ? null : (EClass)eClass.getESuperTypes().get(0);
                            if (projectType.equals("org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject") && !genClass.getEcoreClass().isInterface()) {
                                this.applyCustomClassFixes(genClass, superEClass, genClass.getGenModel().getModelDirectory(), genClass.getGenPackage().getClassPackageName(), ApogyCommonPackage.Literals.APOGY_GEN_CLASS__HAS_CUSTOM_CLASS_KEY.getDefaultValueLiteral(), ApogyCommonPackage.Literals.APOGY_GEN_CLASS__DEFAULT_CLASS_SUFFIX.getDefaultValueLiteral(), ApogyCommonPackage.Literals.APOGY_GEN_CLASS__CUSTOM_CLASS_SUFFIX.getDefaultValueLiteral());
                            }
                            if (projectType.equals("org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject") && genModel.hasEditSupport() && !genClass.getEcoreClass().isInterface()) {
                                this.applyCustomClassFixes(genClass, superEClass, genClass.getGenModel().getEditDirectory(), genClass.getGenPackage().getProviderPackageName(), ApogyCommonPackage.Literals.APOGY_GEN_CLASS__HAS_CUSTOM_ITEM_PROVIDER_KEY.getDefaultValueLiteral(), ApogyCommonPackage.Literals.APOGY_GEN_CLASS__DEFAULT_ITEM_PROVIDER_CLASS_SUFFIX.getDefaultValueLiteral(), ApogyCommonPackage.Literals.APOGY_GEN_CLASS__CUSTOM_ITEM_PROVIDER_CLASS_SUFFIX.getDefaultValueLiteral());
                            }
                            Logger.debug("\t\t<" + eClass.getName() + "> <" + (projectType.equals("org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject") ? "Model" : "Edit") + "> done");
                        }
                    }
                    catch (Throwable t) {
                        Logger.error("\tUpdating(" + type + ") GenPackage: " + genPackage.getQualifiedPackageName() + " failed" + genPackage.getQualifiedPackageName(), t);
                    }
                    if (projectType.equals("org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject")) {
                        this.applyCustomFactoryFixes(genPackage, genPackage.getGenModel().getModelDirectory(), genPackage.getImportedFactoryClassName(), ApogyCommonPackage.Literals.APOGY_GEN_CLASS__HAS_CUSTOM_CLASS_KEY.getDefaultValueLiteral(), ApogyCommonPackage.Literals.APOGY_GEN_CLASS__DEFAULT_CLASS_SUFFIX.getDefaultValueLiteral(), ApogyCommonPackage.Literals.APOGY_GEN_CLASS__CUSTOM_CLASS_SUFFIX.getDefaultValueLiteral());
                    }
                    if (genModel.hasEditSupport() && projectType.equals("org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject")) {
                        this.applyCustomFactoryFixes(genPackage, genPackage.getGenModel().getEditDirectory(), genPackage.getImportedItemProviderAdapterFactoryClassName(), ApogyCommonPackage.Literals.APOGY_GEN_CLASS__HAS_CUSTOM_ITEM_PROVIDER_KEY.getDefaultValueLiteral(), ApogyCommonPackage.Literals.APOGY_GEN_CLASS__DEFAULT_ITEM_PROVIDER_CLASS_SUFFIX.getDefaultValueLiteral(), ApogyCommonPackage.Literals.APOGY_GEN_CLASS__CUSTOM_ITEM_PROVIDER_CLASS_SUFFIX.getDefaultValueLiteral());
                    }
                    Logger.debug("\tUpdating(" + type + ") package: " + genPackage.getQualifiedPackageName() + " done");
                }
            }
            catch (Throwable t) {
                Logger.error("Apogy code generator had problems to update the model " + genModel.getQualifiedModelModuleName(), t);
            }
            Logger.debug("Updating(" + type + ") model: " + genModel.getQualifiedModelModuleName() + " done");
        }
        return Diagnostic.OK_INSTANCE;
    }

    private void applyCustomClassFixes(final GenClass genClass, final EClass superEClass, String bundleDirectory, String classPackageName, final String hasCustomCodeKey, final String defaultClassSuffix, final String customClassSuffix) {
        URI javaClassURI = this.toURI(bundleDirectory).appendSegments(classPackageName.split("\\.")).appendSegment(String.valueOf(genClass.getName()) + defaultClassSuffix).appendFileExtension("java");
        this.applyChanges(javaClassURI, new ASTVisitor(){

            public boolean visit(TypeDeclaration node) {
                EAnnotation superClassEAnnotation;
                EAnnotation eAnnotation = ApogyCommonEMFFacade.INSTANCE.getApogyEAnnotation((EModelElement)genClass.getEcoreClass());
                if (ApogyCommonEMFFacade.INSTANCE.isTrue(eAnnotation, hasCustomCodeKey) && (node.getModifiers() & Modifier.ModifierKeyword.ABSTRACT_KEYWORD.toFlagValue()) == 0) {
                    node.modifiers().add(node.getAST().newModifier(Modifier.ModifierKeyword.ABSTRACT_KEYWORD));
                }
                if (ApogyCommonEMFFacade.INSTANCE.isTrue(superClassEAnnotation = ApogyCommonEMFFacade.INSTANCE.getApogyEAnnotation((EModelElement)superEClass), hasCustomCodeKey)) {
                    Type nodeType = node.getSuperclassType();
                    SimpleType simpleType = null;
                    if (nodeType instanceof SimpleType) {
                        simpleType = (SimpleType)nodeType;
                    } else if (nodeType instanceof ParameterizedType) {
                        simpleType = (SimpleType)((ParameterizedType)nodeType).getType();
                    }
                    if (simpleType != null) {
                        SimpleName nodeSuperClassName = (SimpleName)simpleType.getName();
                        String oldName = nodeSuperClassName.getFullyQualifiedName();
                        if ((String.valueOf(superEClass.getName()) + defaultClassSuffix).equals(oldName)) {
                            String newName = oldName.replaceAll(String.valueOf(defaultClassSuffix) + "$", customClassSuffix);
                            simpleType.setName(node.getAST().newName(newName));
                            CompilationUnit compilationUnit = ApogyGenModelGeneratorAdapter.getCompilationUnit((ASTNode)node);
                            Iterator imports = compilationUnit.imports().iterator();
                            boolean found = false;
                            while (!found && imports.hasNext()) {
                                ImportDeclaration currentImportDeclaration = (ImportDeclaration)imports.next();
                                Name importName = currentImportDeclaration.getName();
                                String fullyQualifiedName = importName.getFullyQualifiedName();
                                if (!fullyQualifiedName.endsWith(String.valueOf(superEClass.getName()) + defaultClassSuffix)) continue;
                                currentImportDeclaration.setName(node.getAST().newName(fullyQualifiedName.replaceAll(defaultClassSuffix, customClassSuffix)));
                                found = true;
                            }
                        }
                    }
                }
                return super.visit(node);
            }
        });
    }

    private void applyCustomFactoryFixes(final GenPackage genPackage, String bundleDirectory, String factoryClassName, final String hasCustomKey, final String defaultClassSuffix, final String customClassSuffix) {
        URI javaFactoryURI = this.toURI(bundleDirectory).appendSegments(factoryClassName.split("\\.")).appendFileExtension("java");
        this.applyChanges(javaFactoryURI, new ASTVisitor(){

            public boolean visit(ClassInstanceCreation node) {
                Type nodeType = node.getType();
                SimpleType simpleType = null;
                if (nodeType instanceof SimpleType) {
                    simpleType = (SimpleType)nodeType;
                } else if (nodeType instanceof ParameterizedType) {
                    simpleType = (SimpleType)((ParameterizedType)nodeType).getType();
                }
                if (simpleType != null) {
                    EClass eClass;
                    EAnnotation eAnnotation;
                    Name name = simpleType.getName();
                    EClassifier eClassifier = genPackage.getEcorePackage().getEClassifier(name.getFullyQualifiedName().replaceAll(String.valueOf(defaultClassSuffix) + "$", ""));
                    if (eClassifier != null && eClassifier instanceof EClass && ApogyCommonEMFFacade.INSTANCE.isTrue(eAnnotation = ApogyCommonEMFFacade.INSTANCE.getApogyEAnnotation((EModelElement)(eClass = (EClass)eClassifier)), hasCustomKey)) {
                        String newName = name.getFullyQualifiedName().replaceAll(String.valueOf(defaultClassSuffix) + "$", customClassSuffix);
                        simpleType.setName(node.getAST().newName(newName));
                        ASTNode rootNode = node.getRoot();
                        AST rootAST = rootNode.getAST();
                        CompilationUnit cu = ApogyGenModelGeneratorAdapter.getCompilationUnit(rootNode);
                        cu.getPackage().getName().getFullyQualifiedName();
                        ImportDeclaration importDeclaration = rootAST.newImportDeclaration();
                        importDeclaration.setName(node.getRoot().getAST().newName(String.valueOf(cu.getPackage().getName().getFullyQualifiedName()) + "." + newName));
                        ApogyGenModelGeneratorAdapter.getCompilationUnit(rootNode).imports().add(importDeclaration);
                    }
                }
                return super.visit(node);
            }
        });
    }

    protected void applyChanges(URI uri, ASTVisitor astVisitor) {
        try {
            InputStream inputStream = this.getURIConverter().createInputStream(uri);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] data = new byte[bufferedInputStream.available()];
            bufferedInputStream.read(data);
            bufferedInputStream.close();
            String content = new String(data);
            ASTParser parser = ASTParser.newParser((int)10);
            parser.setKind(8);
            parser.setSource(content.toCharArray());
            CompilationUnit astRoot = (CompilationUnit)parser.createAST(null);
            astRoot.recordModifications();
            astRoot.accept(astVisitor);
            Document document = new Document(content);
            TextEdit edits = astRoot.rewrite((IDocument)document, null);
            edits.apply((IDocument)document);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IFile file = root.getFile((IPath)new Path(uri.toString()));
            file.setContents((InputStream)new ByteArrayInputStream(document.get().getBytes()), true, false, null);
        }
        catch (Exception e) {
            Logger.error("The apogy generator adapter is unabled to update : " + uri, (Throwable)e);
        }
    }

    private static CompilationUnit getCompilationUnit(ASTNode node) {
        ASTNode currentNode = node;
        if (currentNode != null) {
            while (currentNode.getParent() != null) {
                currentNode = currentNode.getParent();
            }
        }
        return (CompilationUnit)currentNode;
    }
}

