/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.client;

import java.util.List;
import org.apache.xmlrpc.XmlRpcConfig;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.XmlRpcRequestConfig;
import org.apache.xmlrpc.client.AsyncCallback;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientDefaults;
import org.apache.xmlrpc.client.XmlRpcClientRequestImpl;
import org.apache.xmlrpc.client.XmlRpcClientWorker;
import org.apache.xmlrpc.client.XmlRpcClientWorkerFactory;
import org.apache.xmlrpc.client.XmlRpcTransportFactory;
import org.apache.xmlrpc.common.XmlRpcController;
import org.apache.xmlrpc.common.XmlRpcWorkerFactory;
import org.apache.xmlrpc.serializer.XmlWriterFactory;

public class XmlRpcClient
extends XmlRpcController {
    private XmlRpcTransportFactory transportFactory = XmlRpcClientDefaults.newTransportFactory(this);
    private XmlRpcClientConfig config = XmlRpcClientDefaults.newXmlRpcClientConfig();
    private XmlWriterFactory xmlWriterFactory = XmlRpcClientDefaults.newXmlWriterFactory();

    @Override
    protected XmlRpcWorkerFactory getDefaultXmlRpcWorkerFactory() {
        return new XmlRpcClientWorkerFactory(this);
    }

    public void setConfig(XmlRpcClientConfig pConfig) {
        this.config = pConfig;
    }

    @Override
    public XmlRpcConfig getConfig() {
        return this.config;
    }

    public XmlRpcClientConfig getClientConfig() {
        return this.config;
    }

    public void setTransportFactory(XmlRpcTransportFactory pFactory) {
        this.transportFactory = pFactory;
    }

    public XmlRpcTransportFactory getTransportFactory() {
        return this.transportFactory;
    }

    public Object execute(String pMethodName, Object[] pParams) throws XmlRpcException {
        return this.execute(this.getClientConfig(), pMethodName, pParams);
    }

    public Object execute(XmlRpcClientConfig pConfig, String pMethodName, Object[] pParams) throws XmlRpcException {
        return this.execute(new XmlRpcClientRequestImpl((XmlRpcRequestConfig)pConfig, pMethodName, pParams));
    }

    public Object execute(String pMethodName, List pParams) throws XmlRpcException {
        return this.execute(this.getClientConfig(), pMethodName, pParams);
    }

    public Object execute(XmlRpcClientConfig pConfig, String pMethodName, List pParams) throws XmlRpcException {
        return this.execute(new XmlRpcClientRequestImpl((XmlRpcRequestConfig)pConfig, pMethodName, pParams));
    }

    public Object execute(XmlRpcRequest pRequest) throws XmlRpcException {
        return this.getWorkerFactory().getWorker().execute(pRequest);
    }

    public void executeAsync(String pMethodName, Object[] pParams, AsyncCallback pCallback) throws XmlRpcException {
        this.executeAsync(this.getClientConfig(), pMethodName, pParams, pCallback);
    }

    public void executeAsync(XmlRpcClientConfig pConfig, String pMethodName, Object[] pParams, AsyncCallback pCallback) throws XmlRpcException {
        this.executeAsync(new XmlRpcClientRequestImpl((XmlRpcRequestConfig)pConfig, pMethodName, pParams), pCallback);
    }

    public void executeAsync(String pMethodName, List pParams, AsyncCallback pCallback) throws XmlRpcException {
        this.executeAsync(this.getClientConfig(), pMethodName, pParams, pCallback);
    }

    public void executeAsync(XmlRpcClientConfig pConfig, String pMethodName, List pParams, AsyncCallback pCallback) throws XmlRpcException {
        this.executeAsync(new XmlRpcClientRequestImpl((XmlRpcRequestConfig)pConfig, pMethodName, pParams), pCallback);
    }

    public void executeAsync(XmlRpcRequest pRequest, AsyncCallback pCallback) throws XmlRpcException {
        XmlRpcClientWorker w = (XmlRpcClientWorker)this.getWorkerFactory().getWorker();
        w.execute(pRequest, pCallback);
    }

    public XmlWriterFactory getXmlWriterFactory() {
        return this.xmlWriterFactory;
    }

    public void setXmlWriterFactory(XmlWriterFactory pFactory) {
        this.xmlWriterFactory = pFactory;
    }
}

