/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.NonPositiveDefiniteMatrixException;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.util.FastMath;

public class RectangularCholeskyDecomposition {
    private final RealMatrix root;
    private int rank;

    public RectangularCholeskyDecomposition(RealMatrix matrix) throws NonPositiveDefiniteMatrixException {
        this(matrix, 0.0);
    }

    public RectangularCholeskyDecomposition(RealMatrix matrix, double small) throws NonPositiveDefiniteMatrixException {
        int order = matrix.getRowDimension();
        double[][] c = matrix.getData();
        double[][] b = new double[order][order];
        int[] index = new int[order];
        int i = 0;
        while (i < order) {
            index[i] = i;
            ++i;
        }
        int r = 0;
        boolean loop = true;
        while (loop) {
            double sqrt;
            int ir;
            int swapR = r;
            int i2 = r + 1;
            while (i2 < order) {
                int ii = index[i2];
                int isr = index[swapR];
                if (c[ii][ii] > c[isr][isr]) {
                    swapR = i2;
                }
                ++i2;
            }
            if (swapR != r) {
                int tmpIndex = index[r];
                index[r] = index[swapR];
                index[swapR] = tmpIndex;
                double[] tmpRow = b[r];
                b[r] = b[swapR];
                b[swapR] = tmpRow;
            }
            if (c[ir = index[r]][ir] <= small) {
                if (r == 0) {
                    throw new NonPositiveDefiniteMatrixException(c[ir][ir], ir, small);
                }
                int i3 = r;
                while (i3 < order) {
                    if (c[index[i3]][index[i3]] < -small) {
                        throw new NonPositiveDefiniteMatrixException(c[index[i3]][index[i3]], i3, small);
                    }
                    ++i3;
                }
                loop = false;
                continue;
            }
            b[r][r] = sqrt = FastMath.sqrt(c[ir][ir]);
            double inverse = 1.0 / sqrt;
            double inverse2 = 1.0 / c[ir][ir];
            int i4 = r + 1;
            while (i4 < order) {
                double e;
                int ii = index[i4];
                b[i4][r] = e = inverse * c[ii][ir];
                double[] dArray = c[ii];
                int n = ii;
                dArray[n] = dArray[n] - c[ii][ir] * c[ii][ir] * inverse2;
                int j = r + 1;
                while (j < i4) {
                    double f;
                    int ij = index[j];
                    c[ii][ij] = f = c[ii][ij] - e * b[j][r];
                    c[ij][ii] = f;
                    ++j;
                }
                ++i4;
            }
            boolean bl = loop = ++r < order;
        }
        this.rank = r;
        this.root = MatrixUtils.createRealMatrix(order, r);
        int i5 = 0;
        while (i5 < order) {
            int j = 0;
            while (j < r) {
                this.root.setEntry(index[i5], j, b[i5][j]);
                ++j;
            }
            ++i5;
        }
    }

    public RealMatrix getRootMatrix() {
        return this.root;
    }

    public int getRank() {
        return this.rank;
    }
}

