/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.eclipse.andmore.android.certmanager.exception;

import org.eclipse.andmore.android.common.exception.AndroidException;

/**
 * Exception thrown when the password to access a keystore is invalid or wrong.
 * */
@SuppressWarnings("serial")
public class InvalidPasswordException extends AndroidException {

	/*
	 * Create a new empty exception.
	 */
	@SuppressWarnings("unused")
	private InvalidPasswordException() {
		// prevent methods to throw this exception without further information
	}

	/**
	 * Create a new exception with a message indicating the problem.
	 * */
	public InvalidPasswordException(String message) {
		super(message);
	}

	/**
	 * Create a new exception with a message indicating the problem, and append
	 * some other exception that is being replaced by this one.
	 * */
	public InvalidPasswordException(String message, Throwable cause) {
		super(message, cause);
	}

}
