/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.tests.javax.sql.rowset;

import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Ref;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialRef;
import junit.framework.TestCase;
import org.apache.harmony.sql.tests.javax.sql.rowset.BaseRowSetTest;
import org.apache.harmony.sql.tests.javax.sql.rowset.MockArray;
import org.apache.harmony.sql.tests.javax.sql.rowset.MockBlob;
import org.apache.harmony.sql.tests.javax.sql.rowset.MockClob;
import org.apache.harmony.sql.tests.javax.sql.rowset.MockRef;

/*
 * Exception performing whole class analysis ignored.
 */
public class BaseRowSetTest
extends TestCase {
    public void testGetParams() throws Exception {
        BaseRowSetImpl brs = new BaseRowSetImpl(null);
        Object[] params = brs.getParams();
        BaseRowSetTest.assertNotNull((Object)params);
        BaseRowSetTest.assertEquals((int)0, (int)params.length);
    }

    public void testGetFetchDirection() throws SQLException {
        BaseRowSetImpl brs = new BaseRowSetImpl(null);
        BaseRowSetTest.assertEquals((int)1000, (int)brs.getFetchDirection());
    }

    public void testGetTypeMap() {
        BaseRowSetImpl brs = new BaseRowSetImpl(null);
        BaseRowSetTest.assertNull((Object)brs.getTypeMap());
    }

    public void testSetNullintint() throws Exception {
        BaseRowSetImpl brs = new BaseRowSetImpl(null);
        try {
            brs.setNull(1, -2);
            BaseRowSetTest.fail((String)"sql exception expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        brs.initParams();
        try {
            brs.setNull(0, -2);
            BaseRowSetTest.fail((String)"sql exception expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        brs.setNull(1, -2);
        Object[] params = brs.getParams();
        BaseRowSetTest.assertNotNull((Object)params);
        Object[] param = (Object[])params[0];
        BaseRowSetTest.assertNotNull((Object)param);
        BaseRowSetTest.assertEquals((int)2, (int)param.length);
        BaseRowSetTest.assertNull((Object)param[0]);
        BaseRowSetTest.assertEquals((Object)-2, (Object)param[1]);
    }

    public void testSetNullintintString() throws Exception {
        BaseRowSetImpl brs = new BaseRowSetImpl(null);
        try {
            brs.setNull(1, -2, "java.lang.Boolean");
            BaseRowSetTest.fail((String)"sql exception expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        brs.initParams();
        try {
            brs.setNull(0, -2, "java.lang.Boolean");
            BaseRowSetTest.fail((String)"sql exception expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        brs.setNull(1, -2, "java.lang.Boolean");
        Object[] params = brs.getParams();
        BaseRowSetTest.assertNotNull((Object)params);
        Object[] param = (Object[])params[0];
        BaseRowSetTest.assertNotNull((Object)param);
        BaseRowSetTest.assertEquals((int)3, (int)param.length);
        BaseRowSetTest.assertNull((Object)param[0]);
        BaseRowSetTest.assertEquals((Object)-2, (Object)param[1]);
        BaseRowSetTest.assertEquals((Object)"java.lang.Boolean", (Object)param[2]);
    }

    public void testSetBoolean() throws Exception {
        BaseRowSetImpl brs = new BaseRowSetImpl(null);
        try {
            brs.setBoolean(1, true);
            BaseRowSetTest.fail((String)"sql exception expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        brs.initParams();
        try {
            brs.setBoolean(0, true);
            BaseRowSetTest.fail((String)"sql exception expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        brs.setBoolean(1, true);
        Object[] params = brs.getParams();
        BaseRowSetTest.assertNotNull((Object)params);
        BaseRowSetTest.assertEquals((int)1, (int)params.length);
        BaseRowSetTest.assertEquals((Object)Boolean.TRUE, (Object)params[0]);
    }

    public void testSetByte() throws Exception {
        BaseRowSetImpl brs = new BaseRowSetImpl(null);
        try {
            brs.setByte(1, (byte)1);
            BaseRowSetTest.fail((String)"sql exception expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        brs.initParams();
        try {
            brs.setByte(0, (byte)1);
            BaseRowSetTest.fail((String)"sql exception expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        brs.setByte(1, (byte)1);
        Object[] params = brs.getParams();
        BaseRowSetTest.assertNotNull((Object)params);
        BaseRowSetTest.assertEquals((int)1, (int)params.length);
        BaseRowSetTest.assertEquals((Object)1, (Object)params[0]);
    }

    public void testSetShort() throws Exception {
        BaseRowSetImpl brs = new BaseRowSetImpl(null);
        try {
            brs.setShort(1, (short)1);
            BaseRowSetTest.fail((String)"sql exception expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        brs.initParams();
        try {
            brs.setShort(0, (short)1);
            BaseRowSetTest.fail((String)"sql exception expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        brs.setShort(1, (short)1);
        Object[] params = brs.getParams();
        BaseRowSetTest.assertNotNull((Object)params);
        BaseRowSetTest.assertEquals((int)1, (int)params.length);
        BaseRowSetTest.assertEquals((Object)1, (Object)params[0]);
    }

    public void testSetFetchDirectionI() throws SQLException {
        BaseRowSetImpl brs = new BaseRowSetImpl(null);
        brs.setFetchDirection(1000);
        BaseRowSetTest.assertEquals((int)1000, (int)brs.getFetchDirection());
        brs.setType(1005);
        brs.setFetchDirection(1002);
        BaseRowSetTest.assertEquals((int)1002, (int)brs.getFetchDirection());
        brs.setType(1003);
        try {
            brs.setFetchDirection(1001);
            BaseRowSetTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            brs.setFetchDirection(1100);
            BaseRowSetTest.fail((String)"should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testSetTypeMap() {
        BaseRowSetImpl brs = new BaseRowSetImpl(null);
        brs.setTypeMap(null);
        BaseRowSetTest.assertNull((Object)brs.getTypeMap());
    }

    public void testSetArray() throws SQLException {
        BaseRowSetImpl brs = new BaseRowSetImpl(null);
        brs.initParams();
        MockArray a = new MockArray();
        brs.setArray(1, (Array)a);
        Object[] params = brs.getParams();
        BaseRowSetTest.assertNotNull((Object)params);
        BaseRowSetTest.assertEquals((int)1, (int)params.length);
        BaseRowSetTest.assertTrue((String)"Should have stored a SerialArray", (boolean)(params[0] instanceof SerialArray));
    }

    public void testSetBlob() throws SQLException {
        BaseRowSetImpl brs = new BaseRowSetImpl(null);
        brs.initParams();
        MockBlob b = new MockBlob();
        brs.setBlob(1, (Blob)b);
        Object[] params = brs.getParams();
        BaseRowSetTest.assertNotNull((Object)params);
        BaseRowSetTest.assertEquals((int)1, (int)params.length);
        BaseRowSetTest.assertTrue((String)"Should have stored a SerialBlob", (boolean)(params[0] instanceof SerialBlob));
    }

    public void testSetClob() throws SQLException {
        BaseRowSetImpl brs = new BaseRowSetImpl(null);
        brs.initParams();
        MockClob c = new MockClob();
        brs.setClob(1, (Clob)c);
        Object[] params = brs.getParams();
        BaseRowSetTest.assertNotNull((Object)params);
        BaseRowSetTest.assertEquals((int)1, (int)params.length);
        BaseRowSetTest.assertTrue((c != params[0] ? 1 : 0) != 0);
        BaseRowSetTest.assertTrue((String)"Should have stored a SerialClob", (boolean)(params[0] instanceof SerialClob));
    }

    public void testSetRef() throws SQLException {
        BaseRowSetImpl brs = new BaseRowSetImpl(null);
        brs.initParams();
        MockRef r = new MockRef();
        brs.setRef(1, (Ref)r);
        Object[] params = brs.getParams();
        BaseRowSetTest.assertNotNull((Object)params);
        BaseRowSetTest.assertEquals((int)1, (int)params.length);
        BaseRowSetTest.assertTrue((r != params[0] ? 1 : 0) != 0);
        BaseRowSetTest.assertTrue((String)"Should have stored a SerialRef", (boolean)(params[0] instanceof SerialRef));
    }
}

