/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cpe.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.collection.metadata.CasProcessorConfigurationParameterSettings;
import org.apache.uima.cpe.model.ConfigParameterModel;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.NameValuePair;
import org.apache.uima.tools.debug.util.Trace;

public class ConfigParametersModel {
    private List paramModelList = new ArrayList();
    private List cpeParamModelList = null;
    private ConfigurationParameterDeclarations paramDeclarations;
    private ConfigurationParameterSettings paramSettings;

    public ConfigParametersModel(ConfigurationParameterDeclarations decls, ConfigurationParameterSettings settings) {
        this(decls, settings, null);
    }

    public ConfigParametersModel(ConfigurationParameterDeclarations decls, ConfigurationParameterSettings settings, CasProcessorConfigurationParameterSettings cpeSettings) {
        this.paramDeclarations = decls;
        this.paramSettings = settings;
        if (this.paramDeclarations == null) {
            return;
        }
        ConfigurationParameter[] params = this.paramDeclarations.getConfigurationParameters();
        for (int i = 0; i < params.length; ++i) {
            ConfigParameterModel paramModel = new ConfigParameterModel(params[i]);
            paramModel.setValue(this.paramSettings.getParameterValue(paramModel.getName()));
            if (cpeSettings != null) {
                Object cpeValue = cpeSettings.getParameterValue(paramModel.getName());
                if (cpeValue == null) {
                    cpeValue = this.paramSettings.getParameterValue(paramModel.getName());
                }
                paramModel.setCpeValue(cpeValue);
                if (this.cpeParamModelList == null) {
                    this.cpeParamModelList = new ArrayList();
                }
                this.cpeParamModelList.add(paramModel);
            } else {
                paramModel.setCpeValue(this.paramSettings.getParameterValue(paramModel.getName()));
            }
            this.paramModelList.add(paramModel);
        }
    }

    protected void setCpeConfigParamSettings(ConfigurationParameterSettings cpeSettings) {
        if (this.cpeParamModelList == null) {
            this.cpeParamModelList = new ArrayList();
        }
        for (int i = 0; i < this.paramModelList.size(); ++i) {
            ConfigParameterModel paramModel = (ConfigParameterModel)this.paramModelList.get(i);
            Object cpeValue = cpeSettings.getParameterValue(paramModel.getName());
            if (cpeValue == null) {
                cpeValue = this.paramSettings.getParameterValue(paramModel.getName());
            }
            paramModel.setCpeValue(cpeValue);
            this.cpeParamModelList.add(paramModel);
        }
    }

    public ConfigParameterModel getConfigParameterModel(String paramName) {
        for (int i = 0; i < this.paramModelList.size(); ++i) {
            if (!paramName.equals(((ConfigParameterModel)this.paramModelList.get(i)).getName())) continue;
            return (ConfigParameterModel)this.paramModelList.get(i);
        }
        Trace.trace("Cannot find ConfigParameterModel:" + paramName);
        return null;
    }

    public ConfigurationParameterDeclarations getParamDeclarations() {
        return this.paramDeclarations;
    }

    public void setParamDeclarations(ConfigurationParameterDeclarations paramDeclarations) {
        this.paramDeclarations = paramDeclarations;
    }

    public ConfigurationParameterSettings getParamSettings() {
        return this.paramSettings;
    }

    public void setParamSettings(ConfigurationParameterSettings paramSettings) {
        this.paramSettings = paramSettings;
    }

    public List getParamModelList() {
        return this.paramModelList;
    }

    public void setParamModelList(List paramModelList) {
        this.paramModelList = paramModelList;
    }

    public List getCpeParamModelList() {
        return this.cpeParamModelList;
    }

    public void setCpeParamModelList(List cpeParamModelList) {
        this.cpeParamModelList = cpeParamModelList;
    }

    public static void printNameValuePairs(NameValuePair[] nvs) {
        for (int i = 0; i < nvs.length; ++i) {
            String name = nvs[i].getName();
            Trace.trace("Param name:" + nvs[i].getName());
            Object aValue = nvs[i].getValue();
            if (aValue == null) {
                System.out.println("    no value");
            }
            if (aValue instanceof String) continue;
            if (aValue instanceof Integer) {
                System.out.println("    Integer" + (Integer)aValue);
                continue;
            }
            if (aValue instanceof Float || aValue instanceof Boolean || !(aValue instanceof Object[])) continue;
            Object[] obj = (Object[])aValue;
            System.out.println("    Object[]:" + obj.length);
            for (int k = 0; k < obj.length; ++k) {
                if (obj[k] instanceof String) {
                    System.out.println("    [" + k + "]:" + obj[k].toString());
                    continue;
                }
                if (obj[k] instanceof Integer) {
                    System.out.println("    [" + k + "]:" + (Integer)obj[k]);
                    continue;
                }
                if (obj[k] instanceof Float) {
                    System.out.println("    [" + k + "]:" + ((Float)obj[k]).floatValue());
                    continue;
                }
                if (!(obj[k] instanceof Boolean)) continue;
                System.out.println("    [" + k + "]:" + (Boolean)obj[k]);
            }
        }
    }
}

