/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util.ser.binary;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.util.message.RequestMessage;
import org.apache.tinkerpop.gremlin.util.ser.NettyBufferFactory;
import org.apache.tinkerpop.gremlin.util.ser.SerializationException;

public class RequestMessageSerializer {
    private static NettyBufferFactory bufferFactory = new NettyBufferFactory();

    public RequestMessage readValue(ByteBuf byteBuf, GraphBinaryReader context) throws SerializationException {
        Buffer buffer = bufferFactory.create(byteBuf);
        int version = buffer.readByte() & 0xFF;
        if (version >>> 7 != 1) {
            throw new SerializationException("The most significant bit should be set according to the format");
        }
        try {
            Map fields = (Map)context.readValue(buffer, Map.class, false);
            String gremlin = (String)context.readValue(buffer, String.class, false);
            RequestMessage.Builder builder = RequestMessage.build(gremlin);
            if (fields.containsKey("language")) {
                builder.addLanguage(fields.get("language").toString());
            }
            if (fields.containsKey("g")) {
                builder.addG(fields.get("g").toString());
            }
            if (fields.containsKey("bindings")) {
                builder.addBindings((Map)fields.get("bindings"));
            }
            if (fields.containsKey("timeoutMs")) {
                builder.addTimeoutMillis((Long)fields.get("timeoutMs"));
            }
            if (fields.containsKey("materializeProperties")) {
                builder.addMaterializeProperties(fields.get("materializeProperties").toString());
            }
            if (fields.containsKey("batchSize")) {
                builder.addChunkSize((Integer)fields.get("batchSize"));
            }
            if (fields.containsKey("bulkResults")) {
                builder.addBulkResults(Boolean.parseBoolean(fields.get("bulkResults").toString()));
            }
            return builder.create();
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }

    public void writeValue(RequestMessage value, ByteBuf byteBuf, GraphBinaryWriter context) throws SerializationException {
        Buffer buffer = bufferFactory.create(byteBuf);
        try {
            buffer.writeByte(-127);
            context.writeValue(value.getFields(), buffer, false);
            context.writeValue((Object)value.getGremlin(), buffer, false);
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }
}

