/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.interceptor;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.tinkerpop.gremlin.driver.HttpRequest;
import org.apache.tinkerpop.gremlin.driver.RequestInterceptor;
import org.apache.tinkerpop.gremlin.driver.exception.ResponseException;
import org.apache.tinkerpop.gremlin.util.MessageSerializer;
import org.apache.tinkerpop.gremlin.util.message.RequestMessage;
import org.apache.tinkerpop.gremlin.util.ser.SerializationException;

public class PayloadSerializingInterceptor
implements RequestInterceptor {
    private final MessageSerializer serializer;

    public PayloadSerializingInterceptor(MessageSerializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public HttpRequest apply(HttpRequest httpRequest) {
        ByteBuf requestBuf;
        if (!(httpRequest.getBody() instanceof RequestMessage)) {
            throw new IllegalArgumentException("Only RequestMessage serialization is supported");
        }
        RequestMessage request = (RequestMessage)httpRequest.getBody();
        try {
            requestBuf = this.serializer.serializeRequestAsBinary(request, ByteBufAllocator.DEFAULT);
        }
        catch (SerializationException se) {
            throw new RuntimeException(new ResponseException(HttpResponseStatus.BAD_REQUEST, String.format("An error occurred during serialization of this request [%s] - it could not be sent to the server - Reason: %s", new Object[]{request, se})));
        }
        byte[] requestBytes = ByteBufUtil.getBytes((ByteBuf)requestBuf);
        requestBuf.release();
        httpRequest.setBody(requestBytes);
        httpRequest.headers().put("content-type", this.serializer.mimeTypesSupported()[0]);
        return httpRequest;
    }
}

