/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.test.ioc;

import org.easymock.EasyMock;
import org.easymock.IMocksControl;

public final class MockTester {
    private final ThreadLocalControl localControl = new ThreadLocalControl();

    public synchronized void cleanup() {
        this.localControl.remove();
    }

    public synchronized IMocksControl getMocksControl() {
        return (IMocksControl)this.localControl.get();
    }

    public <T> T newMock(Class<T> mockClass) {
        return (T)this.getMocksControl().createMock(mockClass.getSimpleName(), mockClass);
    }

    public void replay() {
        this.getMocksControl().replay();
    }

    public void verify() {
        IMocksControl control = this.getMocksControl();
        control.verify();
        control.reset();
    }

    private static class ThreadLocalControl
    extends ThreadLocal<IMocksControl> {
        private ThreadLocalControl() {
        }

        @Override
        protected IMocksControl initialValue() {
            return EasyMock.createControl();
        }
    }
}

