/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.jpa;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.jpa.TapestryPersistenceUnitInfo;

public class PersistenceUnitInfoImpl
implements TapestryPersistenceUnitInfo {
    private String persistenceUnitName;
    private String persistenceProviderClassName;
    private String persistenceXMLSchemaVersion;
    private PersistenceUnitTransactionType transactionType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
    private DataSource nonJtaDataSource;
    private DataSource jtaDataSource;
    private ValidationMode validationMode;
    private SharedCacheMode sharedCacheMode;
    private boolean excludeUnlistedClasses = true;
    private final Set<String> managedClassNames = CollectionFactory.newSet();
    private final Set<String> mappingFilesNames = CollectionFactory.newSet();
    private final List<URL> jarFileUrls = CollectionFactory.newList();
    private final Properties properties = new Properties();
    private Map entityManagerProperties;

    public PersistenceUnitInfoImpl(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public String getPersistenceProviderClassName() {
        return this.persistenceProviderClassName;
    }

    @Override
    public TapestryPersistenceUnitInfo persistenceProviderClassName(String persistenceProviderClassName) {
        this.persistenceProviderClassName = persistenceProviderClassName;
        return this;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.transactionType;
    }

    @Override
    public TapestryPersistenceUnitInfo transactionType(PersistenceUnitTransactionType transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    public DataSource getJtaDataSource() {
        return this.jtaDataSource;
    }

    public DataSource getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    @Override
    public TapestryPersistenceUnitInfo nonJtaDataSource(String nonJtaDataSource) {
        this.nonJtaDataSource = this.lookupDataSource(nonJtaDataSource);
        return this;
    }

    @Override
    public TapestryPersistenceUnitInfo jtaDataSource(String jtaDataSource) {
        this.jtaDataSource = this.lookupDataSource(jtaDataSource);
        return this;
    }

    public List<String> getMappingFileNames() {
        List tmp = CollectionFactory.newList(this.mappingFilesNames);
        return Collections.unmodifiableList(tmp);
    }

    @Override
    public TapestryPersistenceUnitInfo addMappingFileName(String fileName) {
        this.mappingFilesNames.add(fileName);
        return this;
    }

    @Override
    public TapestryPersistenceUnitInfo addJarFileUrl(URL url) {
        this.jarFileUrls.add(url);
        return this;
    }

    @Override
    public TapestryPersistenceUnitInfo addJarFileUrl(String url) {
        try {
            return this.addJarFileUrl(new URL(this.getPersistenceUnitRootUrl(), url));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TapestryPersistenceUnitInfo addProperty(String name, String value) {
        this.getProperties().put(name, value);
        return this;
    }

    @Override
    public TapestryPersistenceUnitInfo excludeUnlistedClasses(boolean exclude) {
        this.excludeUnlistedClasses = exclude;
        return this;
    }

    public List<URL> getJarFileUrls() {
        return Collections.unmodifiableList(this.jarFileUrls);
    }

    public URL getPersistenceUnitRootUrl() {
        return this.getClass().getResource("/");
    }

    public List<String> getManagedClassNames() {
        List tmp = CollectionFactory.newList(this.managedClassNames);
        return Collections.unmodifiableList(tmp);
    }

    @Override
    public TapestryPersistenceUnitInfo addManagedClassName(String className) {
        this.managedClassNames.add(className);
        return this;
    }

    @Override
    public TapestryPersistenceUnitInfo addManagedClass(Class<?> clazz) {
        this.addManagedClassName(clazz.getName());
        return this;
    }

    public boolean excludeUnlistedClasses() {
        return this.excludeUnlistedClasses;
    }

    public SharedCacheMode getSharedCacheMode() {
        return this.sharedCacheMode;
    }

    @Override
    public TapestryPersistenceUnitInfo sharedCacheMode(SharedCacheMode cacheMode) {
        this.sharedCacheMode = cacheMode;
        return this;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    @Override
    public TapestryPersistenceUnitInfo validationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getPersistenceXMLSchemaVersion() {
        return this.persistenceXMLSchemaVersion;
    }

    public void setPersistenceXMLSchemaVersion(String version) {
        this.persistenceXMLSchemaVersion = version;
    }

    public ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public void addTransformer(ClassTransformer transformer) {
    }

    public ClassLoader getNewTempClassLoader() {
        return this.getClassLoader();
    }

    private DataSource lookupDataSource(String name) {
        try {
            InitialContext initContext = new InitialContext();
            Context envContext = (Context)initContext.lookup("java:comp/env");
            return (DataSource)envContext.lookup(name);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TapestryPersistenceUnitInfo setEntityManagerProperties(Map properties) {
        this.entityManagerProperties = properties;
        return this;
    }

    @Override
    public Map getEntityManagerProperties() {
        return this.entityManagerProperties;
    }
}

