/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.Closeable;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.internal.services.ClientPersistentFieldStorage;
import org.apache.tapestry5.internal.services.PersistentFieldChangeImpl;
import org.apache.tapestry5.ioc.annotations.Scope;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.ClientDataEncoder;
import org.apache.tapestry5.services.ClientDataSink;
import org.apache.tapestry5.services.PersistentFieldChange;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.SessionPersistedObjectAnalyzer;

@Scope(value="perthread")
public class ClientPersistentFieldStorageImpl
implements ClientPersistentFieldStorage {
    static final String PARAMETER_NAME = "t:state:client";
    private final ClientDataEncoder clientDataEncoder;
    private final SessionPersistedObjectAnalyzer analyzer;
    private final Map<Key, Object> persistedValues = CollectionFactory.newMap();
    private String clientData;
    private boolean mapUptoDate = false;

    public ClientPersistentFieldStorageImpl(Request request, ClientDataEncoder clientDataEncoder, SessionPersistedObjectAnalyzer analyzer) {
        this.clientDataEncoder = clientDataEncoder;
        this.analyzer = analyzer;
        String value = request.getParameter(PARAMETER_NAME);
        this.clientData = value == null ? null : value.replace(' ', '+');
    }

    @Override
    public void updateLink(Link link) {
        this.refreshClientData();
        if (this.clientData != null) {
            link.addParameter(PARAMETER_NAME, this.clientData);
        }
    }

    @Override
    public Collection<PersistentFieldChange> gatherFieldChanges(String pageName) {
        this.refreshMap();
        if (this.persistedValues.isEmpty()) {
            return Collections.emptyList();
        }
        List result = CollectionFactory.newList();
        for (Map.Entry<Key, Object> e : this.persistedValues.entrySet()) {
            Key key = e.getKey();
            if (!key.matches(pageName)) continue;
            result.add(key.toChange(e.getValue()));
        }
        return result;
    }

    @Override
    public void discardChanges(String pageName) {
        this.refreshMap();
        List removedKeys = CollectionFactory.newList();
        for (Key key : this.persistedValues.keySet()) {
            if (!key.pageName.equals(pageName)) continue;
            removedKeys.add(key);
        }
        for (Key key : removedKeys) {
            this.persistedValues.remove(key);
            this.clientData = null;
        }
    }

    @Override
    public void postChange(String pageName, String componentId, String fieldName, Object newValue) {
        this.refreshMap();
        Key key = new Key(pageName, componentId, fieldName);
        if (newValue == null) {
            this.persistedValues.remove(key);
        } else {
            if (!Serializable.class.isInstance(newValue)) {
                throw new IllegalArgumentException(String.format("State persisted on the client must be serializable, but %s does not implement the Serializable interface.", newValue));
            }
            this.persistedValues.put(key, newValue);
        }
        this.clientData = null;
    }

    private void refreshMap() {
        if (this.mapUptoDate) {
            return;
        }
        this.restoreMapFromClientData();
        this.mapUptoDate = true;
    }

    private void restoreMapFromClientData() {
        this.persistedValues.clear();
        if (this.clientData == null) {
            return;
        }
        ObjectInputStream in = null;
        try {
            in = this.clientDataEncoder.decodeClientData(this.clientData);
            int count = in.readInt();
            for (int i = 0; i < count; ++i) {
                Key key = (Key)in.readObject();
                Object value = in.readObject();
                this.persistedValues.put(key, value);
            }
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Serialized client state was corrupted. This may indicate that too much state is being stored, which can cause the encoded string to be truncated by the client web browser.", ex);
            }
            catch (Throwable throwable) {
                InternalUtils.close(in);
                throw throwable;
            }
        }
        InternalUtils.close((Closeable)in);
    }

    private void refreshClientData() {
        if (this.clientData != null) {
            for (Object value : this.persistedValues.values()) {
                if (!this.analyzer.checkAndResetDirtyState(value)) continue;
                this.clientData = null;
                break;
            }
        }
        if (this.clientData != null) {
            return;
        }
        if (!this.mapUptoDate) {
            return;
        }
        if (this.persistedValues.isEmpty()) {
            return;
        }
        ClientDataSink sink = this.clientDataEncoder.createSink();
        ObjectOutputStream os = sink.getObjectOutputStream();
        try {
            os.writeInt(this.persistedValues.size());
            for (Map.Entry<Key, Object> e : this.persistedValues.entrySet()) {
                os.writeObject(e.getKey());
                os.writeObject(e.getValue());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        finally {
            InternalUtils.close((Closeable)os);
        }
        this.clientData = sink.getClientData();
    }

    private static class Key
    implements Serializable {
        private static final long serialVersionUID = -2741540370081645945L;
        private final String pageName;
        private final String componentId;
        private final String fieldName;

        Key(String pageName, String componentId, String fieldName) {
            this.pageName = pageName;
            this.componentId = componentId;
            this.fieldName = fieldName;
        }

        public boolean matches(String pageName) {
            return this.pageName.equals(pageName);
        }

        public PersistentFieldChange toChange(Object value) {
            return new PersistentFieldChangeImpl(this.componentId == null ? "" : this.componentId, this.fieldName, value);
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.componentId == null ? 0 : this.componentId.hashCode());
            result = 31 * result + this.fieldName.hashCode();
            result = 31 * result + this.pageName.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (!this.fieldName.equals(other.fieldName)) {
                return false;
            }
            if (!this.pageName.equals(other.pageName)) {
                return false;
            }
            return !(this.componentId == null ? other.componentId != null : !this.componentId.equals(other.componentId));
        }
    }
}

