/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.ioc.BaseLocatable;
import org.apache.tapestry5.ioc.Location;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.model.MutableEmbeddedComponentModel;

public class MutableEmbeddedComponentModelImpl
extends BaseLocatable
implements MutableEmbeddedComponentModel {
    private final String id;
    private final String componentType;
    private final String componentClassName;
    private final String declaredClass;
    private final boolean inheritInformalParameters;
    private Map<String, String> parameters;
    private List<String> publishedParameters = Collections.emptyList();
    private List<String> mixinClassNames;
    private Map<String, String[]> mixinConstraints;

    public MutableEmbeddedComponentModelImpl(String id, String componentType, String componentClassName, String declaredClass, boolean inheritInformalParameters, Location location) {
        super(location);
        this.id = id;
        this.componentType = componentType;
        this.componentClassName = componentClassName;
        this.inheritInformalParameters = inheritInformalParameters;
        this.declaredClass = declaredClass;
    }

    @Override
    public String getComponentClassName() {
        return this.componentClassName;
    }

    public String toString() {
        return String.format("EmbeddedComponentModel[id=%s type=%s class=%s inheritInformals=%s]", this.id, this.componentType, this.componentClassName, this.inheritInformalParameters);
    }

    @Override
    public void addParameter(String name, String value) {
        if (this.parameters == null) {
            this.parameters = CollectionFactory.newMap();
        } else if (this.parameters.containsKey(name)) {
            throw new IllegalArgumentException(String.format("A value for parameter '%s' of embedded component %s (of component class %s) has already been provided.", name, this.id, this.declaredClass));
        }
        this.parameters.put(name, value);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getComponentType() {
        return this.componentType;
    }

    @Override
    public List<String> getParameterNames() {
        return InternalUtils.sortedKeys(this.parameters);
    }

    @Override
    public String getParameterValue(String parameterName) {
        return (String)InternalUtils.get(this.parameters, (Object)parameterName);
    }

    @Override
    public List<String> getMixinClassNames() {
        if (this.mixinClassNames == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.mixinClassNames);
    }

    @Override
    public void addMixin(String mixinClassName, String ... constraints) {
        if (this.mixinClassNames == null) {
            this.mixinClassNames = CollectionFactory.newList();
            this.mixinConstraints = CollectionFactory.newCaseInsensitiveMap();
        } else if (this.mixinClassNames.contains(mixinClassName)) {
            throw new IllegalArgumentException(String.format("Mixin %s (for component %s) has already been defined.", mixinClassName, this.id));
        }
        this.mixinClassNames.add(mixinClassName);
        this.mixinConstraints.put(mixinClassName, constraints);
    }

    @Override
    public boolean getInheritInformalParameters() {
        return this.inheritInformalParameters;
    }

    @Override
    public void setPublishedParameters(List<String> parameterNames) {
        assert (parameterNames != null);
        this.publishedParameters = parameterNames;
    }

    @Override
    public List<String> getPublishedParameters() {
        return this.publishedParameters;
    }

    @Override
    public String[] getConstraintsForMixin(String mixinClassName) {
        return (String[])InternalUtils.get(this.mixinConstraints, (Object)mixinClassName);
    }
}

