/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.parfor.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class IDHandler {
    public static int extractIntID(String taskID) {
        int maxlen = (int)Math.log10(2.147483647E9);
        int intVal = (int)IDHandler.extractID(taskID, maxlen);
        return intVal;
    }

    public static long concatIntIDsToLong(int part1, int part2) {
        long value = (long)part1 << 32;
        return value |= (long)part2;
    }

    public static int extractIntIDFromLong(long val, int part) {
        int ret = -1;
        if (part == 1) {
            ret = (int)(val >>> 32);
        } else if (part == 2) {
            ret = (int)val;
        }
        return ret;
    }

    public static String createDistributedUniqueID() {
        Object uuid = "0_0.0.0.0";
        try {
            long pid = IDHandler.getProcessID();
            String host = IDHandler.getIPAddress(false);
            uuid = pid + "_" + host;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uuid;
    }

    public static long getProcessID() {
        return ProcessHandle.current().pid();
    }

    public static String getIPAddress(boolean noLocal) throws SocketException, UnknownHostException {
        String ipAddr = null;
        if (noLocal) {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                Enumeration<InetAddress> ee = e.nextElement().getInetAddresses();
                while (ee.hasMoreElements()) {
                    String tmp = ee.nextElement().getHostAddress();
                    if (tmp == null || tmp.contains("192.168.0.") || tmp.contains("127.0.0.1") || tmp.contains(":")) continue;
                    ipAddr = tmp;
                }
            }
        }
        if (ipAddr == null) {
            ipAddr = InetAddress.getLocalHost().getHostAddress();
        }
        return ipAddr;
    }

    private static long extractID(String taskID, int maxlen) {
        char[] c = taskID.toCharArray();
        long value = 0L;
        int count = 0;
        for (int i = c.length - 1; i >= 0 && count < maxlen; --i) {
            if (c[i] < '0' || c[i] > '9') continue;
            long newVal = c[i] - 48;
            value += (newVal *= (long)Math.pow(10.0, count));
            ++count;
        }
        return value;
    }
}

