/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.parfor.opt;

import org.apache.sysds.common.Types;
import org.apache.sysds.hops.cost.CostEstimationWrapper;
import org.apache.sysds.runtime.controlprogram.LocalVariableMap;
import org.apache.sysds.runtime.controlprogram.ProgramBlock;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContextFactory;
import org.apache.sysds.runtime.controlprogram.parfor.opt.CostEstimator;
import org.apache.sysds.runtime.controlprogram.parfor.opt.CostEstimatorHops;
import org.apache.sysds.runtime.controlprogram.parfor.opt.OptNode;
import org.apache.sysds.runtime.controlprogram.parfor.opt.OptTreePlanMapping;

public class CostEstimatorRuntime
extends CostEstimator {
    private final CostEstimatorHops _costMem;
    private final OptTreePlanMapping _map;
    private final ExecutionContext _ec;

    public CostEstimatorRuntime(OptTreePlanMapping map, LocalVariableMap vars) {
        this._costMem = new CostEstimatorHops(map);
        this._map = map;
        this._ec = ExecutionContextFactory.createContext();
        this._ec.setVariables(vars);
    }

    @Override
    public double getLeafNodeEstimate(CostEstimator.TestMeasure measure, OptNode node) {
        if (measure == CostEstimator.TestMeasure.MEMORY_USAGE) {
            return this._costMem.getLeafNodeEstimate(measure, node);
        }
        return this.getLeafNodeEstimate(measure, node, node.isCPOnly() ? Types.ExecType.CP : Types.ExecType.SPARK);
    }

    @Override
    public double getLeafNodeEstimate(CostEstimator.TestMeasure measure, OptNode node, Types.ExecType et) {
        boolean isCP;
        if (measure == CostEstimator.TestMeasure.MEMORY_USAGE) {
            return this._costMem.getLeafNodeEstimate(measure, node, et);
        }
        double ret = 5.0;
        boolean bl = isCP = et == Types.ExecType.CP || et == null;
        if (!node.isLeaf() && isCP) {
            ProgramBlock pb = (ProgramBlock)this._map.getMappedProg(node.getID())[1];
            ret = CostEstimationWrapper.getTimeEstimate(pb, this._ec, true);
        }
        return ret;
    }
}

