/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.lib;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.lib.CLALibLeftMultBy;
import org.apache.sysds.runtime.compress.lib.CLALibRightMultBy;
import org.apache.sysds.runtime.functionobjects.SwapIndex;
import org.apache.sysds.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.ReorgOperator;

public final class CLALibMatrixMult {
    private static final Log LOG = LogFactory.getLog((String)CLALibMatrixMult.class.getName());

    private CLALibMatrixMult() {
    }

    public static MatrixBlock matrixMult(MatrixBlock m1, MatrixBlock m2, MatrixBlock ret, int k) {
        return CLALibMatrixMult.matrixMultiply(m1, m2, ret, k, false, false);
    }

    public static MatrixBlock matrixMultiply(MatrixBlock m1, MatrixBlock m2, MatrixBlock ret, int k, boolean transposeLeft, boolean transposeRight) {
        boolean right;
        if (m1 instanceof CompressedMatrixBlock && m2 instanceof CompressedMatrixBlock) {
            return CLALibMatrixMult.doubleCompressedMatrixMultiply((CompressedMatrixBlock)m1, (CompressedMatrixBlock)m2, ret, k, transposeLeft, transposeRight);
        }
        boolean transposeOutput = false;
        if (transposeLeft || transposeRight) {
            if (m1 instanceof CompressedMatrixBlock && transposeLeft || m2 instanceof CompressedMatrixBlock && transposeRight) {
                transposeOutput = true;
                MatrixBlock tmp = m1;
                m1 = m2;
                m2 = tmp;
                boolean tmpLeft = transposeLeft;
                transposeLeft = !transposeRight;
                boolean bl = transposeRight = !tmpLeft;
            }
            if (!(m1 instanceof CompressedMatrixBlock) && transposeLeft) {
                m1 = LibMatrixReorg.transpose(m1, k, true);
                transposeLeft = false;
            } else if (!(m2 instanceof CompressedMatrixBlock) && transposeRight) {
                m2 = LibMatrixReorg.transpose(m2, k, true);
                transposeRight = false;
            }
        }
        CompressedMatrixBlock c = (CompressedMatrixBlock)((right = m1 instanceof CompressedMatrixBlock) ? m1 : m2);
        MatrixBlock that = right ? m2 : m1;
        ret = right ? CLALibRightMultBy.rightMultByMatrix(c, that, ret, k) : CLALibLeftMultBy.leftMultByMatrix(c, that, ret, k);
        if (transposeOutput) {
            if (ret instanceof CompressedMatrixBlock) {
                LOG.warn((Object)"Transposing decompression");
                ret = ((CompressedMatrixBlock)ret).decompress(k);
            }
            ret = LibMatrixReorg.transpose(ret, k, true);
        }
        return ret;
    }

    private static MatrixBlock doubleCompressedMatrixMultiply(CompressedMatrixBlock m1, CompressedMatrixBlock m2, MatrixBlock ret, int k, boolean transposeLeft, boolean transposeRight) {
        if (!transposeLeft && !transposeRight) {
            LOG.warn((Object)"Matrix decompression from multiplying two compressed matrices.");
            return CLALibMatrixMult.matrixMultiply(m1, CompressedMatrixBlock.getUncompressed(m2), ret, k, transposeLeft, transposeRight);
        }
        if (transposeLeft && !transposeRight) {
            if (m1.getNumColumns() > m2.getNumColumns()) {
                ret = CLALibLeftMultBy.leftMultByMatrixTransposed(m1, m2, ret, k);
                ReorgOperator r_op = new ReorgOperator(SwapIndex.getSwapIndexFnObject(), k);
                return ret.reorgOperations(r_op, new MatrixBlock(), 0, 0, 0);
            }
            return CLALibLeftMultBy.leftMultByMatrixTransposed(m2, m1, ret, k);
        }
        if (!transposeLeft && transposeRight) {
            throw new DMLCompressionException("Not Implemented compressed Matrix Mult to produce larger matrix");
        }
        ret = CLALibMatrixMult.matrixMult(m2, m1, ret, k);
        ReorgOperator r_op = new ReorgOperator(SwapIndex.getSwapIndexFnObject(), k);
        return ret.reorgOperations(r_op, new MatrixBlock(), 0, 0, 0);
    }
}

