/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.lib;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;
import org.apache.sysds.runtime.frame.data.columns.ColumnMetadata;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.DataConverter;

public class FrameLibRemoveEmpty {
    protected static final Log LOG = LogFactory.getLog((String)FrameLibRemoveEmpty.class.getName());
    private final FrameBlock in;
    private final boolean rows;
    private final boolean emptyReturn;
    private final MatrixBlock select;
    private final int nRow;
    private final int nCol;

    public static FrameBlock removeEmpty(FrameBlock fb, boolean rows, boolean emptyReturn, MatrixBlock select) {
        return new FrameLibRemoveEmpty(fb, rows, emptyReturn, select).apply();
    }

    private FrameLibRemoveEmpty(FrameBlock in, boolean rows, boolean emptyReturn, MatrixBlock select) {
        this.in = in;
        this.rows = rows;
        this.emptyReturn = emptyReturn;
        this.select = select;
        this.nRow = in.getNumRows();
        this.nCol = in.getNumColumns();
        this.verify();
    }

    private void verify() {
        if (this.select != null) {
            int SnRows = this.select.getNumRows();
            int SnCols = this.select.getNumColumns();
            boolean notValid = !this.rows && (SnCols != this.nCol || SnRows != 1);
            if (notValid |= this.rows && (SnRows != this.nRow || SnCols != 1)) {
                throw new DMLRuntimeException("Frame rmempty incorrect select vector dimensions");
            }
        }
    }

    private FrameBlock apply() {
        FrameBlock ret = this.rows ? this.removeEmptyRows() : this.removeEmptyColumns();
        return ret;
    }

    private FrameBlock removeEmptyRows() {
        return this.select == null ? this.removeEmptyRowsNoSelect() : this.removeEMptyRowsWithSelect();
    }

    private FrameBlock removeEmptyRowsNoSelect() {
        FrameBlock ret = new FrameBlock();
        boolean[] select = new boolean[this.nRow];
        for (int i = 0; i < this.nCol; ++i) {
            this.in.getColumn(i).findEmpty(select);
        }
        int nTrue = FrameLibRemoveEmpty.getNumberTrue(select);
        if (nTrue == 0) {
            return this.removeEmptyRowsEmptyReturn();
        }
        if (nTrue == this.nRow) {
            return new FrameBlock(this.in);
        }
        String[] colNames = this.in.getColumnNames(false);
        for (int i = 0; i < this.nCol; ++i) {
            ret.appendColumn(this.in.getColumn(i).select(select, nTrue));
            if (colNames == null) continue;
            ret.setColumnName(i, colNames[i]);
        }
        return ret;
    }

    private FrameBlock removeEMptyRowsWithSelect() {
        if (this.select.getNonZeros() == (long)this.nRow) {
            return this.in;
        }
        if (this.select.isEmpty()) {
            return this.removeEmptyRowsEmptyReturn();
        }
        String[] colNames = this.in.getColumnNames(false);
        FrameBlock ret = new FrameBlock();
        int[] indices = DataConverter.convertVectorToIndexList(this.select);
        for (int i = 0; i < this.nCol; ++i) {
            ret.appendColumn(this.in.getColumn(i).select(indices));
            if (colNames == null) continue;
            ret.setColumnName(i, colNames[i]);
        }
        return ret;
    }

    private FrameBlock removeEmptyRowsEmptyReturn() {
        Types.ValueType[] schema = this.in.getSchema();
        String[] colNames = this.in.getColumnNames(false);
        if (this.emptyReturn) {
            String[][] arr = new String[][]{new String[schema.length]};
            return new FrameBlock(schema, colNames, arr);
        }
        return new FrameBlock(schema, colNames);
    }

    public static int getNumberTrue(boolean[] select) {
        int i = 0;
        for (boolean b : select) {
            i += b ? 1 : 0;
        }
        return i;
    }

    private FrameBlock removeEmptyColumns() {
        ArrayList<ColumnMetadata> columnMetadata = new ArrayList<ColumnMetadata>();
        String[] colNames = this.in.getColumnNames(false);
        int k = 0;
        FrameBlock ret = new FrameBlock();
        if (this.select == null) {
            for (int i = 0; i < this.nCol; ++i) {
                Array<?> colData = this.in.getColumn(i);
                if (colData.isEmpty()) continue;
                ret.appendColumn(colData);
                columnMetadata.add(new ColumnMetadata(this.in.getColumnMetadata(i)));
                if (colNames == null) continue;
                ret.setColumnName(k++, colNames[i]);
            }
            if (ret.getNumColumns() == 0) {
                return this.removeEmptyColumnsEmptyReturn();
            }
            return ret;
        }
        if (this.select.getNonZeros() == (long)this.nCol) {
            return new FrameBlock(this.in);
        }
        if (this.select.getNonZeros() == 0L) {
            return this.removeEmptyColumnsEmptyReturn();
        }
        for (int i : DataConverter.convertVectorToIndexList(this.select)) {
            ret.appendColumn(this.in.getColumn(i));
            columnMetadata.add(new ColumnMetadata(this.in.getColumnMetadata(i)));
            if (colNames == null) continue;
            ret.setColumnName(k++, colNames[i]);
        }
        return ret;
    }

    private FrameBlock removeEmptyColumnsEmptyReturn() {
        if (this.emptyReturn) {
            FrameBlock ret = new FrameBlock();
            ret.appendColumn(ArrayFactory.create(new String[this.nRow]));
            return ret;
        }
        return new FrameBlock();
    }
}

