/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.functional;

import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public interface LinearRegression {
    public static double[] regressMatrixBlock(MatrixBlock rawBlock, IColIndex colIndexes, boolean transposed) {
        int nRows = transposed ? rawBlock.getNumColumns() : rawBlock.getNumRows();
        int nCol = colIndexes.size();
        if (nRows <= 1) {
            throw new DMLCompressionException("At least 2 data points are required to fit a linear function.");
        }
        if (nCol < 1) {
            throw new DMLCompressionException("At least 1 column must be specified for compression.");
        }
        double[] beta0_beta1 = new double[2 * nCol];
        double s_xx = (Math.pow(nRows, 3.0) - (double)nRows) / 12.0;
        double x_bar = (double)(nRows + 1) / 2.0;
        double[] colSums = new double[nCol];
        double[] weightedColSums = new double[nCol];
        if (nCol == 1) {
            if (transposed) {
                for (int rowIdx = 0; rowIdx < nRows; ++rowIdx) {
                    double value = rawBlock.getValue(colIndexes.get(0), rowIdx);
                    colSums[0] = colSums[0] + value;
                    weightedColSums[0] = weightedColSums[0] + (double)(rowIdx + 1) * value;
                }
            } else {
                for (int rowIdx = 0; rowIdx < nRows; ++rowIdx) {
                    double value = rawBlock.getValue(rowIdx, colIndexes.get(0));
                    colSums[0] = colSums[0] + value;
                    weightedColSums[0] = weightedColSums[0] + (double)(rowIdx + 1) * value;
                }
            }
        } else {
            DblArray cellVals;
            ReaderColumnSelection reader = ReaderColumnSelection.createReader(rawBlock, colIndexes, transposed);
            while ((cellVals = reader.nextRow()) != null) {
                int rowIdx = reader.getCurrentRowIndex() + 1;
                double[] row = cellVals.getData();
                for (int i = 0; i < nCol; ++i) {
                    int n = i;
                    colSums[n] = colSums[n] + row[i];
                    int n2 = i;
                    weightedColSums[n2] = weightedColSums[n2] + (double)rowIdx * row[i];
                }
            }
        }
        for (int i = 0; i < nCol; ++i) {
            beta0_beta1[nCol + i] = (-x_bar * colSums[i] + weightedColSums[i]) / s_xx;
            beta0_beta1[i] = colSums[i] / (double)nRows - beta0_beta1[nCol + i] * x_bar;
        }
        return beta0_beta1;
    }
}

