/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.iogen;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.iogen.ValueTrimFormat;
import org.apache.sysds.runtime.matrix.data.Pair;

public class RawRow {
    private final String raw;
    private ArrayList<Integer> numericPositions = new ArrayList();
    private final BitSet numericReserved;
    private final String numericRaw;
    private final BitSet reserved;
    private int numericLastIndex;
    private int rawLastIndex;
    private Pair<Integer, Integer> resultNumeric;

    public RawRow(String raw, ArrayList<Integer> numericPositions, String numericRaw) {
        this.raw = raw;
        this.numericReserved = new BitSet(numericRaw.length());
        this.numericRaw = numericRaw;
        this.reserved = new BitSet(numericRaw.length());
        this.numericPositions = numericPositions;
    }

    public RawRow(String raw) {
        this.raw = raw;
        char[] rawChars = raw.toCharArray();
        StringBuilder sbNumericRaw = new StringBuilder();
        for (int i = 0; i < rawChars.length; ++i) {
            char ch = rawChars[i];
            if (!Character.isDigit(ch)) continue;
            sbNumericRaw.append(ch);
            this.numericPositions.add(i);
        }
        this.numericReserved = new BitSet(this.numericPositions.size());
        this.numericRaw = sbNumericRaw.toString();
        this.reserved = new BitSet(raw.length());
        this.numericLastIndex = 0;
        this.rawLastIndex = 0;
    }

    public Pair<Integer, Integer> findValue(ValueTrimFormat vtf, boolean forward, boolean update) {
        Types.ValueType vt = vtf.getValueType();
        if (vt.isNumeric()) {
            return this.findNumericValue(vtf, forward, update);
        }
        if (vt == Types.ValueType.STRING) {
            return this.findStringValue(vtf, forward, update);
        }
        if (vt == Types.ValueType.BOOLEAN) {
            ValueTrimFormat vtfb = new ValueTrimFormat(vtf.getStringOfActualValue());
            return this.findStringValue(vtfb, forward, update);
        }
        return null;
    }

    public Pair<Integer, Integer> findValue(ValueTrimFormat vtf, boolean forward) {
        return this.findValue(vtf, forward, true);
    }

    public Pair<Integer, Integer> findSequenceValues(ArrayList<ValueTrimFormat> vtfs, int startIndex, boolean update) {
        int currentNumericLastIndex = this.numericLastIndex;
        int currentRawLastIndex = this.rawLastIndex;
        Pair<Integer, Integer> spair = null;
        Pair<Integer, Integer> epair = null;
        ValueTrimFormat snode = vtfs.get(0);
        this.rawLastIndex = 0;
        this.numericLastIndex = 0;
        while ((spair = this.findValue(snode, true, false)).getKey() != -1) {
            for (int i = 1; i < vtfs.size() && (epair = this.findAtValue(vtfs.get(i), this.rawLastIndex, this.numericLastIndex, false)).getKey() != -1; ++i) {
            }
            if (epair == null || (Integer)epair.getKey() == -1) continue;
        }
        if (update && epair != null && (Integer)epair.getKey() != -1) {
            this.reserved.set(spair.getKey(), epair.getKey() + epair.getValue(), true);
        } else {
            this.numericLastIndex = currentNumericLastIndex;
            this.rawLastIndex = currentRawLastIndex;
        }
        if (epair != null && (Integer)epair.getKey() != -1) {
            spair.set(spair.getKey(), epair.getKey() + epair.getValue());
        } else {
            spair.set(-1, 0);
        }
        return spair;
    }

    public Pair<Integer, Integer> findAtValue(ValueTrimFormat vtf, int rawIndex, int numericIndex, boolean update) {
        if (vtf.getValueType() == Types.ValueType.STRING) {
            return this.findAtStringValue(vtf, rawIndex, update);
        }
        if (vtf.getValueType().isNumeric()) {
            return this.findAtNumericValue(vtf, rawIndex, numericIndex, update);
        }
        if (vtf.getValueType() == Types.ValueType.BOOLEAN) {
            ValueTrimFormat vtfb = new ValueTrimFormat(vtf.getStringOfActualValue());
            return this.findAtStringValue(vtfb, rawIndex, update);
        }
        throw new RuntimeException("FindAt just work for fixed length of values!");
    }

    public Pair<Integer, Integer> findAtValue(ValueTrimFormat vtf, int rawIndex, int numericIndex) {
        return this.findAtValue(vtf, rawIndex, numericIndex, true);
    }

    private Pair<Integer, Integer> findAtStringValue(ValueTrimFormat stf, int index, boolean update) {
        Pair<Integer, Integer> result = new Pair<Integer, Integer>(-1, 0);
        int length = stf.getStringOfActualValue().length();
        if (index + length > this.raw.length() || index <= 0) {
            return result;
        }
        if (this.reserved.get(index, index + length).isEmpty() && this.raw.substring(index, index + length).equalsIgnoreCase(stf.getStringOfActualValue())) {
            result.set(index, length);
            this.rawLastIndex = result.getKey() + result.getValue();
        }
        if (result.getKey() != -1 && update) {
            this.reserved.set(result.getKey(), result.getKey() + result.getValue(), true);
        }
        return result;
    }

    private Pair<Integer, Integer> findAtNumericValue(ValueTrimFormat ntf, int rawStart, int numericStart, boolean update) {
        Double value;
        Pair<Integer, Integer> result = new Pair<Integer, Integer>(-1, 0);
        int end = rawStart;
        for (int i = rawStart; i < this.raw.length() && !this.reserved.get(i); ++i) {
            ++end;
        }
        boolean flagD = false;
        StringBuilder sb = new StringBuilder();
        for (int i = rawStart; i < end; ++i) {
            char ch = this.raw.charAt(i);
            if (ch == 'E' || ch == 'e' || ch == '+' || ch == '-') {
                sb.append(ch);
                continue;
            }
            if (!flagD && ch == '.') {
                sb.append(ch);
                flagD = true;
                continue;
            }
            if (!Character.isDigit(ch)) break;
            sb.append(ch);
        }
        if ((value = RawRow.tryParse(sb.toString())) != null && value.doubleValue() == ntf.getDoubleActualValue()) {
            result.setKey(rawStart);
            result.setValue(sb.length());
        }
        if (result.getKey() != -1) {
            int i;
            if (update) {
                for (i = this.resultNumeric.getKey() - 1; i >= 0 && this.numericPositions.get(i) >= result.getKey(); --i) {
                    this.numericReserved.set(i);
                }
                i = this.resultNumeric.getKey() + 1;
                while (i < this.numericPositions.size() && this.numericPositions.get(i) <= result.getKey() + result.getValue()) {
                    this.numericReserved.set(i);
                    this.numericLastIndex = i++;
                }
                this.numericReserved.set(this.resultNumeric.getKey(), this.resultNumeric.getKey() + this.resultNumeric.getValue(), true);
                this.reserved.set(result.getKey(), result.getKey() + result.getValue(), true);
            } else {
                i = this.resultNumeric.getKey() + 1;
                while (i < this.numericPositions.size() && this.numericPositions.get(i) <= result.getKey() + result.getValue()) {
                    this.numericLastIndex = i++;
                }
            }
            this.numericLastIndex = Math.max(this.numericLastIndex, this.resultNumeric.getKey() + this.resultNumeric.getValue());
            this.rawLastIndex = result.getKey() + result.getValue();
        }
        return result;
    }

    private Pair<Integer, Integer> findStringValue(ValueTrimFormat stf, boolean forward, boolean update) {
        ArrayList<Pair<Integer, Integer>> unreserved = this.getRawUnreservedPositions(forward);
        Pair<Integer, Integer> result = new Pair<Integer, Integer>(-1, 0);
        for (Pair<Integer, Integer> p : unreserved) {
            int start = p.getKey();
            int end = p.getValue();
            String ntfString = stf.getStringOfActualValue();
            int length = ntfString.length();
            int index = this.raw.indexOf(ntfString, start);
            if (index == -1 || index > end - length + 1) continue;
            result.setKey(index);
            result.setValue(length);
            this.rawLastIndex = index + length;
            if (!update) break;
            this.reserved.set(result.getKey(), result.getKey() + result.getValue(), true);
            break;
        }
        return result;
    }

    private Pair<Integer, Integer> findNumericValue(ValueTrimFormat ntf, boolean forward, boolean update) {
        ArrayList<Pair<Integer, Integer>> unreserved = this.getUnreservedPositions(forward);
        Pair<Integer, Integer> result = new Pair<Integer, Integer>(-1, 0);
        this.resultNumeric = new Pair<Integer, Integer>(-1, 0);
        for (Pair<Integer, Integer> p : unreserved) {
            int start = p.getKey();
            int end = p.getValue();
            int s = start;
            while (s <= end && result.getKey() == -1) {
                char ch;
                int i;
                String ntfString = ntf.getNString();
                int length = ntfString.length();
                int index = this.numericRaw.indexOf(ntfString, s);
                if (index == -1 || index > end - length + 1) break;
                s = index + 1;
                this.resultNumeric.setValue(length);
                this.resultNumeric.setKey(index);
                int startPos = this.numericPositions.get(index);
                int endPos = this.numericPositions.get(index + length - 1);
                ntfString = this.raw.substring(startPos, endPos + 1);
                Double value = RawRow.tryParse(ntfString);
                if (value == null) continue;
                boolean flagD = false;
                int d = endPos - startPos - length + 1;
                if (d == 1) {
                    for (int i2 = startPos; i2 <= endPos; ++i2) {
                        if (this.raw.charAt(i2) != '.') continue;
                        flagD = true;
                        break;
                    }
                    if (!flagD) continue;
                    ntfString = this.raw.substring(startPos, endPos + 1);
                } else if (d > 1) continue;
                StringBuilder sb = new StringBuilder();
                boolean flagPrefix = true;
                for (i = startPos - 1; i >= 0 && flagPrefix; --i) {
                    ch = this.raw.charAt(i);
                    if (Character.isDigit(ch) && ch != '0') {
                        flagPrefix = false;
                        continue;
                    }
                    if (ch == '0') {
                        sb.append('0');
                        continue;
                    }
                    if (!flagD && ch == '.') {
                        sb.append(ch);
                        flagD = true;
                        continue;
                    }
                    if (ch != '+' && ch != '-') break;
                    sb.append(ch);
                    break;
                }
                if (!flagPrefix) continue;
                sb = sb.reverse();
                startPos -= sb.length();
                sb.append(ntfString);
                for (i = endPos + 1; i < this.raw.length(); ++i) {
                    ch = this.raw.charAt(i);
                    if (ch == 'E' || ch == 'e' || ch == '+' || ch == '-') {
                        sb.append(ch);
                        continue;
                    }
                    if (!flagD && ch == '.') {
                        sb.append(ch);
                        flagD = true;
                        continue;
                    }
                    if (!Character.isDigit(ch)) break;
                    sb.append(ch);
                }
                if ((value = RawRow.tryParse(sb.toString())) == null || value.doubleValue() != ntf.getDoubleActualValue()) continue;
                result.setKey(startPos);
                result.setValue(sb.length());
            }
            if (result.getKey() == -1) continue;
            break;
        }
        if (result.getKey() != -1) {
            if (update) {
                int i;
                for (i = this.resultNumeric.getKey() - 1; i >= 0 && this.numericPositions.get(i) >= result.getKey(); --i) {
                    this.numericReserved.set(i);
                }
                i = this.resultNumeric.getKey() + 1;
                while (i < this.numericPositions.size() && this.numericPositions.get(i) <= result.getKey() + result.getValue()) {
                    this.numericReserved.set(i);
                    this.numericLastIndex = i++;
                }
                this.numericReserved.set(this.resultNumeric.getKey(), this.resultNumeric.getKey() + this.resultNumeric.getValue(), true);
                this.reserved.set(result.getKey(), result.getKey() + result.getValue(), true);
            } else {
                int i = this.resultNumeric.getKey() + 1;
                while (i < this.numericPositions.size() && this.numericPositions.get(i) <= result.getKey() + result.getValue()) {
                    this.numericLastIndex = i++;
                }
            }
            this.numericLastIndex = Math.max(this.numericLastIndex, this.resultNumeric.getKey() + this.resultNumeric.getValue());
            this.rawLastIndex = result.getKey() + result.getValue();
        }
        return result;
    }

    private ArrayList<Pair<Integer, Integer>> getUnreservedPositions(boolean forward) {
        ArrayList<Pair<Integer, Integer>> result = new ArrayList<Pair<Integer, Integer>>();
        int size = this.numericPositions.size();
        int[] start = new int[]{this.numericLastIndex, 0};
        int[] end = new int[]{size, this.numericLastIndex};
        int psize = forward || this.rawLastIndex == 0 ? 1 : 2;
        for (int p = 0; p < psize; ++p) {
            int i = start[p];
            while (i < end[p]) {
                int j;
                for (j = i; j < end[p] && this.numericReserved.get(j); ++j) {
                    ++i;
                }
                int sIndex = i;
                for (j = i; j < end[p] && !this.numericReserved.get(j); ++j) {
                    ++i;
                }
                int eIndex = i;
                if (sIndex >= eIndex) continue;
                result.add(new Pair<Integer, Integer>(sIndex, eIndex - 1));
            }
        }
        return result;
    }

    private ArrayList<Pair<Integer, Integer>> getRawUnreservedPositions(boolean forward) {
        ArrayList<Pair<Integer, Integer>> result = new ArrayList<Pair<Integer, Integer>>();
        int size = this.raw.length();
        int[] start = new int[]{this.rawLastIndex, 0};
        int[] end = new int[]{size, this.rawLastIndex};
        int psize = forward || this.rawLastIndex == 0 ? 1 : 2;
        for (int p = 0; p < psize; ++p) {
            int i = start[p];
            while (i < end[p]) {
                int j;
                for (j = i; j < end[p] && this.reserved.get(j); ++j) {
                    ++i;
                }
                int sIndex = i;
                for (j = i; j < end[p] && !this.reserved.get(j); ++j) {
                    ++i;
                }
                int eIndex = i;
                if (sIndex >= eIndex) continue;
                result.add(new Pair<Integer, Integer>(sIndex, eIndex - 1));
            }
        }
        return result;
    }

    private static Double tryParse(String input) {
        try {
            return Double.parseDouble(input);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Pair<String, String> getDelims() {
        Pair<String, String> result = new Pair<String, String>("", "");
        StringBuilder sbAll = new StringBuilder();
        StringBuilder sbPart = new StringBuilder();
        String minToken = "";
        for (int i = 0; i < this.raw.length(); ++i) {
            if (!this.reserved.get(i)) {
                char ch = this.raw.charAt(i);
                sbAll.append(ch);
                sbPart.append(ch);
                continue;
            }
            if (sbPart.length() == 0) continue;
            if (minToken.length() == 0 || minToken.length() > sbPart.length()) {
                minToken = sbPart.toString();
            }
            sbPart = new StringBuilder();
        }
        result.set(minToken, sbAll.toString());
        return result;
    }

    public void resetReserved() {
        this.reserved.set(0, this.raw.length(), false);
        this.numericReserved.set(0, this.numericPositions.size(), false);
        this.numericLastIndex = 0;
        this.rawLastIndex = 0;
    }

    public Pair<HashSet<String>, Integer> getDelimsSet() {
        Pair<HashSet<String>, Integer> result = new Pair<HashSet<String>, Integer>();
        StringBuilder sb = new StringBuilder();
        int minSize = -1;
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < this.raw.length(); ++i) {
            if (!this.reserved.get(i)) {
                char ch = this.raw.charAt(i);
                sb.append(ch);
                continue;
            }
            if (sb.length() > 0) {
                set.add(sb.toString());
                minSize = minSize == -1 ? sb.length() : Math.min(minSize, sb.length());
            }
            sb = new StringBuilder();
        }
        result.set(set, minSize);
        return result;
    }

    public String getRaw() {
        return this.raw;
    }

    public void setNumericLastIndex(int numericLastIndex) {
        this.numericLastIndex = numericLastIndex;
    }

    public void setRawLastIndex(int rawLastIndex) {
        this.rawLastIndex = rawLastIndex;
    }

    public RawRow getResetClone() {
        RawRow clone = new RawRow(this.raw, this.numericPositions, this.numericRaw);
        clone.setRawLastIndex(0);
        clone.setNumericLastIndex(0);
        return clone;
    }

    public void setLastIndex(int lastIndex) {
        this.numericLastIndex = lastIndex;
    }

    public int getNumericLastIndex() {
        return this.numericLastIndex;
    }

    public int getRawLastIndex() {
        return this.rawLastIndex;
    }

    public boolean isMarked() {
        return !this.reserved.isEmpty();
    }
}

