/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.offset;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffsetIterator;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public abstract class AOffset
implements Serializable {
    private static final long serialVersionUID = 6910025321078561338L;
    protected static final Log LOG = LogFactory.getLog((String)AOffset.class.getName());
    private ThreadLocal<OffsetCache> cacheRow = new ThreadLocal<OffsetCache>(){

        @Override
        protected OffsetCache initialValue() {
            return null;
        }
    };

    public abstract AIterator getIterator();

    public abstract AOffsetIterator getOffsetIterator();

    public AIterator getIterator(int row) {
        if (row <= this.getOffsetToFirst()) {
            return this.getIterator();
        }
        if (row > this.getOffsetToLast()) {
            return null;
        }
        OffsetCache c = this.cacheRow.get();
        if (c != null && c.row == row) {
            return c.it.clone();
        }
        AIterator it = null;
        it = c != null && c.row < row ? c.it.clone() : this.getIterator();
        it.skipTo(row);
        this.cacheIterator(it.clone(), row);
        return it;
    }

    public void cacheIterator(AIterator it, int row) {
        if (it == null) {
            return;
        }
        this.cacheRow.set(new OffsetCache(it, row));
    }

    public abstract void write(DataOutput var1) throws IOException;

    public abstract int getOffsetToFirst();

    public abstract int getOffsetToLast();

    public abstract long getInMemorySize();

    public abstract long getExactSizeOnDisk();

    public abstract int getSize();

    public abstract int getOffsetsLength();

    public final void preAggregateDenseMap(MatrixBlock m, double[] preAV, int rl, int ru, int cl, int cu, int nVal, AMapToData data) {
        AIterator it = this.getIterator(cl);
        if (it == null) {
            return;
        }
        if (it.offset > cu) {
            this.cacheIterator(it, cu);
        } else if (rl == ru - 1) {
            DenseBlock db = m.getDenseBlock();
            double[] mV = db.values(rl);
            int off = db.pos(rl);
            this.preAggregateDenseMapRow(mV, off, preAV, cu, nVal, data, it);
        } else {
            DenseBlock db = m.getDenseBlock();
            this.preAggregateDenseMapRows(db, preAV, rl, ru, cl, cu, nVal, data, it);
        }
    }

    protected final void preAggregateDenseMapRow(double[] mV, int off, double[] preAV, int cu, int nVal, AMapToData data, AIterator it) {
        int last = this.getOffsetToLast();
        if (cu <= last) {
            this.preAggregateDenseMapRowBellowEnd(mV, off, preAV, cu, nVal, data, it);
        } else {
            this.preAggregateDenseMapRowEnd(mV, off, preAV, last, nVal, data, it);
        }
    }

    protected final void preAggregateDenseMapRowBellowEnd(double[] mV, int off, double[] preAV, int cu, int nVal, AMapToData data, AIterator it) {
        it.offset += off;
        cu += off;
        while (it.offset < cu) {
            int n = data.getIndex(it.getDataIndex());
            preAV[n] = preAV[n] + mV[it.offset];
            it.next();
        }
        it.offset -= off;
        this.cacheIterator(it, cu -= off);
    }

    protected final void preAggregateDenseMapRowEnd(double[] mV, int off, double[] preAV, int last, int nVal, AMapToData data, AIterator it) {
        while (it.offset < last) {
            int dx = it.getDataIndex();
            int n = data.getIndex(dx);
            preAV[n] = preAV[n] + mV[off + it.offset];
            it.next();
        }
        int n = data.getIndex(it.getDataIndex());
        preAV[n] = preAV[n] + mV[off + last];
    }

    protected final void preAggregateDenseMapRows(DenseBlock db, double[] preAV, int rl, int ru, int cl, int cu, int nVal, AMapToData data, AIterator it) {
        if (cu <= this.getOffsetToLast()) {
            this.preAggregateDenseMapRowsBelowEnd(db, preAV, rl, ru, cl, cu, nVal, data, it);
        } else {
            this.preAggregateDenseMapRowsEnd(db, preAV, rl, ru, cl, cu, nVal, data, it);
        }
    }

    private void preAggregateDenseMapRowsBelowEnd(DenseBlock db, double[] preAV, int rl, int ru, int cl, int cu, int nVal, AMapToData data, AIterator it) {
        double[] vals = db.values(rl);
        int nCol = db.getCumODims(0);
        while (it.offset < cu) {
            int dataOffset = data.getIndex(it.getDataIndex());
            int start = it.offset + nCol * rl;
            int end = it.offset + nCol * ru;
            int offOut = dataOffset;
            for (int off = start; off < end; off += nCol) {
                int n = offOut;
                preAV[n] = preAV[n] + vals[off];
                offOut += nVal;
            }
            it.next();
        }
        this.cacheIterator(it, cu);
    }

    private void preAggregateDenseMapRowsEnd(DenseBlock db, double[] preAV, int rl, int ru, int cl, int cu, int nVal, AMapToData data, AIterator it) {
        int off;
        double[] vals = db.values(rl);
        int nCol = db.getCumODims(0);
        int last = this.getOffsetToLast();
        int dataOffset = data.getIndex(it.getDataIndex());
        int start = it.offset + nCol * rl;
        int end = it.offset + nCol * ru;
        int offOut = dataOffset;
        for (off = start; off < end; off += nCol) {
            int n = offOut;
            preAV[n] = preAV[n] + vals[off];
            offOut += nVal;
        }
        while (it.offset < last) {
            it.next();
            dataOffset = data.getIndex(it.getDataIndex());
            start = it.offset + nCol * rl;
            end = it.offset + nCol * ru;
            offOut = dataOffset;
            for (off = start; off < end; off += nCol) {
                int n = offOut;
                preAV[n] = preAV[n] + vals[off];
                offOut += nVal;
            }
        }
    }

    public final void preAggregateSparseMap(SparseBlock sb, double[] preAV, int rl, int ru, int nVal, AMapToData data) {
        AIterator it = this.getIterator();
        if (rl == ru - 1) {
            this.preAggregateSparseMapRow(sb, preAV, rl, nVal, data, it);
        } else {
            this.preAggregateSparseMapRows(sb, preAV, rl, ru, nVal, data, it);
        }
    }

    private void preAggregateSparseMapRow(SparseBlock sb, double[] preAV, int r, int nVal, AMapToData data, AIterator it) {
        int last;
        if (sb.isEmpty(r)) {
            return;
        }
        int alen = sb.size(r) + sb.pos(r);
        int[] aix = sb.indexes(r);
        if (aix[alen - 1] < (last = this.getOffsetToLast())) {
            this.preAggregateSparseMapRowBellowEnd(sb, preAV, r, nVal, data, it);
        } else {
            this.preAggregateSparseMapRowEnd(sb, preAV, r, nVal, data, it);
        }
    }

    private final void preAggregateSparseMapRowBellowEnd(SparseBlock sb, double[] preAV, int r, int nVal, AMapToData data, AIterator it) {
        int apos = sb.pos(r);
        int alen = sb.size(r) + apos;
        int[] aix = sb.indexes(r);
        double[] avals = sb.values(r);
        int v = it.value();
        while (apos < alen) {
            if (aix[apos] == v) {
                int n = data.getIndex(it.getDataIndex());
                preAV[n] = preAV[n] + avals[apos++];
                v = it.next();
                continue;
            }
            if (aix[apos] < v) {
                ++apos;
                continue;
            }
            v = it.next();
        }
    }

    private final void preAggregateSparseMapRowEnd(SparseBlock sb, double[] preAV, int r, int nVal, AMapToData data, AIterator it) {
        int apos = sb.pos(r);
        int alen = sb.size(r) + apos;
        int[] aix = sb.indexes(r);
        double[] avals = sb.values(r);
        int last = this.getOffsetToLast();
        int v = it.value();
        while (v < last) {
            if (aix[apos] == v) {
                int n = data.getIndex(it.getDataIndex());
                preAV[n] = preAV[n] + avals[apos++];
                v = it.next();
                continue;
            }
            if (aix[apos] < v) {
                ++apos;
                continue;
            }
            v = it.next();
        }
        while (aix[apos] < last && apos < alen) {
            ++apos;
        }
        if (v == aix[apos]) {
            int n = data.getIndex(it.getDataIndex());
            preAV[n] = preAV[n] + avals[apos];
        }
    }

    private void preAggregateSparseMapRows(SparseBlock sb, double[] preAV, int rl, int ru, int nVal, AMapToData data, AIterator it) {
        int apos;
        int[] aix;
        int alen;
        int off;
        int r;
        int i = it.value();
        int last = this.getOffsetToLast();
        int[] aOffs = new int[ru - rl];
        for (r = rl; r < ru; ++r) {
            aOffs[r - rl] = sb.pos(r);
        }
        while (i < last) {
            for (r = rl; r < ru; ++r) {
                off = r - rl;
                alen = sb.size(r) + sb.pos(r);
                aix = sb.indexes(r);
                for (apos = aOffs[off]; apos < alen && aix[apos] < i; ++apos) {
                }
                if (apos < alen && aix[apos] == i) {
                    int n = off * nVal + data.getIndex(it.getDataIndex());
                    preAV[n] = preAV[n] + sb.values(r)[apos];
                }
                aOffs[off] = apos;
            }
            i = it.next();
        }
        for (r = rl; r < ru; ++r) {
            off = r - rl;
            alen = sb.size(r) + sb.pos(r);
            aix = sb.indexes(r);
            for (apos = aOffs[off]; apos < alen && aix[apos] < last; ++apos) {
            }
            if (apos < alen && aix[apos] == last) {
                int n = off * nVal + data.getIndex(it.getDataIndex());
                preAV[n] = preAV[n] + sb.values(r)[apos];
            }
            aOffs[off] = apos;
        }
    }

    public boolean equals(AOffset b) {
        if (this.getOffsetToLast() == b.getOffsetToLast()) {
            int last = this.getOffsetToLast();
            AOffsetIterator ia = this.getOffsetIterator();
            AOffsetIterator ib = b.getOffsetIterator();
            while (ia.value() < last) {
                if (ia.value() != ib.value()) {
                    return false;
                }
                ia.next();
                ib.next();
                if (ib.value() != last || ia.value() == last) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        AIterator it = this.getIterator();
        int last = this.getOffsetToLast();
        sb.append("[");
        while (it.offset < last) {
            sb.append(it.offset);
            sb.append(", ");
            it.next();
        }
        sb.append(it.offset);
        sb.append("]");
        if (it.offset != last) {
            throw new DMLCompressionException("Invalid iteration of offset when making string, the last offset is not equal to a iteration: " + this.getOffsetToLast() + " String: " + sb.toString());
        }
        return sb.toString();
    }

    protected static class OffsetCache {
        protected final AIterator it;
        protected final int row;

        protected OffsetCache(AIterator it, int row) {
            this.it = it;
            this.row = row;
        }
    }
}

