/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;

public class ColGroupDeltaDDC
extends ColGroupDDC {
    private static final long serialVersionUID = -1045556313148564147L;

    protected ColGroupDeltaDDC(int numRows) {
        super(numRows);
    }

    private ColGroupDeltaDDC(int[] colIndexes, int numRows, ADictionary dict, AMapToData data, int[] cachedCounts) {
        super(numRows);
        LOG.info((Object)"Carefully use of DeltaDDC since implementation is not finished.");
        this._colIndexes = colIndexes;
        this._dict = dict;
        this._zeros = false;
        this._data = data;
    }

    public static AColGroup create(int[] colIndices, int numRows, ADictionary dict, AMapToData data, int[] cachedCounts) {
        if (dict == null) {
            throw new NotImplementedException("Not implemented constant delta group");
        }
        return new ColGroupDeltaDDC(colIndices, numRows, dict, data, cachedCounts);
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.DeltaDDC;
    }

    @Override
    protected void decompressToDenseBlockDenseDictionary(DenseBlock db, int rl, int ru, int offR, int offC, double[] values) {
        int nCol = this._colIndexes.length;
        int i = rl;
        int offT = rl + offR;
        while (i < ru) {
            double[] c = db.values(offT);
            int off = db.pos(offT) + offC;
            int rowIndex = this._data.getIndex(i) * nCol;
            int prevOff = off == 0 ? off : off - nCol;
            for (int j = 0; j < nCol; ++j) {
                double newValue = c[prevOff + j] + values[rowIndex + j];
                int n = off + this._colIndexes[j];
                c[n] = c[n] + newValue;
            }
            ++i;
            ++offT;
        }
    }

    @Override
    protected void decompressToSparseBlockDenseDictionary(SparseBlock ret, int rl, int ru, int offR, int offC, double[] values) {
        throw new NotImplementedException();
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        return new ColGroupDeltaDDC(this._colIndexes, this._numRows, this._dict.applyScalarOp(op), this._data, this.getCachedCounts());
    }
}

