/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.client.http;

import java.nio.channels.AsynchronousCloseException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.spark_project.jetty.client.HttpConnection;
import org.spark_project.jetty.client.HttpDestination;
import org.spark_project.jetty.client.HttpExchange;
import org.spark_project.jetty.client.HttpRequest;
import org.spark_project.jetty.client.api.Connection;
import org.spark_project.jetty.client.api.Request;
import org.spark_project.jetty.client.api.Response;
import org.spark_project.jetty.client.http.HttpChannelOverHTTP;
import org.spark_project.jetty.client.http.HttpDestinationOverHTTP;
import org.spark_project.jetty.io.AbstractConnection;
import org.spark_project.jetty.io.EndPoint;
import org.spark_project.jetty.util.Promise;
import org.spark_project.jetty.util.log.Log;
import org.spark_project.jetty.util.log.Logger;
import org.spark_project.jetty.util.thread.Sweeper;

public class HttpConnectionOverHTTP
extends AbstractConnection
implements Connection,
Sweeper.Sweepable {
    private static final Logger LOG = Log.getLogger(HttpConnectionOverHTTP.class);
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicInteger sweeps = new AtomicInteger();
    private final Promise<Connection> promise;
    private final Delegate delegate;
    private final HttpChannelOverHTTP channel;
    private long idleTimeout;

    @Deprecated
    public HttpConnectionOverHTTP(EndPoint endPoint, HttpDestination destination) {
        this(endPoint, destination, new Promise.Adapter<Connection>());
        throw new UnsupportedOperationException("Deprecated, use HttpConnectionOverHTTP(EndPoint, HttpDestination, Promise<Connection>) instead");
    }

    public HttpConnectionOverHTTP(EndPoint endPoint, HttpDestination destination, Promise<Connection> promise) {
        super(endPoint, destination.getHttpClient().getExecutor(), destination.getHttpClient().isDispatchIO());
        this.promise = promise;
        this.delegate = new Delegate(destination);
        this.channel = this.newHttpChannel();
    }

    protected HttpChannelOverHTTP newHttpChannel() {
        return new HttpChannelOverHTTP(this);
    }

    public HttpChannelOverHTTP getHttpChannel() {
        return this.channel;
    }

    public HttpDestinationOverHTTP getHttpDestination() {
        return (HttpDestinationOverHTTP)this.delegate.getHttpDestination();
    }

    @Override
    public void send(Request request, Response.CompleteListener listener) {
        this.delegate.send(request, listener);
    }

    protected void send(HttpExchange exchange) {
        this.delegate.send(exchange);
    }

    @Override
    public void onOpen() {
        super.onOpen();
        this.fillInterested();
        this.promise.succeeded(this);
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    protected boolean onReadTimeout() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} idle timeout", this);
        }
        this.close(new TimeoutException());
        return false;
    }

    @Override
    public void onFillable() {
        HttpExchange exchange = this.channel.getHttpExchange();
        if (exchange != null) {
            this.channel.receive();
        } else {
            this.close();
        }
    }

    public void release() {
        this.getEndPoint().setIdleTimeout(this.idleTimeout);
        this.getHttpDestination().release(this);
    }

    @Override
    public void close() {
        this.close(new AsynchronousCloseException());
    }

    protected void close(Throwable failure) {
        if (this.softClose()) {
            this.getHttpDestination().close(this);
            this.getEndPoint().shutdownOutput();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} oshut", this);
            }
            this.getEndPoint().close();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} closed", this);
            }
            this.abort(failure);
        }
    }

    public boolean softClose() {
        return this.closed.compareAndSet(false, true);
    }

    protected boolean abort(Throwable failure) {
        HttpExchange exchange = this.channel.getHttpExchange();
        return exchange != null && exchange.getRequest().abort(failure);
    }

    @Override
    public boolean sweep() {
        if (!this.closed.get()) {
            return false;
        }
        return this.sweeps.incrementAndGet() >= 4;
    }

    @Override
    public String toString() {
        return String.format("%s@%h(l:%s <-> r:%s,closed=%b)[%s]", this.getClass().getSimpleName(), this, this.getEndPoint().getLocalAddress(), this.getEndPoint().getRemoteAddress(), this.closed.get(), this.channel);
    }

    private class Delegate
    extends HttpConnection {
        private Delegate(HttpDestination destination) {
            super(destination);
        }

        @Override
        protected void send(HttpExchange exchange) {
            HttpRequest request = exchange.getRequest();
            this.normalizeRequest(request);
            EndPoint endPoint = HttpConnectionOverHTTP.this.getEndPoint();
            HttpConnectionOverHTTP.this.idleTimeout = endPoint.getIdleTimeout();
            endPoint.setIdleTimeout(request.getIdleTimeout());
            if (HttpConnectionOverHTTP.this.channel.associate(exchange)) {
                HttpConnectionOverHTTP.this.channel.send();
            } else {
                HttpConnectionOverHTTP.this.channel.release();
            }
        }

        @Override
        public void close() {
            HttpConnectionOverHTTP.this.close();
        }

        @Override
        public String toString() {
            return HttpConnectionOverHTTP.this.toString();
        }
    }
}

