/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.spark.SPInstruction;
import org.apache.sysds.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.utils.FrameRDDConverterUtils;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.util.UtilFunctions;

public class CastSPInstruction
extends UnarySPInstruction {
    private CastSPInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String istr) {
        super(SPInstruction.SPType.Cast, op, in, out, opcode, istr);
    }

    public static CastSPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 2);
        String opcode = parts[0];
        CPOperand in = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        return new CastSPInstruction(null, in, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        String opcode = this.getOpcode();
        JavaPairRDD<?, ?> in = sec.getRDDHandleForVariable(this.input1.getName(), Types.FileFormat.BINARY, -1, true);
        DataCharacteristics mcIn = sec.getDataCharacteristics(this.input1.getName());
        Object out = null;
        if (opcode.equals("castdtm")) {
            MatrixCharacteristics mcOut = new MatrixCharacteristics(mcIn);
            mcOut.setBlocksize(ConfigurationManager.getBlocksize());
            out = FrameRDDConverterUtils.binaryBlockToMatrixBlock(in, mcIn, mcOut);
        } else if (opcode.equals("castdtf")) {
            out = FrameRDDConverterUtils.matrixBlockToBinaryBlockLongIndex(sec.getSparkContext(), in, mcIn);
        } else {
            throw new DMLRuntimeException("Unsupported spark cast operation: " + opcode);
        }
        sec.setRDDHandleForVariable(this.output.getName(), (JavaPairRDD<?, ?>)out);
        this.updateUnaryOutputDataCharacteristics(sec, this.input1.getName(), this.output.getName());
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
        if (opcode.equals("castdtf")) {
            sec.getFrameObject(this.output.getName()).setSchema(UtilFunctions.nCopies((int)mcIn.getCols(), Types.ValueType.FP64));
        }
    }
}

