/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.client;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.spark_project.jetty.client.Origin;
import org.spark_project.jetty.io.ClientConnectionFactory;

public class ProxyConfiguration {
    private final List<Proxy> proxies = new ArrayList<Proxy>();

    public List<Proxy> getProxies() {
        return this.proxies;
    }

    public Proxy match(Origin origin) {
        for (Proxy proxy : this.getProxies()) {
            if (!proxy.matches(origin)) continue;
            return proxy;
        }
        return null;
    }

    public static abstract class Proxy {
        private final Set<String> included = new HashSet<String>();
        private final Set<String> excluded = new HashSet<String>();
        private final Origin.Address address;
        private final boolean secure;

        protected Proxy(Origin.Address address, boolean secure) {
            this.address = address;
            this.secure = secure;
        }

        public Origin.Address getAddress() {
            return this.address;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public Set<String> getIncludedAddresses() {
            return this.included;
        }

        public Set<String> getExcludedAddresses() {
            return this.excluded;
        }

        public URI getURI() {
            return null;
        }

        public boolean matches(Origin origin) {
            boolean result2 = this.included.isEmpty();
            Origin.Address address = origin.getAddress();
            for (String included : this.included) {
                if (!this.matches(address, included)) continue;
                result2 = true;
                break;
            }
            for (String excluded : this.excluded) {
                if (!this.matches(address, excluded)) continue;
                result2 = false;
                break;
            }
            return result2;
        }

        private boolean matches(Origin.Address address, String pattern) {
            int colon2 = pattern.indexOf(58);
            if (colon2 < 0) {
                return pattern.equals(address.getHost());
            }
            String host = pattern.substring(0, colon2);
            String port = pattern.substring(colon2 + 1);
            return host.equals(address.getHost()) && port.equals(String.valueOf(address.getPort()));
        }

        public abstract ClientConnectionFactory newClientConnectionFactory(ClientConnectionFactory var1);

        public String toString() {
            return this.address.toString();
        }
    }
}

