/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.spark.storage.StorageUtils$;
import org.apache.spark.util.ByteBufferInputStream$;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001=4Q!\u0001\u0002\u0001\t)\u0011QCQ=uK\n+hMZ3s\u0013:\u0004X\u000f^*ue\u0016\fWN\u0003\u0002\u0004\t\u0005!Q\u000f^5m\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7C\u0001\u0001\f!\ta\u0011#D\u0001\u000e\u0015\tqq\"\u0001\u0002j_*\t\u0001#\u0001\u0003kCZ\f\u0017B\u0001\n\u000e\u0005-Ie\u000e];u'R\u0014X-Y7\t\u0011Q\u0001!\u00111A\u0005\nY\taAY;gM\u0016\u00148\u0001A\u000b\u0002/A\u0011\u0001dG\u0007\u00023)\u0011!dD\u0001\u0004]&|\u0017B\u0001\u000f\u001a\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\t=\u0001\u0011\t\u0019!C\u0005?\u0005Q!-\u001e4gKJ|F%Z9\u0015\u0005\u00012\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#\u0001B+oSRDqaJ\u000f\u0002\u0002\u0003\u0007q#A\u0002yIEB\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006KaF\u0001\bEV4g-\u001a:!\u0011!Y\u0003A!A!\u0002\u0013a\u0013a\u00023jgB|7/\u001a\t\u0003C5J!A\f\u0012\u0003\u000f\t{w\u000e\\3b]\")\u0001\u0007\u0001C\u0001c\u00051A(\u001b8jiz\"2A\r\u001b6!\t\u0019\u0004!D\u0001\u0003\u0011\u0015!r\u00061\u0001\u0018\u0011\u001dYs\u0006%AA\u00021BQa\u000e\u0001\u0005Ba\nAA]3bIR\t\u0011\b\u0005\u0002\"u%\u00111H\t\u0002\u0004\u0013:$\b\"B\u001c\u0001\t\u0003jDCA\u001d?\u0011\u0015yD\b1\u0001A\u0003\u0011!Wm\u001d;\u0011\u0007\u0005\n5)\u0003\u0002CE\t)\u0011I\u001d:bsB\u0011\u0011\u0005R\u0005\u0003\u000b\n\u0012AAQ=uK\")q\u0007\u0001C!\u000fR!\u0011\bS%L\u0011\u0015yd\t1\u0001A\u0011\u0015Qe\t1\u0001:\u0003\u0019ygMZ:fi\")AJ\u0012a\u0001s\u00051A.\u001a8hi\"DQA\u0014\u0001\u0005B=\u000bAa]6jaR\u0011\u0001k\u0015\t\u0003CEK!A\u0015\u0012\u0003\t1{gn\u001a\u0005\u0006)6\u0003\r\u0001U\u0001\u0006Ef$Xm\u001d\u0005\u0006-\u0002!IaV\u0001\bG2,\u0017M\\+q)\u0005\u0001s\u0001C-\u0003\u0003\u0003E\t\u0001\u0002.\u0002+\tKH/\u001a\"vM\u001a,'/\u00138qkR\u001cFO]3b[B\u00111g\u0017\u0004\t\u0003\t\t\t\u0011#\u0001\u00059N\u00111,\u0018\t\u0003CyK!a\u0018\u0012\u0003\r\u0005s\u0017PU3g\u0011\u0015\u00014\f\"\u0001b)\u0005Q\u0006bB2\\#\u0003%\t\u0001Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003\u0015T#\u0001\f4,\u0003\u001d\u0004\"\u0001[7\u000e\u0003%T!A[6\u0002\u0013Ut7\r[3dW\u0016$'B\u00017#\u0003)\tgN\\8uCRLwN\\\u0005\u0003]&\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer buffer;
    private final boolean dispose;

    public static boolean $lessinit$greater$default$2() {
        return ByteBufferInputStream$.MODULE$.$lessinit$greater$default$2();
    }

    private ByteBuffer buffer() {
        return this.buffer;
    }

    private void buffer_$eq(ByteBuffer x$1) {
        this.buffer = x$1;
    }

    @Override
    public int read() {
        int n;
        if (this.buffer() == null || this.buffer().remaining() == 0) {
            this.cleanUp();
            n = -1;
        } else {
            n = this.buffer().get() & 0xFF;
        }
        return n;
    }

    @Override
    public int read(byte[] dest) {
        return this.read(dest, 0, dest.length);
    }

    @Override
    public int read(byte[] dest, int offset, int length) {
        int n;
        if (this.buffer() == null || this.buffer().remaining() == 0) {
            this.cleanUp();
            n = -1;
        } else {
            int amountToGet = package$.MODULE$.min(this.buffer().remaining(), length);
            this.buffer().get(dest, offset, amountToGet);
            n = amountToGet;
        }
        return n;
    }

    @Override
    public long skip(long bytes) {
        long l;
        if (this.buffer() == null) {
            l = 0L;
        } else {
            int amountToSkip = (int)package$.MODULE$.min(bytes, (long)this.buffer().remaining());
            this.buffer().position(this.buffer().position() + amountToSkip);
            if (this.buffer().remaining() == 0) {
                this.cleanUp();
            }
            l = amountToSkip;
        }
        return l;
    }

    private void cleanUp() {
        if (this.buffer() != null) {
            if (this.dispose) {
                StorageUtils$.MODULE$.dispose(this.buffer());
            }
            this.buffer_$eq(null);
        }
    }

    public ByteBufferInputStream(ByteBuffer buffer, boolean dispose2) {
        this.buffer = buffer;
        this.dispose = dispose2;
    }
}

