/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import java.util.HashMap;
import java.util.Map;
import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.LopProperties;
import org.apache.sysds.lops.LopsException;

public class ParameterizedBuiltin
extends Lop {
    private Types.ParamBuiltinOp _operation;
    private HashMap<String, Lop> _inputParams;
    private boolean _bRmEmptyBC;
    private int _numThreads = 1;

    public ParameterizedBuiltin(HashMap<String, Lop> paramLops, Types.ParamBuiltinOp op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et) {
        this(paramLops, op, dt, vt, et, 1);
    }

    public ParameterizedBuiltin(HashMap<String, Lop> paramLops, Types.ParamBuiltinOp op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et, int k) {
        super(Lop.Type.ParameterizedBuiltin, dt, vt);
        this._operation = op;
        for (Lop lop : paramLops.values()) {
            this.addInput(lop);
            lop.addOutput(this);
        }
        this._inputParams = paramLops;
        this._numThreads = k;
        this.lps.setProperties(this.inputs, et);
    }

    public ParameterizedBuiltin(HashMap<String, Lop> paramLops, Types.ParamBuiltinOp op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et, boolean bRmEmptyBC) {
        this(paramLops, op, dt, vt, et);
        this._bRmEmptyBC = bRmEmptyBC;
    }

    public Types.ParamBuiltinOp getOp() {
        return this._operation;
    }

    public int getInputIndex(String name) {
        Lop n = this._inputParams.get(name);
        for (int i = 0; i < this.getInputs().size(); ++i) {
            if (this.getInputs().get(i) != n) continue;
            return i;
        }
        return -1;
    }

    public Lop getNamedInput(String name) {
        return this._inputParams.get(name);
    }

    @Override
    public String getInstructions(String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        switch (this._operation) {
            case CDF: 
            case INVCDF: {
                sb.append(this._operation == Types.ParamBuiltinOp.CDF ? "cdf" : "invcdf");
                sb.append("\u00b0");
                for (String s : this._inputParams.keySet()) {
                    sb.append(s);
                    sb.append("=");
                    Lop iLop = this._inputParams.get(s);
                    sb.append(iLop.prepScalarLabel());
                    sb.append("\u00b0");
                }
                break;
            }
            case RMEMPTY: {
                sb.append("rmempty");
                sb.append("\u00b0");
                for (String s : this._inputParams.keySet()) {
                    sb.append(s);
                    sb.append("=");
                    Lop iLop = this._inputParams.get(s);
                    if (s.equals("target") || s.equals("select") || this.getExecType() == LopProperties.ExecType.SPARK) {
                        sb.append(iLop.getOutputParameters().getLabel());
                    } else {
                        sb.append(iLop.prepScalarLabel());
                    }
                    sb.append("\u00b0");
                }
                break;
            }
            case REPLACE: {
                sb.append("replace");
                sb.append("\u00b0");
                sb.append(ParameterizedBuiltin.compileGenericParamMap(this._inputParams));
                break;
            }
            case LOWER_TRI: {
                sb.append("lowertri");
                sb.append("\u00b0");
                sb.append(ParameterizedBuiltin.compileGenericParamMap(this._inputParams));
                break;
            }
            case UPPER_TRI: {
                sb.append("uppertri");
                sb.append("\u00b0");
                sb.append(ParameterizedBuiltin.compileGenericParamMap(this._inputParams));
                break;
            }
            case REXPAND: {
                sb.append("rexpand");
                sb.append("\u00b0");
                for (String s : this._inputParams.keySet()) {
                    sb.append(s);
                    sb.append("=");
                    Lop iLop = this._inputParams.get(s);
                    if (s.equals("target") || this.getExecType() == LopProperties.ExecType.SPARK) {
                        sb.append(iLop.getOutputParameters().getLabel());
                    } else {
                        sb.append(iLop.prepScalarLabel());
                    }
                    sb.append("\u00b0");
                }
                break;
            }
            case TRANSFORMAPPLY: 
            case TRANSFORMDECODE: 
            case TRANSFORMCOLMAP: 
            case TRANSFORMMETA: {
                sb.append(this._operation.name().toLowerCase());
                sb.append("\u00b0");
                sb.append(ParameterizedBuiltin.compileGenericParamMap(this._inputParams));
                break;
            }
            case LIST: {
                sb.append("nvlist");
                sb.append("\u00b0");
                sb.append(ParameterizedBuiltin.compileGenericParamMap(this._inputParams));
                break;
            }
            case TOSTRING: {
                sb.append("toString");
                sb.append("\u00b0");
                sb.append(ParameterizedBuiltin.compileGenericParamMap(this._inputParams));
                break;
            }
            case PARAMSERV: {
                sb.append("paramserv");
                sb.append("\u00b0");
                sb.append(ParameterizedBuiltin.compileGenericParamMap(this._inputParams));
                break;
            }
            default: {
                throw new LopsException(this.printErrorLocation() + "In ParameterizedBuiltin Lop, Unknown operation: " + (Object)((Object)this._operation));
            }
        }
        if (this._operation == Types.ParamBuiltinOp.RMEMPTY) {
            sb.append("bRmEmptyBC");
            sb.append("=");
            sb.append(this._bRmEmptyBC);
            sb.append("\u00b0");
        }
        if (this.getExecType() == LopProperties.ExecType.CP && this._operation == Types.ParamBuiltinOp.REXPAND) {
            sb.append("k");
            sb.append("=");
            sb.append(this._numThreads);
            sb.append("\u00b0");
        }
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._operation.toString());
        if (!this.getInputs().isEmpty()) {
            sb.append("(");
        }
        for (Lop cur : this.getInputs()) {
            sb.append(cur.toString());
        }
        if (!this.getInputs().isEmpty()) {
            sb.append(") ");
        }
        sb.append(" ; num_rows=" + this.getOutputParameters().getNumRows());
        sb.append(" ; num_cols=" + this.getOutputParameters().getNumCols());
        sb.append(" ; format=" + (Object)((Object)this.getOutputParameters().getFormat()));
        sb.append(" ; blocked=" + this.getOutputParameters().isBlocked());
        return sb.toString();
    }

    private static String compileGenericParamMap(HashMap<String, Lop> params) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Lop> e : params.entrySet()) {
            sb.append(e.getKey());
            sb.append("=");
            if (e.getValue().getDataType() != Types.DataType.SCALAR) {
                sb.append(e.getValue().getOutputParameters().getLabel());
            } else {
                sb.append(e.getValue().prepScalarLabel());
            }
            sb.append("\u00b0");
        }
        return sb.toString();
    }
}

