/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops;

import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.MemoTable;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.Nary;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;

public class NaryOp
extends Hop {
    protected Hop.OpOpN _op = null;

    protected NaryOp() {
    }

    public NaryOp(String name, Expression.DataType dataType, Expression.ValueType valueType, Hop.OpOpN op, Hop ... inputs) {
        super(name, dataType, valueType);
        this._op = op;
        for (int i = 0; i < inputs.length; ++i) {
            this.getInput().add(i, inputs[i]);
            inputs[i].getParent().add(this);
        }
        this.refreshSizeInformation();
    }

    @Override
    public void checkArity() {
    }

    public Hop.OpOpN getOp() {
        return this._op;
    }

    @Override
    public String getOpString() {
        return "m(" + this._op.name().toLowerCase() + ")";
    }

    @Override
    public boolean isGPUEnabled() {
        return false;
    }

    @Override
    public Lop constructLops() {
        if (this.getLops() != null) {
            return this.getLops();
        }
        try {
            Lop[] inLops = new Lop[this.getInput().size()];
            for (int i = 0; i < this.getInput().size(); ++i) {
                inLops[i] = this.getInput().get(i).constructLops();
            }
            Nary.OperationType opType = (Nary.OperationType)((Object)HopsOpOpNLops.get((Object)this._op));
            if (opType == null) {
                throw new HopsException("Unknown Nary Lop type for '" + (Object)((Object)this._op) + "'");
            }
            LopProperties.ExecType et = this.optFindExecType();
            Nary multipleCPLop = new Nary(opType, this.getDataType(), this.getValueType(), inLops, et);
            this.setOutputDimensions(multipleCPLop);
            this.setLineNumbers(multipleCPLop);
            this.setLops(multipleCPLop);
        }
        catch (Exception e) {
            throw new HopsException(this.printErrorLocation() + "error constructing Lops for NaryOp -- \n ", e);
        }
        this.constructAndSetLopsDataFlowProperties();
        return this.getLops();
    }

    @Override
    public boolean allowsAllExecTypes() {
        return false;
    }

    @Override
    public void computeMemEstimate(MemoTable memo) {
        super.computeMemEstimate(memo);
        if (this._op == Hop.OpOpN.EVAL) {
            this._memEstimate = 4.0;
            this._outputMemEstimate = 4.0;
            this._processingMemEstimate = 0.0;
        }
    }

    @Override
    protected double computeOutputMemEstimate(long dim1, long dim2, long nnz) {
        double sparsity = OptimizerUtils.getSparsity(dim1, dim2, nnz);
        return OptimizerUtils.estimateSizeExactSparsity(dim1, dim2, sparsity);
    }

    @Override
    protected LopProperties.ExecType optFindExecType() {
        LopProperties.ExecType REMOTE;
        this.checkAndSetForcedPlatform();
        LopProperties.ExecType execType = REMOTE = OptimizerUtils.isSparkExecutionMode() ? LopProperties.ExecType.SPARK : LopProperties.ExecType.MR;
        if (this._etypeForced != null) {
            this._etype = this._etypeForced;
        } else {
            this._etype = OptimizerUtils.isMemoryBasedOptLevel() ? this.findExecTypeByMemEstimate() : (this.areDimsBelowThreshold() ? LopProperties.ExecType.CP : REMOTE);
            this.checkAndSetInvalidCPDimsAndSize();
        }
        this.setRequiresRecompileIfNecessary();
        if (this._op == Hop.OpOpN.PRINTF || this._op == Hop.OpOpN.EVAL || this._op == Hop.OpOpN.LIST) {
            this._etype = LopProperties.ExecType.CP;
        }
        return this._etype;
    }

    @Override
    protected double computeIntermediateMemEstimate(long dim1, long dim2, long nnz) {
        return 0.0;
    }

    @Override
    protected long[] inferOutputCharacteristics(MemoTable memo) {
        if (!this.getDataType().isScalar()) {
            MatrixCharacteristics[] mc = memo.getAllInputStats(this.getInput());
            switch (this._op) {
                case CBIND: {
                    return new long[]{HopRewriteUtils.getMaxInputDim(mc, true), HopRewriteUtils.getSumValidInputDims(mc, false), HopRewriteUtils.getSumValidInputNnz(mc, true)};
                }
                case RBIND: {
                    return new long[]{HopRewriteUtils.getSumValidInputDims(mc, true), HopRewriteUtils.getMaxInputDim(mc, false), HopRewriteUtils.getSumValidInputNnz(mc, true)};
                }
                case MIN: 
                case MAX: {
                    return new long[]{HopRewriteUtils.getMaxInputDim(this, true), HopRewriteUtils.getMaxInputDim(this, false), -1L};
                }
                case LIST: {
                    return new long[]{this.getInput().size(), 1L, -1L};
                }
            }
        }
        return null;
    }

    @Override
    public void refreshSizeInformation() {
        switch (this._op) {
            case CBIND: {
                this.setDim1(HopRewriteUtils.getMaxInputDim(this, true));
                this.setDim2(HopRewriteUtils.getSumValidInputDims(this, false));
                this.setNnz(HopRewriteUtils.getSumValidInputNnz(this));
                break;
            }
            case RBIND: {
                this.setDim1(HopRewriteUtils.getSumValidInputDims(this, true));
                this.setDim2(HopRewriteUtils.getMaxInputDim(this, false));
                this.setNnz(HopRewriteUtils.getSumValidInputNnz(this));
                break;
            }
            case MIN: 
            case MAX: {
                this.setDim1(this.getDataType().isScalar() ? 0L : HopRewriteUtils.getMaxInputDim(this, true));
                this.setDim2(this.getDataType().isScalar() ? 0L : HopRewriteUtils.getMaxInputDim(this, false));
                break;
            }
            case LIST: {
                this.setDim1(this.getInput().size());
                this.setDim2(1L);
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        NaryOp multipleOp = new NaryOp();
        multipleOp.clone(this, false);
        multipleOp._op = this._op;
        return multipleOp;
    }

    @Override
    public boolean compare(Hop that) {
        if (!(that instanceof NaryOp) || this._op == Hop.OpOpN.PRINTF) {
            return false;
        }
        NaryOp that2 = (NaryOp)that;
        boolean ret = this._op == that2._op && this.getInput().size() == that2.getInput().size();
        for (int i = 0; i < this.getInput().size() && ret; ret &= this.getInput().get(i) == that2.getInput().get(i), ++i) {
        }
        return ret;
    }
}

