/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor.opt;

import org.apache.sysml.api.DMLScript;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.LeftIndexingOp;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.parfor.opt.CostEstimator;
import org.apache.sysml.runtime.controlprogram.parfor.opt.OptNode;
import org.apache.sysml.runtime.controlprogram.parfor.opt.OptTreePlanMappingAbstract;
import org.apache.sysml.runtime.controlprogram.parfor.opt.Optimizer;
import org.apache.sysml.runtime.controlprogram.parfor.opt.OptimizerRuleBased;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;

public class CostEstimatorHops
extends CostEstimator {
    public static final double DEFAULT_MEM_SP = 2.097152E7;
    public static final double DEFAULT_MEM_MR = 2.097152E7 + (double)(InfrastructureAnalyzer.isLocalMode() ? InfrastructureAnalyzer.getRemoteMaxMemorySortBuffer() : 0L);
    private OptTreePlanMappingAbstract _map = null;

    public CostEstimatorHops(OptTreePlanMappingAbstract map) {
        this._map = map;
    }

    @Override
    public double getLeafNodeEstimate(CostEstimator.TestMeasure measure, OptNode node) {
        double DEFAULT_MEM_REMOTE;
        if (node.getNodeType() != OptNode.NodeType.HOP) {
            return 0.0;
        }
        if (measure != CostEstimator.TestMeasure.MEMORY_USAGE) {
            throw new DMLRuntimeException("Testmeasure " + (Object)((Object)measure) + " not supported by cost model " + (Object)((Object)Optimizer.CostModelType.STATIC_MEM_METRIC) + ".");
        }
        Hop h = this._map.getMappedHop(node.getID());
        double value = h.getMemEstimate();
        value = this._exclVars != null && this._exclType == CostEstimator.ExcludeType.SHARED_READ ? h.getInputOutputSize(this._exclVars) : value;
        double d = DEFAULT_MEM_REMOTE = OptimizerUtils.isSparkExecutionMode() ? 2.097152E7 : DEFAULT_MEM_MR;
        if (value >= DEFAULT_MEM_REMOTE) {
            if (h.getExecType() == LopProperties.ExecType.MR) {
                value = DEFAULT_MEM_REMOTE;
            } else if (h.getExecType() == LopProperties.ExecType.SPARK) {
                value = DEFAULT_MEM_REMOTE + h.getSpBroadcastSize();
            } else if (h.getExecType() == LopProperties.ExecType.CP && value >= OptimizerUtils.getLocalMemBudget()) {
                if (DMLScript.rtplatform != DMLScript.RUNTIME_PLATFORM.SINGLE_NODE && h.getForcedExecType() == null) {
                    LOG.warn((Object)("Memory estimate larger than budget but CP exec type (op=" + h.getOpString() + ", name=" + h.getName() + ", memest=" + h.getMemEstimate() + ")."));
                }
                value = DEFAULT_MEM_REMOTE;
            } else if (h.getExecType() == null) {
                value = DEFAULT_MEM_REMOTE;
            }
        }
        if (h.getForcedExecType() == LopProperties.ExecType.MR || h.getForcedExecType() == LopProperties.ExecType.SPARK) {
            value = DEFAULT_MEM_REMOTE;
        }
        if (value <= 0.0) {
            LOG.warn((Object)("Cannot get memory estimate for hop (op=" + h.getOpString() + ", name=" + h.getName() + ", memest=" + h.getMemEstimate() + ")."));
            value = 1024.0;
        }
        double d2 = value = this._exclVars != null && this._exclType == CostEstimator.ExcludeType.RESULT_LIX && h instanceof LeftIndexingOp && this._exclVars.contains(h.getName()) ? 0.0 : value;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Memory estimate " + h.getName() + ", " + h.getOpString() + "(" + (Object)((Object)node.getExecType()) + ")=" + OptimizerRuleBased.toMB(value)));
        }
        return value;
    }

    @Override
    public double getLeafNodeEstimate(CostEstimator.TestMeasure measure, OptNode node, LopProperties.ExecType et) {
        if (node.getNodeType() != OptNode.NodeType.HOP) {
            return 0.0;
        }
        if (measure != CostEstimator.TestMeasure.MEMORY_USAGE) {
            throw new DMLRuntimeException("Testmeasure " + (Object)((Object)measure) + " not supported by cost model " + (Object)((Object)Optimizer.CostModelType.STATIC_MEM_METRIC) + ".");
        }
        Hop h = this._map.getMappedHop(node.getID());
        double value = h.getMemEstimate();
        if (et != LopProperties.ExecType.CP) {
            value = DEFAULT_MEM_MR;
        }
        if (value <= 0.0) {
            value = 1024.0;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Memory estimate (forced exec type) " + h.getName() + ", " + h.getOpString() + "(" + (Object)((Object)node.getExecType()) + ")=" + OptimizerRuleBased.toMB(value)));
        }
        return value;
    }
}

