/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Binary;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class BinaryM
extends Lop {
    private Binary.OperationTypes _operation;
    private CacheType _cacheType = null;
    private VectorType _vectorType = null;

    public BinaryM(Lop input1, Lop input2, Binary.OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et, boolean partitioned, boolean colVector) {
        super(Lop.Type.Binary, dt, vt);
        this._operation = op;
        this._cacheType = partitioned ? CacheType.RIGHT_PART : CacheType.RIGHT;
        this._vectorType = colVector ? VectorType.COL_VECTOR : VectorType.ROW_VECTOR;
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = false;
        if (et == LopProperties.ExecType.MR) {
            this.lps.addCompatibility(JobType.GMR);
            this.lps.setProperties(this.inputs, LopProperties.ExecType.MR, LopProperties.ExecLocation.Map, breaksAlignment, aligner, definesMRJob);
        } else if (et == LopProperties.ExecType.SPARK) {
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, LopProperties.ExecType.SPARK, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        } else {
            throw new LopsException("Incorrect execution type for BinaryM lop:" + et.name());
        }
    }

    @Override
    public String toString() {
        return " Operation: " + (Object)((Object)this._operation);
    }

    public Binary.OperationTypes getOperationType() {
        return this._operation;
    }

    private String getOpcode() {
        return BinaryM.getOpcode(this._operation);
    }

    public static String getOpcode(Binary.OperationTypes op) {
        switch (op) {
            case ADD: {
                return "map+";
            }
            case SUBTRACT: {
                return "map-";
            }
            case MULTIPLY: {
                return "map*";
            }
            case DIVIDE: {
                return "map/";
            }
            case MODULUS: {
                return "map%%";
            }
            case INTDIV: {
                return "map%/%";
            }
            case MINUS1_MULTIPLY: {
                return "map1-*";
            }
            case LESS_THAN: {
                return "map<";
            }
            case LESS_THAN_OR_EQUALS: {
                return "map<=";
            }
            case GREATER_THAN: {
                return "map>";
            }
            case GREATER_THAN_OR_EQUALS: {
                return "map>=";
            }
            case EQUALS: {
                return "map==";
            }
            case NOT_EQUALS: {
                return "map!=";
            }
            case AND: {
                return "map&&";
            }
            case OR: {
                return "map||";
            }
            case MIN: {
                return "mapmin";
            }
            case MAX: {
                return "mapmax";
            }
            case POW: {
                return "map^";
            }
        }
        throw new UnsupportedOperationException("Instruction is not defined for Binary operation: " + (Object)((Object)op));
    }

    public static boolean isOpcode(String opcode) {
        return opcode.equals("map+") || opcode.equals("map-") || opcode.equals("map*") || opcode.equals("map/") || opcode.equals("map%%") || opcode.equals("map%/%") || opcode.equals("map<") || opcode.equals("map<=") || opcode.equals("map>") || opcode.equals("map>=") || opcode.equals("map==") || opcode.equals("map!=") || opcode.equals("map&&") || opcode.equals("map||") || opcode.equals("mapmin") || opcode.equals("mapmax") || opcode.equals("map^") || opcode.equals("map1-*");
    }

    @Override
    public String getInstructions(int input_index1, int input_index2, int output_index) {
        return this.getInstructions(String.valueOf(input_index1), String.valueOf(input_index2), String.valueOf(output_index));
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpcode());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input2));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        sb.append("\u00b0");
        sb.append((Object)this._cacheType);
        sb.append("\u00b0");
        sb.append((Object)this._vectorType);
        return sb.toString();
    }

    @Override
    public boolean usesDistributedCache() {
        return true;
    }

    @Override
    public int[] distributedCacheInputIndex() {
        return new int[]{2};
    }

    public static enum VectorType {
        COL_VECTOR,
        ROW_VECTOR;

    }

    public static enum CacheType {
        RIGHT,
        RIGHT_PART;

    }
}

