/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ad;

import java.util.ArrayList;
import java.util.List;
import net.tirasa.connid.bundles.ad.ADConnection;
import net.tirasa.connid.bundles.ad.search.ADDefaultSearchStrategy;
import net.tirasa.connid.bundles.ad.sync.ADSyncStrategy;
import net.tirasa.connid.bundles.ad.util.ADUtilities;
import net.tirasa.connid.bundles.ldap.LdapConfiguration;
import net.tirasa.connid.bundles.ldap.search.DefaultSearchStrategy;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.spi.ConfigurationProperty;

public final class ADConfiguration
extends LdapConfiguration {
    private final Log LOG = Log.getLog(ADConfiguration.class);
    private boolean retrieveDeletedUser = true;
    private boolean retrieveDeletedGroup = true;
    private boolean retrieveDeletedAnyObject = true;
    public static final String PROMPT_USER_FLAG = "pwdLastSet";
    public static final String PROMPT_USER_VALUE = "0";
    public static final String NOT_PROMPT_USER_VALUE = "-1";
    public static final String LOCK_OUT_FLAG = "lockoutTime";
    public static final String LOCK_OUT_DEFAULT_VALUE = "0";
    public static final String UCCP_FLAG = "userCannotChangePassword";
    public static final String PNE_FLAG = "passwordNeverExpires";
    public static final String PNR_FLAG = "passwordNotRequired";
    public static final String CN_NAME = "CN";
    public static final String PRIMARY_GROUP_DN_NAME = "primaryGroupDN";
    private List<String> memberships;
    private boolean membershipConservativePolicy;
    private boolean trustAllCerts;
    private boolean membershipsInOr = false;
    private String defaultPeopleContainer;
    private String defaultGroupContainer;
    private String defaultAnyObjectContainer;
    private String[] groupBaseContexts = new String[0];
    private String[] userBaseContexts = new String[0];
    private String[] anyObjectBaseContexts = new String[0];
    private String groupOwnerReferenceAttribute = "managedBy";
    private boolean pwdUpdateOnly = false;
    private boolean excludeAttributeChangesOnUpdate = false;
    private String defaultIdAttribute = "cn";
    private String[] userAuthenticationAttributes = new String[0];

    public ADConfiguration() {
        this.setAccountObjectClasses(new String[]{"top", "person", "organizationalPerson", "user"});
        this.setAccountUserNameAttributes(new String[]{"sAMAccountName", "cn", "member", "userPrincipalName"});
        this.setUidAttribute("sAMAccountName");
        this.setGroupObjectClasses(new String[]{"top", "group"});
        this.setGroupNameAttributes(new String[]{"sAMAccountName"});
        this.setGidAttribute("sAMAccountName");
        this.setAnyObjectClasses(new String[]{"top"});
        this.setAnyObjectNameAttributes(new String[]{"cn"});
        this.setAoidAttribute("cn");
        this.setDefaultIdAttribute("cn");
        this.setSynchronizePasswords(false);
        this.setObjectClassesToSynchronize(new String[]{"user"});
        this.setGroupMemberAttribute("member");
        this.setPasswordAttribute("unicodePwd");
        this.setPort(636);
        this.setSsl(true);
        this.setSyncStrategy("net.tirasa.connid.bundles.ad.sync.ADSyncStrategy");
        this.setFallbackSyncStrategyClass(ADSyncStrategy.class);
        this.setConnectionClass(ADConnection.class);
        this.memberships = new ArrayList<String>();
    }

    public DefaultSearchStrategy newDefaultSearchStrategy(boolean ignoreNonExistingBaseDN) {
        return new ADDefaultSearchStrategy(ignoreNonExistingBaseDN);
    }

    @ConfigurationProperty(displayMessageKey="memberships.display", helpMessageKey="memberships.help", order=1)
    public String[] getMemberships() {
        return this.memberships.toArray(new String[0]);
    }

    public void setMemberships(String ... memberships) {
        this.memberships = new ArrayList<String>();
        if (memberships != null) {
            for (String membership : memberships) {
                if (ADUtilities.isDN(membership)) {
                    this.memberships.add(membership.trim());
                    continue;
                }
                this.LOG.warn("Skip membership! \"{0}\" is not a valid distinguished name (DN)", new Object[]{membership});
            }
        }
    }

    @ConfigurationProperty(displayMessageKey="retrieveDeletedUser.display", helpMessageKey="retrieveDeletedUser.help", order=2)
    public boolean isRetrieveDeletedUser() {
        return this.retrieveDeletedUser;
    }

    public void setRetrieveDeletedUser(boolean retrieveDeletedUser) {
        this.retrieveDeletedUser = retrieveDeletedUser;
    }

    @ConfigurationProperty(displayMessageKey="retrieveDeletedGroup.display", helpMessageKey="retrieveDeletedGroup.help", order=3)
    public boolean isRetrieveDeletedGroup() {
        return this.retrieveDeletedGroup;
    }

    public void setRetrieveDeletedGroup(boolean retrieveDeletedGroup) {
        this.retrieveDeletedGroup = retrieveDeletedGroup;
    }

    @ConfigurationProperty(displayMessageKey="retrieveDeletedAnyObject.display", helpMessageKey="retrieveDeletedAnyObject.help", order=4)
    public boolean isRetrieveDeletedAnyObject() {
        return this.retrieveDeletedAnyObject;
    }

    public void setRetrieveDeletedAnyObject(boolean retrieveDeletedAnyObject) {
        this.retrieveDeletedAnyObject = retrieveDeletedAnyObject;
    }

    @ConfigurationProperty(displayMessageKey="trustAllCerts.display", helpMessageKey="trustAllCerts.help", order=5)
    public boolean isTrustAllCerts() {
        return this.trustAllCerts;
    }

    public void setTrustAllCerts(boolean trustAllCerts) {
        this.trustAllCerts = trustAllCerts;
    }

    public boolean isMembershipsInOr() {
        return this.membershipsInOr;
    }

    @ConfigurationProperty(displayMessageKey="membershipsInOr.display", helpMessageKey="membershipsInOr.help", order=6)
    public void setMembershipsInOr(boolean membershipsInOr) {
        this.membershipsInOr = membershipsInOr;
    }

    @ConfigurationProperty(displayMessageKey="defaultPeopleContainer.display", helpMessageKey="defaultPeopleContainer.help", order=7)
    public String getDefaultPeopleContainer() {
        if (StringUtil.isBlank((String)this.defaultPeopleContainer)) {
            return this.getBaseContexts() == null || this.getBaseContexts().length < 1 ? null : this.getBaseContexts()[0];
        }
        return this.defaultPeopleContainer;
    }

    public void setDefaultPeopleContainer(String defaultPeopleContainer) {
        this.defaultPeopleContainer = defaultPeopleContainer;
    }

    @ConfigurationProperty(displayMessageKey="defaultGroupContainer.display", helpMessageKey="defaultGroupContainer.help", order=8)
    public String getDefaultGroupContainer() {
        if (StringUtil.isBlank((String)this.defaultGroupContainer)) {
            return this.getBaseContexts() == null || this.getBaseContexts().length < 1 ? null : this.getBaseContexts()[0];
        }
        return this.defaultGroupContainer;
    }

    public void setDefaultGroupContainer(String defaultGroupContainer) {
        this.defaultGroupContainer = defaultGroupContainer;
    }

    @ConfigurationProperty(displayMessageKey="defaultAnyObjectContainer.display", helpMessageKey="defaultAnyObjectContainer.help", order=9)
    public String getDefaultAnyObjectContainer() {
        if (StringUtil.isBlank((String)this.defaultAnyObjectContainer)) {
            return this.getBaseContexts() == null || this.getBaseContexts().length < 1 ? null : this.getBaseContexts()[0];
        }
        return this.defaultAnyObjectContainer;
    }

    public void setDefaultAnyObjectContainer(String defaultAnyObjectContainer) {
        this.defaultAnyObjectContainer = defaultAnyObjectContainer;
    }

    @ConfigurationProperty(displayMessageKey="groupBaseContexts.display", helpMessageKey="groupBaseContexts.help", order=10)
    public String[] getGroupBaseContexts() {
        if (this.groupBaseContexts != null && this.groupBaseContexts.length > 0) {
            return (String[])this.groupBaseContexts.clone();
        }
        return this.getBaseContexts();
    }

    public void setGroupBaseContexts(String ... baseContexts) {
        this.groupBaseContexts = (String[])baseContexts.clone();
        super.setBaseContexts(this.getBaseContexts());
    }

    @ConfigurationProperty(displayMessageKey="userBaseContexts.display", helpMessageKey="userBaseContexts.help", order=11)
    public String[] getUserBaseContexts() {
        if (this.userBaseContexts != null && this.userBaseContexts.length > 0) {
            return (String[])this.userBaseContexts.clone();
        }
        return this.getBaseContexts();
    }

    public void setUserBaseContexts(String ... baseContexts) {
        this.userBaseContexts = (String[])baseContexts.clone();
        super.setBaseContexts(this.getBaseContexts());
    }

    @ConfigurationProperty(displayMessageKey="anyObjectBaseContexts.display", helpMessageKey="anyObjectBaseContexts.help", order=12)
    public String[] getAnyObjectBaseContexts() {
        if (this.anyObjectBaseContexts != null && this.anyObjectBaseContexts.length > 0) {
            return (String[])this.anyObjectBaseContexts.clone();
        }
        return this.getBaseContexts();
    }

    public void setAnyObjectBaseContexts(String ... baseContexts) {
        this.anyObjectBaseContexts = (String[])baseContexts.clone();
        super.setBaseContexts(this.getBaseContexts());
    }

    @ConfigurationProperty(displayMessageKey="groupOwnerReferenceAttribute.display", helpMessageKey="groupOwnerReferenceAttribute.help", order=13)
    public String getGroupOwnerReferenceAttribute() {
        return StringUtil.isBlank((String)this.groupOwnerReferenceAttribute) ? "managedBy" : this.groupOwnerReferenceAttribute;
    }

    public void setGroupOwnerReferenceAttribute(String groupOwnerReferenceAttribute) {
        this.groupOwnerReferenceAttribute = groupOwnerReferenceAttribute;
    }

    public boolean isPwdUpdateOnly() {
        return this.pwdUpdateOnly;
    }

    @ConfigurationProperty(displayMessageKey="pwdUpdateOnly.display", helpMessageKey="pwdUpdateOnly.help", required=true, order=14)
    public void setPwdUpdateOnly(boolean pwdUpdateOnly) {
        this.pwdUpdateOnly = pwdUpdateOnly;
    }

    @ConfigurationProperty(displayMessageKey="membershipConservativePolicy.display", helpMessageKey="membershipConservativePolicy.help", order=15)
    public boolean isMembershipConservativePolicy() {
        return this.membershipConservativePolicy;
    }

    public void setMembershipConservativePolicy(boolean membershipConservativePolicy) {
        this.membershipConservativePolicy = membershipConservativePolicy;
    }

    @ConfigurationProperty(order=16, displayMessageKey="defaultIdAttribute.display", helpMessageKey="defaultIdAttribute.help")
    public String getDefaultIdAttribute() {
        return this.defaultIdAttribute;
    }

    public void setDefaultIdAttribute(String defaultIdAttribute) {
        this.defaultIdAttribute = defaultIdAttribute;
    }

    @ConfigurationProperty(displayMessageKey="excludeAttributeChangesOnUpdate.display", helpMessageKey="excludeAttributeChangesOnUpdate.help", order=17)
    public boolean isExcludeAttributeChangesOnUpdate() {
        return this.excludeAttributeChangesOnUpdate;
    }

    public void setExcludeAttributeChangesOnUpdate(boolean excludeAttributeChangesOnUpdate) {
        this.excludeAttributeChangesOnUpdate = excludeAttributeChangesOnUpdate;
    }

    @ConfigurationProperty(displayMessageKey="userAuthenticationAttributes.display", helpMessageKey="userAuthenticationAttributes.help", order=18)
    public String[] getUserAuthenticationAttributes() {
        if (this.userAuthenticationAttributes != null && this.userAuthenticationAttributes.length > 0) {
            return (String[])this.userAuthenticationAttributes.clone();
        }
        return new String[0];
    }

    public void setUserAuthenticationAttributes(String ... userAuthenticationAttributes) {
        this.userAuthenticationAttributes = userAuthenticationAttributes == null || userAuthenticationAttributes.length == 0 ? new String[0] : (String[])userAuthenticationAttributes.clone();
    }
}

