/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationService;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.SurrogateAuthenticationException;
import org.apereo.cas.authentication.SurrogatePrincipalBuilder;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.SurrogateWebflowConfigurer;
import org.apereo.cas.web.flow.action.LoadSurrogatesListAction;
import org.apereo.cas.web.flow.action.SurrogateAuthorizationAction;
import org.apereo.cas.web.flow.action.SurrogateInitialAuthenticationAction;
import org.apereo.cas.web.flow.action.SurrogateSelectionAction;
import org.apereo.cas.web.flow.actions.WebflowActionBeanSupplier;
import org.apereo.cas.web.flow.authentication.CasWebflowExceptionCatalog;
import org.apereo.cas.web.flow.configurer.CasMultifactorWebflowCustomizer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.SurrogateAuthentication)
@AutoConfiguration
public class SurrogateAuthenticationWebflowConfiguration {

    @Configuration(value="SurrogateAuthenticationDuoSecurityWebflowPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.MultifactorAuthentication, module="duo")
    @ConditionalOnClass(value={DuoSecurityAuthenticationService.class})
    public static class SurrogateAuthenticationDuoSecurityWebflowPlanConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"surrogateDuoSecurityMultifactorAuthenticationWebflowExecutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExecutionPlanConfigurer surrogateDuoSecurityMultifactorAuthenticationWebflowExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="surrogateDuoSecurityMultifactorAuthenticationWebflowConfigurer") CasWebflowConfigurer surrogateWebflowConfigurer) {
            return (CasWebflowExecutionPlanConfigurer)BeanSupplier.of(CasWebflowExecutionPlanConfigurer.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerWebflowConfigurer(surrogateWebflowConfigurer)).otherwiseProxy().get();
        }
    }

    @Configuration(value="SurrogateAuthenticationWebflowPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SurrogateAuthenticationWebflowPlanConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"surrogateCasWebflowExecutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExecutionPlanConfigurer surrogateCasWebflowExecutionPlanConfigurer(@Qualifier(value="surrogateWebflowConfigurer") CasWebflowConfigurer surrogateWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(surrogateWebflowConfigurer);
        }
    }

    @Configuration(value="SurrogateAuthenticationInitializerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SurrogateAuthenticationInitializerConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public InitializingBean surrogateAuthenticationWebflowInitializer(@Qualifier(value="handledAuthenticationExceptions") CasWebflowExceptionCatalog handledAuthenticationExceptions) {
            return () -> handledAuthenticationExceptions.registerException(SurrogateAuthenticationException.class);
        }
    }

    @Configuration(value="SurrogateAuthenticationWebflowActionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SurrogateAuthenticationWebflowActionConfiguration {
        @ConditionalOnMissingBean(name={"selectSurrogateAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action selectSurrogateAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="surrogatePrincipalBuilder") SurrogatePrincipalBuilder surrogatePrincipalBuilder) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new SurrogateSelectionAction(surrogatePrincipalBuilder)).withId("selectSurrogateAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"surrogateInitialAuthenticationAction"})
        public Action surrogateInitialAuthenticationAction(CasConfigurationProperties casProperties) {
            return new SurrogateInitialAuthenticationAction(casProperties.getAuthn().getSurrogate().getSeparator());
        }

        @ConditionalOnMissingBean(name={"surrogateAuthorizationCheck"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action surrogateAuthorizationCheck(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new SurrogateAuthorizationAction(registeredServiceAccessStrategyEnforcer)).withId("surrogateAuthorizationCheck").build().get();
        }

        @ConditionalOnMissingBean(name={"loadSurrogatesListAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action loadSurrogatesListAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="surrogateAuthenticationService") SurrogateAuthenticationService surrogateAuthenticationService, @Qualifier(value="surrogatePrincipalBuilder") SurrogatePrincipalBuilder surrogatePrincipalBuilder) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new LoadSurrogatesListAction(surrogateAuthenticationService, surrogatePrincipalBuilder)).withId("loadSurrogatesListAction").build().get();
        }
    }

    @Configuration(value="SurrogateAuthenticationWebflowBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class SurrogateAuthenticationWebflowBaseConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnClass(value={DuoSecurityAuthenticationService.class})
        @ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.MultifactorAuthentication, module="duo")
        public CasMultifactorWebflowCustomizer surrogateCasMultifactorWebflowCustomizer(ConfigurableApplicationContext applicationContext) {
            return (CasMultifactorWebflowCustomizer)BeanSupplier.of(CasMultifactorWebflowCustomizer.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new CasMultifactorWebflowCustomizer(){

                public List<String> getWebflowAttributeMappings() {
                    return List.of("requestSurrogateAccount");
                }
            }).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"surrogateWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer surrogateWebflowConfigurer(@Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return new SurrogateWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
        }

        @Bean
        @ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.MultifactorAuthentication, module="duo")
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnClass(value={DuoSecurityAuthenticationService.class})
        @ConditionalOnMissingBean(name={"surrogateDuoSecurityMultifactorAuthenticationWebflowConfigurer"})
        public CasWebflowConfigurer surrogateDuoSecurityMultifactorAuthenticationWebflowConfigurer(@Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return (CasWebflowConfigurer)BeanSupplier.of(CasWebflowConfigurer.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new SurrogateWebflowConfigurer.DuoSecurityMultifactorAuthenticationWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties)).otherwiseProxy().get();
        }
    }
}

